/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.wms;

import java.util.Collections;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.factory.wms.Code;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.ProjectedCRS;

abstract class Factlet {
    Factlet() {
    }

    public abstract int code();

    public abstract String getName();

    public abstract String getClassification();

    public final ProjectedCRS create(Code code, FactoryGroup factories) throws FactoryException {
        String classification = this.getClassification();
        ParameterValueGroup parameters = factories.getMathTransformFactory().getDefaultParameters(classification);
        this.setProjectionParameters(parameters, code);
        return factories.createProjectedCRS(Collections.singletonMap("name", this.getName()), DefaultGeographicCRS.WGS84, null, parameters, DefaultCartesianCS.PROJECTED);
    }

    protected abstract void setProjectionParameters(ParameterValueGroup var1, Code var2);
}

