/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.units.ConversionException;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.quality.PositionalAccuracyImpl;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.operation.AbstractCoordinateOperation;
import org.geotools.referencing.operation.DefaultConcatenatedOperation;
import org.geotools.referencing.operation.DefaultOperation;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.Singleton;
import org.geotools.util.WeakHashSet;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.Transformation;

public abstract class AbstractCoordinateOperationFactory
extends ReferencingFactory
implements CoordinateOperationFactory {
    protected static final Identifier IDENTITY;
    protected static final Identifier AXIS_CHANGES;
    protected static final Identifier DATUM_SHIFT;
    protected static final Identifier ELLIPSOID_SHIFT;
    protected static final Identifier GEOCENTRIC_CONVERSION;
    protected static final Identifier INVERSE_OPERATION;
    private static final String NAME_KEY = "name";
    private final FactoryGroup factories;
    protected final MathTransformFactory mtFactory;
    private final WeakHashSet pool = new WeakHashSet();
    private boolean hintsInitialized;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractCoordinateOperationFactory(Hints hints) {
        this(hints, 50);
    }

    public AbstractCoordinateOperationFactory(Hints hints, int priority) {
        super(priority);
        this.factories = FactoryGroup.createInstance(hints);
        this.mtFactory = this.factories.getMathTransformFactory();
    }

    AbstractCoordinateOperationFactory(CoordinateOperationFactory factory, Hints hints, int priority) {
        super(priority);
        this.factories = factory instanceof AbstractCoordinateOperationFactory ? ((AbstractCoordinateOperationFactory)factory).getFactoryGroup() : FactoryGroup.createInstance(hints);
        this.mtFactory = this.factories.getMathTransformFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getImplementationHints() {
        Map map = this.hints;
        synchronized (map) {
            if (!this.hintsInitialized) {
                this.initializeHints();
                this.hintsInitialized = true;
            }
        }
        return super.getImplementationHints();
    }

    void initializeHints() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.hints)) {
            throw new AssertionError();
        }
        this.hints.putAll(this.getFactoryGroup().getImplementationHints());
    }

    public final MathTransformFactory getMathTransformFactory() {
        return this.mtFactory;
    }

    final FactoryGroup getFactoryGroup() {
        return this.factories;
    }

    protected Matrix swapAndScaleAxis(CoordinateSystem sourceCS, CoordinateSystem targetCS) throws OperationNotFoundException {
        try {
            return AbstractCS.swapAndScaleAxis(sourceCS, targetCS);
        }
        catch (IllegalArgumentException exception) {
            throw new OperationNotFoundException(AbstractCoordinateOperationFactory.getErrorMessage(sourceCS, targetCS), exception);
        }
        catch (ConversionException exception) {
            throw new OperationNotFoundException(AbstractCoordinateOperationFactory.getErrorMessage(sourceCS, targetCS), exception);
        }
    }

    private static Map getProperties(Identifier name) {
        Map<Object, Object> properties;
        if (name == DATUM_SHIFT || name == ELLIPSOID_SHIFT) {
            properties = new HashMap<String, Identifier>(4);
            properties.put(NAME_KEY, name);
            properties.put("positionalAccuracy", new PositionalAccuracy[]{name == DATUM_SHIFT ? PositionalAccuracyImpl.DATUM_SHIFT_APPLIED : PositionalAccuracyImpl.DATUM_SHIFT_OMITTED});
        } else {
            properties = Collections.singletonMap(NAME_KEY, name);
        }
        return properties;
    }

    protected CoordinateOperation createFromAffineTransform(Identifier name, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Matrix matrix) throws FactoryException {
        MathTransform transform = this.mtFactory.createAffineTransform(matrix);
        Map properties = AbstractCoordinateOperationFactory.getProperties(name);
        Class clazz = properties.containsKey("positionalAccuracy") ? Transformation.class : Conversion.class;
        Class type = clazz;
        return this.createFromMathTransform(properties, sourceCRS, targetCRS, transform, ProjectiveTransform.ProviderAffine.getProvider(transform.getSourceDimensions(), transform.getTargetDimensions()), type);
    }

    protected CoordinateOperation createFromParameters(Identifier name, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, ParameterValueGroup parameters) throws FactoryException {
        Singleton method = new Singleton();
        Map properties = AbstractCoordinateOperationFactory.getProperties(name);
        MathTransform transform = this.getFactoryGroup().createParameterizedTransform(parameters, method);
        return this.createFromMathTransform(properties, sourceCRS, targetCRS, transform, (OperationMethod)method.get(), Operation.class);
    }

    protected CoordinateOperation createFromMathTransform(Identifier name, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) throws FactoryException {
        return this.createFromMathTransform(Collections.singletonMap(NAME_KEY, name), sourceCRS, targetCRS, transform, null, CoordinateOperation.class);
    }

    protected CoordinateOperation createFromMathTransform(Map properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, OperationMethod method, Class type) throws FactoryException {
        CoordinateOperation operation;
        if (transform instanceof CoordinateOperation && Utilities.equals((operation = (CoordinateOperation)((Object)transform)).getSourceCRS(), sourceCRS) && Utilities.equals(operation.getTargetCRS(), targetCRS) && Utilities.equals(operation.getMathTransform(), transform)) {
            if (operation instanceof Operation) {
                if (Utilities.equals(((Operation)operation).getMethod(), method)) {
                    return operation;
                }
            } else {
                return operation;
            }
        }
        operation = DefaultOperation.create(properties, sourceCRS, targetCRS, transform, method, type);
        operation = (CoordinateOperation)this.pool.canonicalize(operation);
        return operation;
    }

    public CoordinateOperation createConcatenatedOperation(Map properties, CoordinateOperation[] operations) throws FactoryException {
        CoordinateOperation operation = new DefaultConcatenatedOperation(properties, operations, this.mtFactory);
        operation = (CoordinateOperation)this.pool.canonicalize(operation);
        return operation;
    }

    protected CoordinateOperation concatenate(CoordinateOperation step1, CoordinateOperation step2) throws FactoryException {
        if (step1 == null) {
            return step2;
        }
        if (step2 == null) {
            return step1;
        }
        if (AbstractCoordinateOperationFactory.isIdentity(step1)) {
            return step2;
        }
        if (AbstractCoordinateOperationFactory.isIdentity(step2)) {
            return step1;
        }
        MathTransform mt1 = step1.getMathTransform();
        MathTransform mt2 = step2.getMathTransform();
        CoordinateReferenceSystem sourceCRS = step1.getSourceCRS();
        CoordinateReferenceSystem targetCRS = step2.getTargetCRS();
        CoordinateOperation step = null;
        if (step1.getName() == AXIS_CHANGES && mt1.getSourceDimensions() == mt1.getTargetDimensions()) {
            step = step2;
        }
        if (step2.getName() == AXIS_CHANGES && mt2.getSourceDimensions() == mt2.getTargetDimensions()) {
            step = step1;
        }
        if (step instanceof Operation) {
            return this.createFromMathTransform(AbstractIdentifiedObject.getProperties(step), sourceCRS, targetCRS, this.mtFactory.createConcatenatedTransform(mt1, mt2), ((Operation)step).getMethod(), CoordinateOperation.class);
        }
        return this.createConcatenatedOperation(AbstractCoordinateOperationFactory.getTemporaryName(sourceCRS, targetCRS), new CoordinateOperation[]{step1, step2});
    }

    protected CoordinateOperation concatenate(CoordinateOperation step1, CoordinateOperation step2, CoordinateOperation step3) throws FactoryException {
        if (step1 == null) {
            return this.concatenate(step2, step3);
        }
        if (step2 == null) {
            return this.concatenate(step1, step3);
        }
        if (step3 == null) {
            return this.concatenate(step1, step2);
        }
        if (!$assertionsDisabled && !AbstractCoordinateOperationFactory.equalsIgnoreMetadata(step1.getTargetCRS(), step2.getSourceCRS())) {
            throw new AssertionError(step1);
        }
        if (!$assertionsDisabled && !AbstractCoordinateOperationFactory.equalsIgnoreMetadata(step2.getTargetCRS(), step3.getSourceCRS())) {
            throw new AssertionError(step3);
        }
        if (AbstractCoordinateOperationFactory.isIdentity(step1)) {
            return this.concatenate(step2, step3);
        }
        if (AbstractCoordinateOperationFactory.isIdentity(step2)) {
            return this.concatenate(step1, step3);
        }
        if (AbstractCoordinateOperationFactory.isIdentity(step3)) {
            return this.concatenate(step1, step2);
        }
        if (step1.getName() == AXIS_CHANGES) {
            return this.concatenate(this.concatenate(step1, step2), step3);
        }
        if (step3.getName() == AXIS_CHANGES) {
            return this.concatenate(step1, this.concatenate(step2, step3));
        }
        CoordinateReferenceSystem sourceCRS = step1.getSourceCRS();
        CoordinateReferenceSystem targetCRS = step3.getTargetCRS();
        return this.createConcatenatedOperation(AbstractCoordinateOperationFactory.getTemporaryName(sourceCRS, targetCRS), new CoordinateOperation[]{step1, step2, step3});
    }

    private static boolean isIdentity(CoordinateOperation operation) {
        return operation instanceof Conversion && operation.getMathTransform().isIdentity();
    }

    protected CoordinateOperation inverse(CoordinateOperation operation) throws NoninvertibleTransformException, FactoryException {
        CoordinateReferenceSystem sourceCRS = operation.getSourceCRS();
        CoordinateReferenceSystem targetCRS = operation.getTargetCRS();
        Map properties = AbstractIdentifiedObject.getProperties(operation, null);
        properties.putAll(AbstractCoordinateOperationFactory.getTemporaryName(targetCRS, sourceCRS));
        if (operation instanceof ConcatenatedOperation) {
            LinkedList<CoordinateOperation> inverted = new LinkedList<CoordinateOperation>();
            Iterator it = ((ConcatenatedOperation)operation).getOperations().iterator();
            while (it.hasNext()) {
                inverted.addFirst(this.inverse((CoordinateOperation)it.next()));
            }
            return this.createConcatenatedOperation(properties, inverted.toArray(new CoordinateOperation[inverted.size()]));
        }
        MathTransform transform = operation.getMathTransform().inverse();
        Class type = AbstractCoordinateOperation.getType(operation);
        OperationMethod method = operation instanceof Operation ? ((Operation)operation).getMethod() : null;
        return this.createFromMathTransform(properties, targetCRS, sourceCRS, transform, method, type);
    }

    static int getDimension(CoordinateReferenceSystem crs) {
        return crs != null ? crs.getCoordinateSystem().getDimension() : 0;
    }

    private static String getClassName(IdentifiedObject object) {
        if (object != null) {
            Class<?> type = object.getClass();
            Class<?>[] interfaces = type.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> candidate = interfaces[i];
                if (!candidate.getName().startsWith("org.opengis.referencing.")) continue;
                type = candidate;
                break;
            }
            String name = Utilities.getShortName(type);
            Identifier id = object.getName();
            if (id != null) {
                name = name + '[' + id.getCode() + ']';
            }
            return name;
        }
        return null;
    }

    static Map getTemporaryName(IdentifiedObject source) {
        HashMap<String, Comparable> properties = new HashMap<String, Comparable>(4);
        properties.put(NAME_KEY, new TemporaryIdentifier(source.getName()));
        properties.put("remarks", Vocabulary.formatInternational(209, AbstractCoordinateOperationFactory.getClassName(source)));
        return properties;
    }

    static Map getTemporaryName(CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        String name = AbstractCoordinateOperationFactory.getClassName(source) + " \u21e8 " + AbstractCoordinateOperationFactory.getClassName(target);
        return Collections.singletonMap(NAME_KEY, name);
    }

    static boolean equalsIgnoreMetadata(IdentifiedObject object1, IdentifiedObject object2) {
        return CRSUtilities.equalsIgnoreMetadata(object1, object2);
    }

    protected static String getErrorMessage(IdentifiedObject source, IdentifiedObject target) {
        return Errors.format(102, AbstractCoordinateOperationFactory.getClassName(source), AbstractCoordinateOperationFactory.getClassName(target));
    }

    protected static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format(105, name));
        }
    }

    static {
        $assertionsDisabled = !AbstractCoordinateOperationFactory.class.desiredAssertionStatus();
        IDENTITY = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(207));
        AXIS_CHANGES = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(204));
        DATUM_SHIFT = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(205));
        ELLIPSOID_SHIFT = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(206));
        GEOCENTRIC_CONVERSION = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(53));
        INVERSE_OPERATION = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(208));
    }

    private static final class TemporaryIdentifier
    extends NamedIdentifier {
        private final Identifier parent;
        private final int count;

        public TemporaryIdentifier(Identifier parent) {
            this(parent, (parent instanceof TemporaryIdentifier ? ((TemporaryIdentifier)parent).count : 0) + 1);
        }

        private TemporaryIdentifier(Identifier parent, int count) {
            super(Citations.GEOTOOLS, TemporaryIdentifier.unwrap(parent).getCode() + " (step " + count + ')');
            this.parent = parent;
            this.count = count;
        }

        public static Identifier unwrap(Identifier identifier) {
            while (identifier instanceof TemporaryIdentifier) {
                identifier = ((TemporaryIdentifier)identifier).parent;
            }
            return identifier;
        }
    }
}

