/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Map;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import javax.vecmath.SingularMatrixException;
import org.geotools.factory.Hints;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.operation.AbstractCoordinateOperationFactory;
import org.geotools.referencing.operation.DefaultPassThroughOperation;
import org.geotools.referencing.operation.matrix.Matrix4;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;

public class DefaultCoordinateOperationFactory
extends AbstractCoordinateOperationFactory {
    static final int PRIORITY = 50;
    private static final Unit MILLISECOND;
    private final String molodenskiMethod;
    private final boolean lenientDatumShift;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$opengis$referencing$datum$Datum;

    public DefaultCoordinateOperationFactory() {
        this(null);
    }

    public DefaultCoordinateOperationFactory(Hints hints) {
        this(hints, 50);
    }

    public DefaultCoordinateOperationFactory(Hints hints, int priority) {
        super(hints, priority);
        String molodenskiMethod = "Molodenski";
        boolean lenientDatumShift = false;
        if (hints != null) {
            Object candidate = hints.get(Hints.DATUM_SHIFT_METHOD);
            if (candidate instanceof String && (molodenskiMethod = (String)candidate).trim().equalsIgnoreCase("Geocentric")) {
                molodenskiMethod = null;
            }
            if ((candidate = hints.get(Hints.LENIENT_DATUM_SHIFT)) instanceof Boolean) {
                lenientDatumShift = (Boolean)candidate;
            }
        }
        this.molodenskiMethod = molodenskiMethod;
        this.lenientDatumShift = lenientDatumShift;
        this.hints.put(Hints.DATUM_SHIFT_METHOD, molodenskiMethod);
        this.hints.put(Hints.LENIENT_DATUM_SHIFT, lenientDatumShift);
    }

    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws OperationNotFoundException, FactoryException {
        CoordinateReferenceSystem target;
        CoordinateReferenceSystem source;
        DefaultCoordinateOperationFactory.ensureNonNull("sourceCRS", sourceCRS);
        DefaultCoordinateOperationFactory.ensureNonNull("targetCRS", targetCRS);
        if (DefaultCoordinateOperationFactory.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
            int dim = DefaultCoordinateOperationFactory.getDimension(sourceCRS);
            if (!$assertionsDisabled && dim != DefaultCoordinateOperationFactory.getDimension(targetCRS)) {
                throw new AssertionError(dim);
            }
            return this.createFromAffineTransform(IDENTITY, sourceCRS, targetCRS, MatrixFactory.create(dim + 1));
        }
        CoordinateOperation candidate = this.createFromDatabase(sourceCRS, targetCRS);
        if (candidate != null) {
            return candidate;
        }
        if (sourceCRS instanceof GeographicCRS) {
            source = (GeographicCRS)sourceCRS;
            if (targetCRS instanceof GeographicCRS) {
                GeographicCRS target2 = (GeographicCRS)targetCRS;
                return this.createOperationStep((GeographicCRS)source, target2);
            }
            if (targetCRS instanceof ProjectedCRS) {
                ProjectedCRS target3 = (ProjectedCRS)targetCRS;
                return this.createOperationStep((GeographicCRS)source, target3);
            }
            if (targetCRS instanceof GeocentricCRS) {
                GeocentricCRS target4 = (GeocentricCRS)targetCRS;
                return this.createOperationStep((GeographicCRS)source, target4);
            }
            if (targetCRS instanceof VerticalCRS) {
                VerticalCRS target5 = (VerticalCRS)targetCRS;
                return this.createOperationStep((GeographicCRS)source, target5);
            }
        }
        if (sourceCRS instanceof ProjectedCRS) {
            source = (ProjectedCRS)sourceCRS;
            if (targetCRS instanceof ProjectedCRS) {
                ProjectedCRS target6 = (ProjectedCRS)targetCRS;
                return this.createOperationStep((ProjectedCRS)source, target6);
            }
            if (targetCRS instanceof GeographicCRS) {
                GeographicCRS target7 = (GeographicCRS)targetCRS;
                return this.createOperationStep((ProjectedCRS)source, target7);
            }
        }
        if (sourceCRS instanceof GeocentricCRS) {
            source = (GeocentricCRS)sourceCRS;
            if (targetCRS instanceof GeocentricCRS) {
                GeocentricCRS target8 = (GeocentricCRS)targetCRS;
                return this.createOperationStep((GeocentricCRS)source, target8);
            }
            if (targetCRS instanceof GeographicCRS) {
                GeographicCRS target9 = (GeographicCRS)targetCRS;
                return this.createOperationStep((GeocentricCRS)source, target9);
            }
        }
        if (sourceCRS instanceof VerticalCRS) {
            source = (VerticalCRS)sourceCRS;
            if (targetCRS instanceof VerticalCRS) {
                VerticalCRS target10 = (VerticalCRS)targetCRS;
                return this.createOperationStep((VerticalCRS)source, target10);
            }
        }
        if (sourceCRS instanceof TemporalCRS) {
            source = (TemporalCRS)sourceCRS;
            if (targetCRS instanceof TemporalCRS) {
                TemporalCRS target11 = (TemporalCRS)targetCRS;
                return this.createOperationStep((TemporalCRS)source, target11);
            }
        }
        if (targetCRS instanceof GeneralDerivedCRS) {
            target = (GeneralDerivedCRS)targetCRS;
            CoordinateReferenceSystem base = target.getBaseCRS();
            CoordinateOperation step1 = this.createOperation(sourceCRS, base);
            Conversion step2 = target.getConversionFromBase();
            return this.concatenate(step1, step2);
        }
        if (sourceCRS instanceof GeneralDerivedCRS) {
            source = (GeneralDerivedCRS)sourceCRS;
            CoordinateReferenceSystem base = source.getBaseCRS();
            CoordinateOperation step2 = this.createOperation(base, targetCRS);
            CoordinateOperation step1 = source.getConversionFromBase();
            MathTransform transform = step1.getMathTransform();
            try {
                transform = transform.inverse();
            }
            catch (NoninvertibleTransformException exception) {
                throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceCRS, base), exception);
            }
            step1 = this.createFromMathTransform(INVERSE_OPERATION, sourceCRS, base, transform);
            return this.concatenate(step1, step2);
        }
        if (sourceCRS instanceof CompoundCRS) {
            source = (CompoundCRS)sourceCRS;
            if (targetCRS instanceof CompoundCRS) {
                CompoundCRS target12 = (CompoundCRS)targetCRS;
                return this.createOperationStep((CompoundCRS)source, target12);
            }
            if (targetCRS instanceof SingleCRS) {
                SingleCRS target13 = (SingleCRS)targetCRS;
                return this.createOperationStep((CompoundCRS)source, target13);
            }
        }
        if (targetCRS instanceof CompoundCRS) {
            target = (CompoundCRS)targetCRS;
            if (sourceCRS instanceof SingleCRS) {
                SingleCRS source2 = (SingleCRS)sourceCRS;
                return this.createOperationStep(source2, (CompoundCRS)target);
            }
        }
        if (sourceCRS == DefaultEngineeringCRS.GENERIC_2D || targetCRS == DefaultEngineeringCRS.GENERIC_2D || sourceCRS == DefaultEngineeringCRS.GENERIC_3D || targetCRS == DefaultEngineeringCRS.GENERIC_3D) {
            int dimSource = DefaultCoordinateOperationFactory.getDimension(sourceCRS);
            int dimTarget = DefaultCoordinateOperationFactory.getDimension(targetCRS);
            if (dimTarget == dimSource) {
                XMatrix matrix = MatrixFactory.create(dimTarget + 1, dimSource + 1);
                return this.createFromAffineTransform(IDENTITY, sourceCRS, targetCRS, matrix);
            }
        }
        throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceCRS, targetCRS));
    }

    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, OperationMethod method) throws OperationNotFoundException, FactoryException {
        return this.createOperation(sourceCRS, targetCRS);
    }

    private GeocentricCRS normalize(GeocentricCRS crs, GeodeticDatum datum) throws FactoryException {
        DefaultCartesianCS STANDARD = DefaultCartesianCS.GEOCENTRIC;
        GeodeticDatum candidate = (GeodeticDatum)crs.getDatum();
        if (DefaultCoordinateOperationFactory.equalsIgnorePrimeMeridian(candidate, datum) && DefaultCoordinateOperationFactory.getGreenwichLongitude(candidate.getPrimeMeridian()) == DefaultCoordinateOperationFactory.getGreenwichLongitude(datum.getPrimeMeridian()) && DefaultCoordinateOperationFactory.hasStandardAxis(crs.getCoordinateSystem(), STANDARD)) {
            return crs;
        }
        CRSFactory crsFactory = this.getFactoryGroup().getCRSFactory();
        return crsFactory.createGeocentricCRS(DefaultCoordinateOperationFactory.getTemporaryName(crs), datum, STANDARD);
    }

    private GeographicCRS normalize(GeographicCRS crs, boolean forceGreenwich) throws FactoryException {
        DefaultEllipsoidalCS STANDARD;
        GeodeticDatum datum = (GeodeticDatum)crs.getDatum();
        EllipsoidalCS cs = (EllipsoidalCS)crs.getCoordinateSystem();
        DefaultEllipsoidalCS defaultEllipsoidalCS = STANDARD = cs.getDimension() <= 2 ? DefaultEllipsoidalCS.GEODETIC_2D : DefaultEllipsoidalCS.GEODETIC_3D;
        if (forceGreenwich && DefaultCoordinateOperationFactory.getGreenwichLongitude(datum.getPrimeMeridian()) != 0.0) {
            datum = new TemporaryDatum(datum);
        } else if (DefaultCoordinateOperationFactory.hasStandardAxis(cs, STANDARD)) {
            return crs;
        }
        CRSFactory crsFactory = this.getFactoryGroup().getCRSFactory();
        return crsFactory.createGeographicCRS(DefaultCoordinateOperationFactory.getTemporaryName(crs), datum, STANDARD);
    }

    private static boolean hasStandardAxis(CoordinateSystem cs, CoordinateSystem standard) {
        int dimension = standard.getDimension();
        if (cs.getDimension() != dimension) {
            return false;
        }
        for (int i = 0; i < dimension; ++i) {
            CoordinateSystemAxis a1 = cs.getAxis(i);
            CoordinateSystemAxis a2 = standard.getAxis(i);
            if (a1.getDirection().equals(a2.getDirection()) && a1.getUnit().equals(a2.getUnit())) continue;
            return false;
        }
        return true;
    }

    private Matrix swapAndScaleAxis(EllipsoidalCS sourceCS, EllipsoidalCS targetCS, PrimeMeridian sourcePM, PrimeMeridian targetPM) throws OperationNotFoundException {
        Matrix matrix = this.swapAndScaleAxis(sourceCS, targetCS);
        int i = targetCS.getDimension();
        while (--i >= 0) {
            CoordinateSystemAxis axis = targetCS.getAxis(i);
            AxisDirection direction = axis.getDirection();
            if (!AxisDirection.EAST.equals(direction.absolute())) continue;
            Unit unit = axis.getUnit();
            double sourceLongitude = DefaultCoordinateOperationFactory.getGreenwichLongitude(sourcePM, unit);
            double targetLongitude = DefaultCoordinateOperationFactory.getGreenwichLongitude(targetPM, unit);
            int lastMatrixColumn = matrix.getNumCol() - 1;
            double rotate = sourceLongitude - targetLongitude;
            if (AxisDirection.WEST.equals(direction)) {
                rotate = -rotate;
            }
            matrix.setElement(i, lastMatrixColumn, rotate += matrix.getElement(i, lastMatrixColumn));
        }
        return matrix;
    }

    private static double getGreenwichLongitude(PrimeMeridian pm, Unit unit) {
        return pm.getAngularUnit().getConverterTo(unit).convert(pm.getGreenwichLongitude());
    }

    private static double getGreenwichLongitude(PrimeMeridian pm) {
        return DefaultCoordinateOperationFactory.getGreenwichLongitude(pm, NonSI.DEGREE_ANGLE);
    }

    private static Matrix createLinearConversion(ProjectedCRS sourceCRS, ProjectedCRS targetCRS) {
        return DefaultProjectedCRS.createLinearConversion(sourceCRS, targetCRS, 1.0E-10);
    }

    protected CoordinateOperation createOperationStep(TemporalCRS sourceCRS, TemporalCRS targetCRS) throws FactoryException {
        TemporalDatum targetDatum;
        TemporalDatum sourceDatum = (TemporalDatum)sourceCRS.getDatum();
        if (!DefaultCoordinateOperationFactory.equalsIgnoreMetadata(sourceDatum, targetDatum = (TemporalDatum)targetCRS.getDatum())) {
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceDatum, targetDatum));
        }
        TimeCS sourceCS = (TimeCS)sourceCRS.getCoordinateSystem();
        TimeCS targetCS = (TimeCS)targetCRS.getCoordinateSystem();
        Unit targetUnit = targetCS.getAxis(0).getUnit();
        double epochShift = sourceDatum.getOrigin().getTime() - targetDatum.getOrigin().getTime();
        epochShift = MILLISECOND.getConverterTo(targetUnit).convert(epochShift);
        Matrix matrix = this.swapAndScaleAxis(sourceCS, targetCS);
        int translationColumn = matrix.getNumCol() - 1;
        if (translationColumn >= 0) {
            double translation = matrix.getElement(0, translationColumn);
            matrix.setElement(0, translationColumn, translation + epochShift);
        }
        return this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, matrix);
    }

    protected CoordinateOperation createOperationStep(VerticalCRS sourceCRS, VerticalCRS targetCRS) throws FactoryException {
        VerticalDatum targetDatum;
        VerticalDatum sourceDatum = (VerticalDatum)sourceCRS.getDatum();
        if (!DefaultCoordinateOperationFactory.equalsIgnoreMetadata(sourceDatum, targetDatum = (VerticalDatum)targetCRS.getDatum())) {
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceDatum, targetDatum));
        }
        VerticalCS sourceCS = (VerticalCS)sourceCRS.getCoordinateSystem();
        VerticalCS targetCS = (VerticalCS)targetCRS.getCoordinateSystem();
        Matrix matrix = this.swapAndScaleAxis(sourceCS, targetCS);
        return this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, matrix);
    }

    protected CoordinateOperation createOperationStep(GeographicCRS sourceCRS, VerticalCRS targetCRS) throws FactoryException {
        if (VerticalDatumType.ELLIPSOIDAL.equals(((VerticalDatum)targetCRS.getDatum()).getVerticalDatumType())) {
            Matrix matrix = this.swapAndScaleAxis(sourceCRS.getCoordinateSystem(), targetCRS.getCoordinateSystem());
            return this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, matrix);
        }
        throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceCRS, targetCRS));
    }

    protected CoordinateOperation createOperationStep(GeographicCRS sourceCRS, GeographicCRS targetCRS) throws FactoryException {
        EllipsoidalCS sourceCS = (EllipsoidalCS)sourceCRS.getCoordinateSystem();
        EllipsoidalCS targetCS = (EllipsoidalCS)targetCRS.getCoordinateSystem();
        GeodeticDatum sourceDatum = (GeodeticDatum)sourceCRS.getDatum();
        GeodeticDatum targetDatum = (GeodeticDatum)targetCRS.getDatum();
        PrimeMeridian sourcePM = sourceDatum.getPrimeMeridian();
        PrimeMeridian targetPM = targetDatum.getPrimeMeridian();
        if (DefaultCoordinateOperationFactory.equalsIgnorePrimeMeridian(sourceDatum, targetDatum)) {
            Matrix matrix = this.swapAndScaleAxis(sourceCS, targetCS, sourcePM, targetPM);
            return this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, matrix);
        }
        if (this.molodenskiMethod != null) {
            Identifier identifier = DATUM_SHIFT;
            BursaWolfParameters bursaWolf = null;
            if (sourceDatum instanceof DefaultGeodeticDatum) {
                bursaWolf = ((DefaultGeodeticDatum)sourceDatum).getBursaWolfParameters(targetDatum);
            }
            if (bursaWolf == null) {
                Matrix shift = DefaultGeodeticDatum.getAffineTransform(sourceDatum, targetDatum);
                if (shift != null) {
                    try {
                        bursaWolf = new BursaWolfParameters(targetDatum);
                        bursaWolf.setAffineTransform(shift, 1.0E-4);
                    }
                    catch (IllegalArgumentException ignore) {}
                } else if (this.lenientDatumShift) {
                    bursaWolf = new BursaWolfParameters(targetDatum);
                    identifier = ELLIPSOID_SHIFT;
                }
            }
            if (bursaWolf != null && bursaWolf.isTranslation()) {
                Ellipsoid sourceEllipsoid = sourceDatum.getEllipsoid();
                Ellipsoid targetEllipsoid = targetDatum.getEllipsoid();
                if (bursaWolf.isIdentity() && DefaultCoordinateOperationFactory.equalsIgnoreMetadata(sourceEllipsoid, targetEllipsoid)) {
                    Matrix matrix = this.swapAndScaleAxis(sourceCS, targetCS, sourcePM, targetPM);
                    return this.createFromAffineTransform(identifier, sourceCRS, targetCRS, matrix);
                }
                int sourceDim = DefaultCoordinateOperationFactory.getDimension(sourceCRS);
                int targetDim = DefaultCoordinateOperationFactory.getDimension(targetCRS);
                ParameterValueGroup parameters = this.getMathTransformFactory().getDefaultParameters(this.molodenskiMethod);
                parameters.parameter("src_semi_major").setValue(sourceEllipsoid.getSemiMajorAxis());
                parameters.parameter("src_semi_minor").setValue(sourceEllipsoid.getSemiMinorAxis());
                parameters.parameter("tgt_semi_major").setValue(targetEllipsoid.getSemiMajorAxis());
                parameters.parameter("tgt_semi_minor").setValue(targetEllipsoid.getSemiMinorAxis());
                parameters.parameter("dx").setValue(bursaWolf.dx);
                parameters.parameter("dy").setValue(bursaWolf.dy);
                parameters.parameter("dz").setValue(bursaWolf.dz);
                parameters.parameter("dim").setValue(sourceDim);
                if (sourceDim == targetDim) {
                    GeographicCRS normSourceCRS = this.normalize(sourceCRS, true);
                    GeographicCRS normTargetCRS = this.normalize(targetCRS, true);
                    CoordinateOperation step1 = this.createOperationStep(sourceCRS, normSourceCRS);
                    CoordinateOperation step2 = this.createFromParameters(identifier, normSourceCRS, normTargetCRS, parameters);
                    CoordinateOperation step3 = this.createOperationStep(normTargetCRS, targetCRS);
                    return this.concatenate(step1, step2, step3);
                }
            }
        }
        DefaultCartesianCS STANDARD = DefaultCartesianCS.GEOCENTRIC;
        CRSFactory crsFactory = this.getFactoryGroup().getCRSFactory();
        GeocentricCRS stepCRS = DefaultCoordinateOperationFactory.getGreenwichLongitude(targetPM) == 0.0 ? crsFactory.createGeocentricCRS(DefaultCoordinateOperationFactory.getTemporaryName(targetCRS), targetDatum, STANDARD) : crsFactory.createGeocentricCRS(DefaultCoordinateOperationFactory.getTemporaryName(sourceCRS), sourceDatum, STANDARD);
        CoordinateOperation step1 = this.createOperationStep(sourceCRS, stepCRS);
        CoordinateOperation step2 = this.createOperationStep(stepCRS, targetCRS);
        return this.concatenate(step1, step2);
    }

    protected CoordinateOperation createOperationStep(ProjectedCRS sourceCRS, ProjectedCRS targetCRS) throws FactoryException {
        CoordinateOperation step3;
        CoordinateOperation step2;
        Matrix linear = DefaultCoordinateOperationFactory.createLinearConversion(sourceCRS, targetCRS);
        if (linear != null) {
            return this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, linear);
        }
        GeographicCRS sourceGeo = (GeographicCRS)sourceCRS.getBaseCRS();
        GeographicCRS targetGeo = (GeographicCRS)targetCRS.getBaseCRS();
        CoordinateOperation step1 = this.tryDB(sourceCRS, sourceGeo);
        if (step1 == null) {
            step1 = this.createOperationStep(sourceCRS, sourceGeo);
        }
        if ((step2 = this.tryDB(sourceGeo, targetGeo)) == null) {
            step2 = this.createOperationStep(sourceGeo, targetGeo);
        }
        if ((step3 = this.tryDB(targetGeo, targetCRS)) == null) {
            step3 = this.createOperationStep(targetGeo, targetCRS);
        }
        return this.concatenate(step1, step2, step3);
    }

    protected CoordinateOperation createOperationStep(GeographicCRS sourceCRS, ProjectedCRS targetCRS) throws FactoryException {
        GeographicCRS base = (GeographicCRS)targetCRS.getBaseCRS();
        Conversion step2 = targetCRS.getConversionFromBase();
        CoordinateOperation step1 = this.tryDB(sourceCRS, base);
        if (step1 == null) {
            step1 = this.createOperationStep(sourceCRS, base);
        }
        return this.concatenate(step1, step2);
    }

    protected CoordinateOperation createOperationStep(ProjectedCRS sourceCRS, GeographicCRS targetCRS) throws FactoryException {
        GeographicCRS base = (GeographicCRS)sourceCRS.getBaseCRS();
        CoordinateOperation step1 = sourceCRS.getConversionFromBase();
        CoordinateOperation step2 = this.tryDB(base, targetCRS);
        if (step2 == null) {
            step2 = this.createOperationStep(base, targetCRS);
        }
        MathTransform transform = step1.getMathTransform();
        try {
            transform = transform.inverse();
        }
        catch (NoninvertibleTransformException exception) {
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceCRS, base), exception);
        }
        step1 = this.createFromMathTransform(INVERSE_OPERATION, sourceCRS, base, transform);
        return this.concatenate(step1, step2);
    }

    protected CoordinateOperation createOperationStep(GeocentricCRS sourceCRS, GeocentricCRS targetCRS) throws FactoryException {
        Matrix4 matrix;
        GeodeticDatum sourceDatum = (GeodeticDatum)sourceCRS.getDatum();
        GeodeticDatum targetDatum = (GeodeticDatum)targetCRS.getDatum();
        CoordinateSystem sourceCS = sourceCRS.getCoordinateSystem();
        CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
        double sourcePM = DefaultCoordinateOperationFactory.getGreenwichLongitude(sourceDatum.getPrimeMeridian());
        double targetPM = DefaultCoordinateOperationFactory.getGreenwichLongitude(targetDatum.getPrimeMeridian());
        if (DefaultCoordinateOperationFactory.equalsIgnorePrimeMeridian(sourceDatum, targetDatum) && sourcePM == targetPM) {
            Matrix matrix2 = this.swapAndScaleAxis(sourceCS, targetCS);
            return this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, matrix2);
        }
        if (sourcePM != targetPM) {
            throw new OperationNotFoundException("Rotation of prime meridian not yet implemented");
        }
        DefaultCartesianCS STANDARD = DefaultCartesianCS.GEOCENTRIC;
        Identifier identifier = DATUM_SHIFT;
        try {
            Matrix datumShift = DefaultGeodeticDatum.getAffineTransform(TemporaryDatum.unwrap(sourceDatum), TemporaryDatum.unwrap(targetDatum));
            if (datumShift == null) {
                if (this.lenientDatumShift) {
                    datumShift = new Matrix4();
                    identifier = ELLIPSOID_SHIFT;
                } else {
                    throw new OperationNotFoundException(Errors.format(18));
                }
            }
            Matrix normalizeSource = this.swapAndScaleAxis(sourceCS, STANDARD);
            Matrix normalizeTarget = this.swapAndScaleAxis(STANDARD, targetCS);
            matrix = new Matrix4(normalizeTarget);
            matrix.multiply(datumShift);
            matrix.multiply(normalizeSource);
        }
        catch (SingularMatrixException cause) {
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceDatum, targetDatum), cause);
        }
        return this.createFromAffineTransform(identifier, sourceCRS, targetCRS, matrix);
    }

    protected CoordinateOperation createOperationStep(GeographicCRS sourceCRS, GeocentricCRS targetCRS) throws FactoryException {
        GeographicCRS normSourceCRS = this.normalize(sourceCRS, true);
        GeodeticDatum datum = (GeodeticDatum)normSourceCRS.getDatum();
        GeocentricCRS normTargetCRS = this.normalize(targetCRS, datum);
        Ellipsoid ellipsoid = datum.getEllipsoid();
        Unit unit = ellipsoid.getAxisUnit();
        ParameterValueGroup param = this.getMathTransformFactory().getDefaultParameters("Ellipsoid_To_Geocentric");
        param.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis(), unit);
        param.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis(), unit);
        param.parameter("dim").setValue(DefaultCoordinateOperationFactory.getDimension(normSourceCRS));
        CoordinateOperation step1 = this.createOperationStep(sourceCRS, normSourceCRS);
        CoordinateOperation step2 = this.createFromParameters(GEOCENTRIC_CONVERSION, normSourceCRS, normTargetCRS, param);
        CoordinateOperation step3 = this.createOperationStep(normTargetCRS, targetCRS);
        return this.concatenate(step1, step2, step3);
    }

    protected CoordinateOperation createOperationStep(GeocentricCRS sourceCRS, GeographicCRS targetCRS) throws FactoryException {
        GeographicCRS normTargetCRS = this.normalize(targetCRS, true);
        GeodeticDatum datum = (GeodeticDatum)normTargetCRS.getDatum();
        GeocentricCRS normSourceCRS = this.normalize(sourceCRS, datum);
        Ellipsoid ellipsoid = datum.getEllipsoid();
        Unit unit = ellipsoid.getAxisUnit();
        ParameterValueGroup param = this.getMathTransformFactory().getDefaultParameters("Geocentric_To_Ellipsoid");
        param.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis(), unit);
        param.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis(), unit);
        param.parameter("dim").setValue(DefaultCoordinateOperationFactory.getDimension(normTargetCRS));
        CoordinateOperation step1 = this.createOperationStep(sourceCRS, normSourceCRS);
        CoordinateOperation step2 = this.createFromParameters(GEOCENTRIC_CONVERSION, normSourceCRS, normTargetCRS, param);
        CoordinateOperation step3 = this.createOperationStep(normTargetCRS, targetCRS);
        return this.concatenate(step1, step2, step3);
    }

    protected CoordinateOperation createOperationStep(CompoundCRS sourceCRS, SingleCRS targetCRS) throws FactoryException {
        SingleCRS[] sources = DefaultCompoundCRS.getSingleCRS(sourceCRS);
        if (sources.length == 1) {
            return this.createOperation(sources[0], targetCRS);
        }
        if (!DefaultCoordinateOperationFactory.needsGeodetic3D(sources, targetCRS)) {
            SingleCRS[] targets = new SingleCRS[]{targetCRS};
            return this.createOperationStep(sourceCRS, sources, targetCRS, targets);
        }
        CoordinateReferenceSystem source3D = this.getFactoryGroup().toGeodetic3D(sourceCRS);
        if (source3D != sourceCRS) {
            return this.createOperation(source3D, targetCRS);
        }
        throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceCRS, targetCRS));
    }

    protected CoordinateOperation createOperationStep(SingleCRS sourceCRS, CompoundCRS targetCRS) throws FactoryException {
        SingleCRS[] targets = DefaultCompoundCRS.getSingleCRS(targetCRS);
        if (targets.length == 1) {
            return this.createOperation(sourceCRS, targets[0]);
        }
        CoordinateReferenceSystem target3D = this.getFactoryGroup().toGeodetic3D(targetCRS);
        if (target3D != targetCRS) {
            return this.createOperation(sourceCRS, target3D);
        }
        SingleCRS[] sources = new SingleCRS[]{sourceCRS};
        return this.createOperationStep(sourceCRS, sources, targetCRS, targets);
    }

    protected CoordinateOperation createOperationStep(CompoundCRS sourceCRS, CompoundCRS targetCRS) throws FactoryException {
        SingleCRS[] sources = DefaultCompoundCRS.getSingleCRS(sourceCRS);
        SingleCRS[] targets = DefaultCompoundCRS.getSingleCRS(targetCRS);
        if (targets.length == 1) {
            return this.createOperation(sourceCRS, targets[0]);
        }
        if (sources.length == 1) {
            return this.createOperation(sources[0], targetCRS);
        }
        for (int i = 0; i < targets.length; ++i) {
            if (!DefaultCoordinateOperationFactory.needsGeodetic3D(sources, targets[i])) continue;
            FactoryGroup factories = this.getFactoryGroup();
            CoordinateReferenceSystem source3D = factories.toGeodetic3D(sourceCRS);
            CoordinateReferenceSystem target3D = factories.toGeodetic3D(targetCRS);
            if (source3D != sourceCRS || target3D != targetCRS) {
                return this.createOperation(source3D, target3D);
            }
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceCRS, targetCRS));
        }
        return this.createOperationStep(sourceCRS, sources, targetCRS, targets);
    }

    private CoordinateOperation createOperationStep(CoordinateReferenceSystem sourceCRS, SingleCRS[] sources, CoordinateReferenceSystem targetCRS, SingleCRS[] targets) throws FactoryException {
        CoordinateReferenceSystem[] ordered = new CoordinateReferenceSystem[targets.length];
        CoordinateOperation[] steps = new CoordinateOperation[targets.length];
        boolean[] done = new boolean[sources.length];
        int[] indices = new int[DefaultCoordinateOperationFactory.getDimension(sourceCRS)];
        int count = 0;
        int dimensions = 0;
        for (int j = 0; j < targets.length; ++j) {
            block13: {
                int upper = 0;
                SingleCRS target = targets[j];
                OperationNotFoundException cause = null;
                for (int i = 0; i < sources.length; ++i) {
                    SingleCRS source = sources[i];
                    int lower = upper;
                    upper += DefaultCoordinateOperationFactory.getDimension(source);
                    if (done[i]) continue;
                    try {
                        steps[count] = this.createOperation(source, target);
                    }
                    catch (OperationNotFoundException exception) {
                        if (cause != null && i != j) continue;
                        cause = exception;
                        continue;
                    }
                    ordered[count++] = source;
                    while (lower < upper) {
                        indices[dimensions++] = lower++;
                    }
                    break block13;
                }
                throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceCRS, targetCRS), cause);
            }
            done[i] = true;
        }
        if (!$assertionsDisabled && count != targets.length) {
            throw new AssertionError(count);
        }
        while (count != 0 && steps[--count].getMathTransform().isIdentity()) {
        }
        FactoryGroup factories = this.getFactoryGroup();
        CoordinateOperation operation = null;
        CoordinateReferenceSystem sourceStepCRS = sourceCRS;
        XMatrix select = MatrixFactory.create(dimensions + 1, indices.length + 1);
        select.setZero();
        select.setElement(dimensions, indices.length, 1.0);
        for (int j = 0; j < dimensions; ++j) {
            select.setElement(j, indices[j], 1.0);
        }
        if (!select.isIdentity()) {
            sourceStepCRS = ordered.length == 1 ? ordered[0] : factories.getCRSFactory().createCompoundCRS(DefaultCoordinateOperationFactory.getTemporaryName(sourceCRS), ordered);
            operation = this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, sourceStepCRS, select);
        }
        int upper = 0;
        for (int i = 0; i < targets.length; ++i) {
            CoordinateOperation step = steps[i];
            Map properties = AbstractIdentifiedObject.getProperties(step);
            CoordinateReferenceSystem source = ordered[i];
            SingleCRS target = targets[i];
            ordered[i] = target;
            MathTransform mt = step.getMathTransform();
            CoordinateReferenceSystem targetStepCRS = i >= count ? targetCRS : (mt.isIdentity() ? sourceStepCRS : (ordered.length == 1 ? ordered[0] : factories.getCRSFactory().createCompoundCRS(DefaultCoordinateOperationFactory.getTemporaryName(target), ordered)));
            int lower = upper;
            if (lower != 0 || (upper += DefaultCoordinateOperationFactory.getDimension(source)) != dimensions) {
                if (!(step instanceof Operation)) {
                    throw new OperationNotFoundException("Concatenated operation not supported.");
                }
                mt = this.getMathTransformFactory().createPassThroughTransform(lower, mt, dimensions - upper);
                step = new DefaultPassThroughOperation(properties, sourceStepCRS, targetStepCRS, (Operation)step, mt);
            }
            operation = operation == null ? step : this.concatenate(operation, step);
            sourceStepCRS = targetStepCRS;
        }
        if (!$assertionsDisabled && upper != dimensions) {
            throw new AssertionError(upper);
        }
        return operation;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean needsGeodetic3D(SingleCRS[] sourceCRS, SingleCRS targetCRS) {
        boolean targetGeodetic;
        Datum targetDatum = targetCRS.getDatum();
        if (targetDatum instanceof GeodeticDatum) {
            targetGeodetic = true;
        } else if (targetDatum instanceof VerticalDatum) {
            targetGeodetic = false;
        } else {
            return false;
        }
        boolean horizontal = false;
        boolean vertical = false;
        boolean shift = false;
        for (int i = 0; i < sourceCRS.length; ++i) {
            void var2_3;
            boolean sourceGeodetic;
            Datum sourceDatum = sourceCRS[i].getDatum();
            if (sourceDatum instanceof GeodeticDatum) {
                horizontal = true;
                sourceGeodetic = true;
            } else {
                if (!(sourceDatum instanceof VerticalDatum)) continue;
                vertical = true;
                sourceGeodetic = false;
            }
            if (shift || sourceGeodetic != var2_3) continue;
            boolean bl = shift = !DefaultCoordinateOperationFactory.equalsIgnoreMetadata(sourceDatum, targetDatum);
            if (!$assertionsDisabled && !Utilities.sameInterfaces(sourceDatum.getClass(), targetDatum.getClass(), class$org$opengis$referencing$datum$Datum == null ? DefaultCoordinateOperationFactory.class$("org.opengis.referencing.datum.Datum") : class$org$opengis$referencing$datum$Datum)) {
                throw new AssertionError();
            }
        }
        return horizontal && vertical && (shift || targetCRS.getCoordinateSystem().getDimension() >= 3);
    }

    private static boolean equalsIgnorePrimeMeridian(GeodeticDatum object1, GeodeticDatum object2) {
        object1 = TemporaryDatum.unwrap(object1);
        object2 = TemporaryDatum.unwrap(object2);
        if (DefaultCoordinateOperationFactory.equalsIgnoreMetadata(object1.getEllipsoid(), object2.getEllipsoid())) {
            return DefaultCoordinateOperationFactory.nameMatches(object1, object2.getName().getCode()) || DefaultCoordinateOperationFactory.nameMatches(object2, object1.getName().getCode());
        }
        return false;
    }

    private static boolean nameMatches(IdentifiedObject object, String name) {
        return AbstractIdentifiedObject.nameMatches(object, name);
    }

    private final CoordinateOperation tryDB(SingleCRS sourceCRS, SingleCRS targetCRS) {
        return sourceCRS == targetCRS ? null : this.createFromDatabase(sourceCRS, targetCRS);
    }

    protected CoordinateOperation createFromDatabase(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        return null;
    }

    static {
        $assertionsDisabled = !DefaultCoordinateOperationFactory.class.desiredAssertionStatus();
        MILLISECOND = SI.MILLI(SI.SECOND);
    }

    private static final class TemporaryDatum
    extends DefaultGeodeticDatum {
        private final GeodeticDatum datum;

        public TemporaryDatum(GeodeticDatum datum) {
            super(AbstractCoordinateOperationFactory.getTemporaryName(datum), datum.getEllipsoid(), (PrimeMeridian)DefaultPrimeMeridian.GREENWICH);
            this.datum = datum;
        }

        public static GeodeticDatum unwrap(GeodeticDatum datum) {
            while (datum instanceof TemporaryDatum) {
                datum = ((TemporaryDatum)datum).datum;
            }
            return datum;
        }

        public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
            if (super.equals(object, compareMetadata)) {
                GeodeticDatum other = ((TemporaryDatum)object).datum;
                return compareMetadata ? this.datum.equals(other) : AbstractCoordinateOperationFactory.equalsIgnoreMetadata(this.datum, other);
            }
            return false;
        }
    }
}

