/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.Parameters;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.PassThroughTransform;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;
import org.opengis.util.InternationalString;

public class DefaultOperationMethod
extends AbstractIdentifiedObject
implements OperationMethod {
    private static final long serialVersionUID = -98032729598205972L;
    private static final String[] LOCALIZABLES = new String[]{"formula"};
    private final InternationalString formula;
    protected final int sourceDimensions;
    protected final int targetDimensions;
    private final ParameterDescriptorGroup parameters;

    public DefaultOperationMethod(MathTransform transform) {
        this(DefaultOperationMethod.getProperties(transform), transform.getSourceDimensions(), transform.getTargetDimensions(), DefaultOperationMethod.getDescriptor(transform));
    }

    private static Map getProperties(MathTransform transform) {
        Map properties;
        DefaultOperationMethod.ensureNonNull("transform", transform);
        if (transform instanceof AbstractMathTransform) {
            AbstractMathTransform mt = (AbstractMathTransform)transform;
            properties = DefaultOperationMethod.getProperties(mt.getParameterDescriptors(), null);
        } else {
            properties = Collections.singletonMap("name", Vocabulary.format(176));
        }
        return properties;
    }

    private static ParameterDescriptorGroup getDescriptor(MathTransform transform) {
        ParameterDescriptorGroup descriptor = null;
        if (transform instanceof AbstractMathTransform) {
            descriptor = ((AbstractMathTransform)transform).getParameterDescriptors();
        }
        return descriptor;
    }

    public DefaultOperationMethod(OperationMethod method) {
        super(method);
        this.formula = method.getFormula();
        this.parameters = method.getParameters();
        this.sourceDimensions = method.getSourceDimensions();
        this.targetDimensions = method.getTargetDimensions();
    }

    public DefaultOperationMethod(OperationMethod method, int sourceDimensions, int targetDimensions) {
        super(method);
        this.formula = method.getFormula();
        this.parameters = method.getParameters();
        this.sourceDimensions = sourceDimensions;
        this.targetDimensions = targetDimensions;
        DefaultOperationMethod.ensurePositive("sourceDimensions", sourceDimensions);
        DefaultOperationMethod.ensurePositive("targetDimensions", targetDimensions);
    }

    private static ParameterDescriptorGroup toGroup(Map properties, GeneralParameterDescriptor[] parameters) {
        return parameters == null || parameters.length == 0 ? null : new DefaultParameterDescriptorGroup(properties, parameters);
    }

    public DefaultOperationMethod(Map properties, int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters) {
        this(properties, new HashMap(), sourceDimensions, targetDimensions, parameters);
    }

    private DefaultOperationMethod(Map properties, Map subProperties, int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters) {
        super(properties, subProperties, LOCALIZABLES);
        this.formula = (InternationalString)subProperties.get("formula");
        this.parameters = parameters;
        this.sourceDimensions = sourceDimensions;
        this.targetDimensions = targetDimensions;
        DefaultOperationMethod.ensurePositive("sourceDimensions", sourceDimensions);
        DefaultOperationMethod.ensurePositive("targetDimensions", targetDimensions);
    }

    private static void ensurePositive(String name, int value) throws IllegalArgumentException {
        if (value < 0) {
            throw new IllegalArgumentException(Errors.format(42, name, new Integer(value)));
        }
    }

    public InternationalString getFormula() {
        return this.formula;
    }

    public int getSourceDimensions() {
        return this.sourceDimensions;
    }

    public int getTargetDimensions() {
        return this.targetDimensions;
    }

    public ParameterDescriptorGroup getParameters() {
        return this.parameters != null ? this.parameters : Parameters.EMPTY_GROUP;
    }

    Class getOperationType() {
        return Projection.class;
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultOperationMethod that = (DefaultOperationMethod)object;
            if (this.sourceDimensions == that.sourceDimensions && this.targetDimensions == that.targetDimensions && DefaultOperationMethod.equals(this.parameters, that.parameters, compareMetadata)) {
                return !compareMetadata || Utilities.equals(this.formula, that.formula);
            }
        }
        return false;
    }

    public int hashCode() {
        int code = 2012209132 + this.sourceDimensions + 37 * this.targetDimensions;
        if (this.parameters != null) {
            code = code * 37 + this.parameters.hashCode();
        }
        return code;
    }

    protected String formatWKT(Formatter formatter) {
        if (Projection.class.isAssignableFrom(this.getOperationType())) {
            return "PROJECTION";
        }
        return super.formatWKT(formatter);
    }

    private static boolean isTrivial(MathTransform transform) {
        if (transform instanceof LinearTransform) {
            Matrix matrix = ((LinearTransform)transform).getMatrix();
            int size = matrix.getNumRow();
            if (matrix.getNumCol() == size) {
                for (int j = 0; j < size; ++j) {
                    int n1 = 0;
                    int n2 = 0;
                    for (int i = 0; i < size; ++i) {
                        if (matrix.getElement(j, i) != 0.0) {
                            ++n1;
                        }
                        if (matrix.getElement(i, j) == 0.0) continue;
                        ++n2;
                    }
                    if (n1 == 1 && n2 == true) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static void checkDimensions(OperationMethod method, MathTransform transform) throws MismatchedDimensionException {
        if (method != null && transform != null) {
            void var4_4;
            String name;
            int actual;
            int expected = method.getSourceDimensions();
            while ((actual = transform.getSourceDimensions()) > expected) {
                if (transform instanceof ConcatenatedTransform) {
                    ConcatenatedTransform c = (ConcatenatedTransform)transform;
                    if (DefaultOperationMethod.isTrivial(c.transform1)) {
                        transform = c.transform2;
                        continue;
                    }
                    if (!DefaultOperationMethod.isTrivial(c.transform2)) break;
                    transform = c.transform1;
                    continue;
                }
                if (!(transform instanceof PassThroughTransform)) break;
                transform = ((PassThroughTransform)transform).getSubTransform();
            }
            if (actual != expected) {
                name = "sourceDimensions";
            } else {
                actual = transform.getTargetDimensions();
                if (actual != (expected = method.getTargetDimensions())) {
                    name = "targetDimensions";
                } else {
                    return;
                }
            }
            throw new IllegalArgumentException(Errors.format(69, var4_4, new Integer(actual), new Integer(expected)));
        }
    }
}

