/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.measure.Latitude;
import org.geotools.measure.Longitude;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.projection.PointOutsideEnvelopeException;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.resources.XMath;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public abstract class MapProjection
extends AbstractMathTransform
implements MathTransform2D,
Serializable {
    static final double EPS = 1.0E-6;
    static final double TOL = 1.0E-10;
    static final int MAX_ITER = 15;
    protected final double excentricity;
    protected final double excentricitySquared;
    protected final boolean isSpherical;
    protected final double semiMajor;
    protected final double semiMinor;
    protected double centralMeridian;
    protected double latitudeOfOrigin;
    protected double scaleFactor;
    protected final double falseEasting;
    protected final double falseNorthing;
    protected double globalScale;
    private transient MathTransform inverse;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$opengis$referencing$operation$Projection;

    protected MapProjection(ParameterValueGroup values) throws ParameterNotFoundException {
        this(values, null);
    }

    MapProjection(ParameterValueGroup values, Collection expected) throws ParameterNotFoundException {
        if (expected == null) {
            expected = this.getParameterDescriptors().descriptors();
        }
        this.semiMajor = this.doubleValue(expected, AbstractProvider.SEMI_MAJOR, values);
        this.semiMinor = this.doubleValue(expected, AbstractProvider.SEMI_MINOR, values);
        this.centralMeridian = this.doubleValue(expected, AbstractProvider.CENTRAL_MERIDIAN, values);
        this.latitudeOfOrigin = this.doubleValue(expected, AbstractProvider.LATITUDE_OF_ORIGIN, values);
        this.scaleFactor = this.doubleValue(expected, AbstractProvider.SCALE_FACTOR, values);
        this.falseEasting = this.doubleValue(expected, AbstractProvider.FALSE_EASTING, values);
        this.falseNorthing = this.doubleValue(expected, AbstractProvider.FALSE_NORTHING, values);
        this.isSpherical = this.semiMajor == this.semiMinor;
        this.excentricitySquared = 1.0 - this.semiMinor * this.semiMinor / (this.semiMajor * this.semiMajor);
        this.excentricity = Math.sqrt(this.excentricitySquared);
        this.globalScale = this.scaleFactor * this.semiMajor;
        MapProjection.ensureLongitudeInRange(AbstractProvider.CENTRAL_MERIDIAN, this.centralMeridian, true);
        MapProjection.ensureLatitudeInRange(AbstractProvider.LATITUDE_OF_ORIGIN, this.latitudeOfOrigin, true);
    }

    boolean isExpectedParameter(Collection expected, ParameterDescriptor param) {
        return expected.contains(param);
    }

    final double doubleValue(Collection expected, ParameterDescriptor param, ParameterValueGroup group) throws ParameterNotFoundException {
        double v;
        if (this.isExpectedParameter(expected, param)) {
            return AbstractProvider.doubleValue(param, group);
        }
        Object value = param.getDefaultValue();
        if (value instanceof Number) {
            v = ((Number)value).doubleValue();
            if (NonSI.DEGREE_ANGLE.equals(param.getUnit())) {
                v = Math.toRadians(v);
            }
        } else {
            v = Double.NaN;
        }
        return v;
    }

    static void ensureLatitudeInRange(ParameterDescriptor name, double y, boolean edge) throws IllegalArgumentException {
        if (edge ? y >= -1.5707963267948966 && y <= 1.5707963267948966 : y > -1.5707963267948966 && y < 1.5707963267948966) {
            return;
        }
        y = Math.toDegrees(y);
        throw new InvalidParameterValueException(Errors.format(62, new Latitude(y)), name.getName().getCode(), y);
    }

    static void ensureLongitudeInRange(ParameterDescriptor name, double x, boolean edge) throws IllegalArgumentException {
        if (edge ? x >= -Math.PI && x <= Math.PI : x > -Math.PI && x < Math.PI) {
            return;
        }
        x = Math.toDegrees(x);
        throw new InvalidParameterValueException(Errors.format(65, new Longitude(x)), name.getName().getCode(), x);
    }

    final void set(Collection expected, ParameterDescriptor param, ParameterValueGroup group, double value) {
        if (this.isExpectedParameter(expected, param)) {
            if (NonSI.DEGREE_ANGLE.equals(param.getUnit())) {
                double test;
                double old = value = Math.toDegrees(value);
                if ((value = XMath.fixRoundingError(value, 12)) == old && (test = XMath.fixRoundingError(old *= 3.0, 12)) != old) {
                    value = test / 3.0;
                }
            }
            group.parameter(param.getName().getCode()).setValue(value);
        }
    }

    public abstract ParameterDescriptorGroup getParameterDescriptors();

    public ParameterValueGroup getParameterValues() {
        ParameterDescriptorGroup descriptor = this.getParameterDescriptors();
        List expected = descriptor.descriptors();
        ParameterValueGroup values = (ParameterValueGroup)descriptor.createValue();
        this.set(expected, AbstractProvider.SEMI_MAJOR, values, this.semiMajor);
        this.set(expected, AbstractProvider.SEMI_MINOR, values, this.semiMinor);
        this.set(expected, AbstractProvider.CENTRAL_MERIDIAN, values, this.centralMeridian);
        this.set(expected, AbstractProvider.LATITUDE_OF_ORIGIN, values, this.latitudeOfOrigin);
        this.set(expected, AbstractProvider.SCALE_FACTOR, values, this.scaleFactor);
        this.set(expected, AbstractProvider.FALSE_EASTING, values, this.falseEasting);
        this.set(expected, AbstractProvider.FALSE_NORTHING, values, this.falseNorthing);
        return values;
    }

    public final int getSourceDimensions() {
        return 2;
    }

    public final int getTargetDimensions() {
        return 2;
    }

    private boolean checkTransform(Point2D point, Point2D target, boolean inverse) {
        if (!(point instanceof CheckPoint)) {
            try {
                double latitude;
                double longitude;
                double distance;
                point = new CheckPoint(point);
                if (inverse) {
                    point = ((MathTransform2D)this.inverse()).transform(point, point);
                    double y1 = Math.toRadians(point.getY());
                    double y2 = Math.toRadians(target.getY());
                    double dx = Math.toRadians(Math.abs(target.getX() - point.getX()) % 360.0);
                    double rho = Math.sin(y1) * Math.sin(y2) + Math.cos(y1) * Math.cos(y2) * Math.cos(dx);
                    if (rho > 1.0) {
                        if (!$assertionsDisabled && !(rho <= 1.000001)) {
                            throw new AssertionError(rho);
                        }
                        rho = 1.0;
                    }
                    if (rho < -1.0) {
                        if (!$assertionsDisabled && !(rho >= -1.000001)) {
                            throw new AssertionError(rho);
                        }
                        rho = -1.0;
                    }
                    distance = Math.acos(rho) * this.semiMajor;
                    longitude = point.getX();
                    latitude = point.getY();
                } else {
                    longitude = point.getX();
                    latitude = point.getY();
                    point = this.transform(point, point);
                    distance = point.distance(target);
                }
                if (distance > this.getToleranceForAssertions(longitude, latitude)) {
                    throw new AssertionError((Object)Errors.format(181, new Double(distance), new Longitude(longitude - Math.toDegrees(this.centralMeridian)), new Latitude(latitude - Math.toDegrees(this.latitudeOfOrigin))));
                }
            }
            catch (TransformException exception) {
                AssertionError error = new AssertionError((Object)exception.getLocalizedMessage());
                ((Throwable)((Object)error)).initCause(exception);
                throw error;
            }
        }
        return true;
    }

    protected abstract Point2D inverseTransformNormalized(double var1, double var3, Point2D var5) throws ProjectionException;

    protected abstract Point2D transformNormalized(double var1, double var3, Point2D var5) throws ProjectionException;

    public final Point2D transform(Point2D ptSrc, Point2D ptDst) throws ProjectionException {
        double x = ptSrc.getX();
        double y = ptSrc.getY();
        if (x < -180.000001 || x > 180.000001) {
            throw new PointOutsideEnvelopeException(Errors.format(65, new Longitude(x)));
        }
        if (y < -90.000001 || y > 90.000001) {
            throw new PointOutsideEnvelopeException(Errors.format(62, new Latitude(y)));
        }
        ptDst = this.transformNormalized(this.centralMeridian != 0.0 ? MapProjection.rollLongitude(Math.toRadians(x) - this.centralMeridian) : Math.toRadians(x), Math.toRadians(y), ptDst);
        ptDst.setLocation(this.globalScale * ptDst.getX() + this.falseEasting, this.globalScale * ptDst.getY() + this.falseNorthing);
        if (!$assertionsDisabled && !this.checkTransform(ptDst, ptSrc != ptDst ? ptSrc : new Point2D.Double(x, y), true)) {
            throw new AssertionError();
        }
        return ptDst;
    }

    public final void transform(double[] src, int srcOffset, double[] dest, int dstOffset, int numPts) throws ProjectionException {
        boolean reverse;
        boolean bl = reverse = src == dest && srcOffset < dstOffset && srcOffset + 2 * numPts > dstOffset;
        if (reverse) {
            srcOffset += 2 * numPts;
            dstOffset += 2 * numPts;
        }
        Point2D.Double point = new Point2D.Double();
        ProjectionException firstException = null;
        while (--numPts >= 0) {
            block5: {
                try {
                    point.x = src[srcOffset++];
                    point.y = src[srcOffset++];
                    this.transform(point, point);
                    dest[dstOffset++] = point.x;
                    dest[dstOffset++] = point.y;
                }
                catch (ProjectionException exception) {
                    dest[dstOffset++] = Double.NaN;
                    dest[dstOffset++] = Double.NaN;
                    if (firstException != null) break block5;
                    firstException = exception;
                }
            }
            if (!reverse) continue;
            srcOffset -= 4;
            dstOffset -= 4;
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public final void transform(float[] src, int srcOffset, float[] dest, int dstOffset, int numPts) throws ProjectionException {
        boolean reverse;
        boolean bl = reverse = src == dest && srcOffset < dstOffset && srcOffset + 2 * numPts > dstOffset;
        if (reverse) {
            srcOffset += 2 * numPts;
            dstOffset += 2 * numPts;
        }
        Point2D.Double point = new Point2D.Double();
        ProjectionException firstException = null;
        while (--numPts >= 0) {
            block5: {
                try {
                    point.x = src[srcOffset++];
                    point.y = src[srcOffset++];
                    this.transform(point, point);
                    dest[dstOffset++] = (float)point.x;
                    dest[dstOffset++] = (float)point.y;
                }
                catch (ProjectionException exception) {
                    dest[dstOffset++] = Float.NaN;
                    dest[dstOffset++] = Float.NaN;
                    if (firstException != null) break block5;
                    firstException = exception;
                }
            }
            if (!reverse) continue;
            srcOffset -= 4;
            dstOffset -= 4;
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public final MathTransform inverse() {
        if (this.inverse == null) {
            this.inverse = new Inverse();
        }
        return this.inverse;
    }

    protected double getToleranceForAssertions(double longitude, double latitude) {
        if (Math.abs(longitude - this.centralMeridian) / 2.0 + Math.abs(latitude - this.latitudeOfOrigin) > 40.0) {
            return 1.0;
        }
        return Math.abs(longitude) > 179.0 || Math.abs(latitude) > 89.0 ? 0.1 : 1.0E-6;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.semiMajor);
        code = code * 37L + Double.doubleToLongBits(this.semiMinor);
        code = code * 37L + Double.doubleToLongBits(this.centralMeridian);
        code = code * 37L + Double.doubleToLongBits(this.latitudeOfOrigin);
        return (int)code ^ (int)(code >>> 32);
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            MapProjection that = (MapProjection)object;
            return MapProjection.equals(this.semiMajor, that.semiMajor) && MapProjection.equals(this.semiMinor, that.semiMinor) && MapProjection.equals(this.centralMeridian, that.centralMeridian) && MapProjection.equals(this.latitudeOfOrigin, that.latitudeOfOrigin) && MapProjection.equals(this.scaleFactor, that.scaleFactor) && MapProjection.equals(this.falseEasting, that.falseEasting) && MapProjection.equals(this.falseNorthing, that.falseNorthing);
        }
        return false;
    }

    static boolean equals(double value1, double value2) {
        return Double.doubleToLongBits(value1) == Double.doubleToLongBits(value2);
    }

    final double cphi2(double ts) throws ProjectionException {
        double eccnth = 0.5 * this.excentricity;
        double phi = 1.5707963267948966 - 2.0 * Math.atan(ts);
        for (int i = 0; i < 15; ++i) {
            double con = this.excentricity * Math.sin(phi);
            double dphi = 1.5707963267948966 - 2.0 * Math.atan(ts * Math.pow((1.0 - con) / (1.0 + con), eccnth)) - phi;
            phi += dphi;
            if (!(Math.abs(dphi) <= 1.0E-10)) continue;
            return phi;
        }
        throw new ProjectionException(Errors.format(95));
    }

    final double msfn(double s, double c) {
        return c / Math.sqrt(1.0 - s * s * this.excentricitySquared);
    }

    final double tsfn(double phi, double sinphi) {
        return Math.tan(0.5 * (1.5707963267948966 - phi)) / Math.pow((1.0 - (sinphi *= this.excentricity)) / (1.0 + sinphi), 0.5 * this.excentricity);
    }

    static {
        $assertionsDisabled = !MapProjection.class.desiredAssertionStatus();
    }

    public static abstract class AbstractProvider
    extends MathTransformProvider {
        private static final long serialVersionUID = 6280666068007678702L;
        public static final ParameterDescriptor SEMI_MAJOR = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "semi_major"), new NamedIdentifier(Citations.EPSG, "semi-major axis")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor SEMI_MINOR = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "semi_minor"), new NamedIdentifier(Citations.EPSG, "semi-minor axis")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor CENTRAL_MERIDIAN = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "central_meridian"), new NamedIdentifier(Citations.EPSG, "Longitude of natural origin"), new NamedIdentifier(Citations.EPSG, "Longitude of false origin"), new NamedIdentifier(Citations.ESRI, "Longitude_Of_Origin"), new NamedIdentifier(Citations.ESRI, "Longitude_Of_Center"), new NamedIdentifier(Citations.GEOTIFF, "NatOriginLong")}, 0.0, -180.0, 180.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LATITUDE_OF_ORIGIN = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "latitude_of_origin"), new NamedIdentifier(Citations.EPSG, "Latitude of false origin"), new NamedIdentifier(Citations.EPSG, "Latitude of natural origin"), new NamedIdentifier(Citations.ESRI, "Latitude_Of_Center"), new NamedIdentifier(Citations.GEOTIFF, "NatOriginLat")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor STANDARD_PARALLEL = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "standard_parallel_1"), new NamedIdentifier(Citations.EPSG, "Latitude of 1st standard parallel"), new NamedIdentifier(Citations.GEOTIFF, "StdParallel1")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor STANDARD_PARALLEL_1 = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "standard_parallel_1"), new NamedIdentifier(Citations.EPSG, "Latitude of 1st standard parallel"), new NamedIdentifier(Citations.GEOTIFF, "StdParallel1")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor STANDARD_PARALLEL_2 = AbstractProvider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "standard_parallel_2"), new NamedIdentifier(Citations.EPSG, "Latitude of 2nd standard parallel"), new NamedIdentifier(Citations.GEOTIFF, "StdParallel2")}, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor SCALE_FACTOR = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "scale_factor"), new NamedIdentifier(Citations.EPSG, "Scale factor at natural origin"), new NamedIdentifier(Citations.EPSG, "Scale factor on initial line"), new NamedIdentifier(Citations.GEOTIFF, "ScaleAtNatOrigin"), new NamedIdentifier(Citations.GEOTIFF, "ScaleAtCenter")}, 1.0, 0.0, Double.POSITIVE_INFINITY, Unit.ONE);
        public static final ParameterDescriptor FALSE_EASTING = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "false_easting"), new NamedIdentifier(Citations.EPSG, "False easting"), new NamedIdentifier(Citations.EPSG, "Easting at false origin"), new NamedIdentifier(Citations.EPSG, "Easting at projection centre"), new NamedIdentifier(Citations.GEOTIFF, "FalseEasting")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor FALSE_NORTHING = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "false_northing"), new NamedIdentifier(Citations.EPSG, "False northing"), new NamedIdentifier(Citations.EPSG, "Northing at false origin"), new NamedIdentifier(Citations.EPSG, "Northing at projection centre"), new NamedIdentifier(Citations.GEOTIFF, "FalseNorthing")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METER);

        public AbstractProvider(ParameterDescriptorGroup parameters) {
            super(2, 2, parameters);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$Projection == null ? (class$org$opengis$referencing$operation$Projection = MapProjection.class$("org.opengis.referencing.operation.Projection")) : class$org$opengis$referencing$operation$Projection;
        }

        static boolean isSpherical(ParameterValueGroup values) {
            try {
                return AbstractProvider.doubleValue(SEMI_MAJOR, values) == AbstractProvider.doubleValue(SEMI_MINOR, values);
            }
            catch (IllegalStateException exception) {
                return false;
            }
        }

        protected static double doubleValue(ParameterDescriptor param, ParameterValueGroup group) throws ParameterNotFoundException {
            double v = MathTransformProvider.doubleValue(param, group);
            if (NonSI.DEGREE_ANGLE.equals(param.getUnit())) {
                v = Math.toRadians(v);
            }
            return v;
        }
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements MathTransform2D {
        static final /* synthetic */ boolean $assertionsDisabled;

        public final Point2D transform(Point2D ptSrc, Point2D ptDst) throws ProjectionException {
            double x0 = ptSrc.getX();
            double y0 = ptSrc.getY();
            ptDst = MapProjection.this.inverseTransformNormalized((x0 - MapProjection.this.falseEasting) / MapProjection.this.globalScale, (y0 - MapProjection.this.falseNorthing) / MapProjection.this.globalScale, ptDst);
            double x = Math.toDegrees(MapProjection.this.centralMeridian != 0.0 ? Inverse.rollLongitude(ptDst.getX() + MapProjection.this.centralMeridian) : ptDst.getX());
            double y = Math.toDegrees(ptDst.getY());
            ptDst.setLocation(x, y);
            if (x < -180.000001 || x > 180.000001) {
                throw new PointOutsideEnvelopeException(Errors.format(65, new Longitude(x)));
            }
            if (y < -90.000001 || y > 90.000001) {
                throw new PointOutsideEnvelopeException(Errors.format(62, new Latitude(y)));
            }
            if (!$assertionsDisabled && !MapProjection.this.checkTransform(ptDst, ptSrc != ptDst ? ptSrc : new Point2D.Double(x0, y0), false)) {
                throw new AssertionError();
            }
            return ptDst;
        }

        public final void transform(double[] src, int srcOffset, double[] dest, int dstOffset, int numPts) throws TransformException {
            boolean reverse;
            boolean bl = reverse = src == dest && srcOffset < dstOffset && srcOffset + 2 * numPts > dstOffset;
            if (reverse) {
                srcOffset += 2 * numPts;
                dstOffset += 2 * numPts;
            }
            Point2D.Double point = new Point2D.Double();
            ProjectionException firstException = null;
            while (--numPts >= 0) {
                block5: {
                    try {
                        point.x = src[srcOffset++];
                        point.y = src[srcOffset++];
                        this.transform(point, point);
                        dest[dstOffset++] = point.x;
                        dest[dstOffset++] = point.y;
                    }
                    catch (ProjectionException exception) {
                        dest[dstOffset++] = Double.NaN;
                        dest[dstOffset++] = Double.NaN;
                        if (firstException != null) break block5;
                        firstException = exception;
                    }
                }
                if (!reverse) continue;
                srcOffset -= 4;
                dstOffset -= 4;
            }
            if (firstException != null) {
                throw firstException;
            }
        }

        public final void transform(float[] src, int srcOffset, float[] dest, int dstOffset, int numPts) throws ProjectionException {
            boolean reverse;
            boolean bl = reverse = src == dest && srcOffset < dstOffset && srcOffset + 2 * numPts > dstOffset;
            if (reverse) {
                srcOffset += 2 * numPts;
                dstOffset += 2 * numPts;
            }
            Point2D.Double point = new Point2D.Double();
            ProjectionException firstException = null;
            while (--numPts >= 0) {
                block5: {
                    try {
                        point.x = src[srcOffset++];
                        point.y = src[srcOffset++];
                        this.transform(point, point);
                        dest[dstOffset++] = (float)point.x;
                        dest[dstOffset++] = (float)point.y;
                    }
                    catch (ProjectionException exception) {
                        dest[dstOffset++] = Float.NaN;
                        dest[dstOffset++] = Float.NaN;
                        if (firstException != null) break block5;
                        firstException = exception;
                    }
                }
                if (!reverse) continue;
                srcOffset -= 4;
                dstOffset -= 4;
            }
            if (firstException != null) {
                throw firstException;
            }
        }

        static {
            $assertionsDisabled = !(class$org$geotools$referencing$operation$projection$MapProjection == null ? (class$org$geotools$referencing$operation$projection$MapProjection = MapProjection.class$("org.geotools.referencing.operation.projection.MapProjection")) : class$org$geotools$referencing$operation$projection$MapProjection).desiredAssertionStatus();
        }
    }

    private static final class CheckPoint
    extends Point2D.Double {
        public CheckPoint(Point2D point) {
            super(point.getX(), point.getY());
        }
    }
}

