/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.List;
import org.geotools.measure.Latitude;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public abstract class Mercator
extends MapProjection {
    protected final double standardParallel;
    static /* synthetic */ Class class$org$geotools$referencing$operation$projection$Mercator;

    protected Mercator(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        List expected = this.getParameterDescriptors().descriptors();
        if (expected.contains(MapProjection.AbstractProvider.STANDARD_PARALLEL)) {
            this.standardParallel = Math.abs(this.doubleValue(expected, MapProjection.AbstractProvider.STANDARD_PARALLEL, parameters));
            Mercator.ensureLatitudeInRange(MapProjection.AbstractProvider.STANDARD_PARALLEL, this.standardParallel, false);
            this.scaleFactor = this.isSpherical ? (this.scaleFactor *= Math.cos(this.standardParallel)) : (this.scaleFactor *= this.msfn(Math.sin(this.standardParallel), Math.cos(this.standardParallel)));
            this.globalScale = this.scaleFactor * this.semiMajor;
        } else {
            this.standardParallel = Double.NaN;
        }
        double sinPhi = Math.sin(this.latitudeOfOrigin);
        this.globalScale *= Math.cos(this.latitudeOfOrigin) / Math.sqrt(1.0 - this.excentricitySquared * sinPhi * sinPhi);
    }

    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        if (!Double.isNaN(this.standardParallel)) {
            List expected = this.getParameterDescriptors().descriptors();
            this.set(expected, MapProjection.AbstractProvider.STANDARD_PARALLEL, values, this.standardParallel);
        }
        return values;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        if (Math.abs(y) > 1.5707953267948966) {
            throw new ProjectionException(Errors.format(118, new Latitude(Math.toDegrees(y))));
        }
        y = -Math.log(this.tsfn(y, Math.sin(y)));
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        y = Math.exp(-y);
        y = this.cphi2(y);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.standardParallel);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            Mercator that = (Mercator)object;
            return Mercator.equals(this.standardParallel, that.standardParallel);
        }
        return false;
    }

    static abstract class Spherical
    extends Mercator {
        static final /* synthetic */ boolean $assertionsDisabled;

        protected Spherical(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
            if (!$assertionsDisabled && !this.isSpherical) {
                throw new AssertionError();
            }
        }

        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (Math.abs(y) > 1.5707953267948966) {
                throw new ProjectionException(Errors.format(118, new Latitude(Math.toDegrees(y))));
            }
            if (!$assertionsDisabled && (ptDst = super.transformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            y = Math.log(Math.tan(0.7853981633974483 + 0.5 * y));
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.inverseTransformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            y = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-y));
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        static {
            $assertionsDisabled = !(class$org$geotools$referencing$operation$projection$Mercator == null ? (class$org$geotools$referencing$operation$projection$Mercator = Mercator.class$("org.geotools.referencing.operation.projection.Mercator")) : class$org$geotools$referencing$operation$projection$Mercator).desiredAssertionStatus();
        }
    }
}

