/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import javax.units.NonSI;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public class ObliqueMercator
extends MapProjection {
    private final double latitudeOfCentre;
    private final double longitudeOfCentre;
    private double alpha_c;
    private double rectGridAngle;
    private final double latitudeOf1stPoint;
    private final double longitudeOf1stPoint;
    private final double latitudeOf2ndPoint;
    private double longitudeOf2ndPoint;
    private double B;
    private double A;
    private double E;
    private final double ArB;
    private final double AB;
    private final double BrA;
    private final double v_pole_n;
    private final double v_pole_s;
    private final double singamma0;
    private final double cosgamma0;
    private final double sinrot;
    private final double cosrot;
    private double u_c;
    private final boolean twoPoint;
    private final boolean hotine;
    static /* synthetic */ Class class$org$opengis$referencing$operation$CylindricalProjection;

    ObliqueMercator(ParameterValueGroup parameters, Collection expected, boolean hotine, boolean twoPoint) throws ParameterNotFoundException {
        super(parameters, expected);
        double gamma0;
        this.hotine = hotine;
        this.twoPoint = twoPoint;
        this.latitudeOfOrigin = Double.NaN;
        this.centralMeridian = Double.NaN;
        this.latitudeOfCentre = this.doubleValue(expected, Provider.LAT_OF_CENTRE, parameters);
        ObliqueMercator.ensureLatitudeInRange(Provider.LAT_OF_CENTRE, this.latitudeOfCentre, false);
        if (twoPoint) {
            this.longitudeOfCentre = Double.NaN;
            this.latitudeOf1stPoint = this.doubleValue(expected, Provider_TwoPoint.LAT_OF_1ST_POINT, parameters);
            ObliqueMercator.ensureLatitudeInRange(Provider_TwoPoint.LAT_OF_1ST_POINT, this.latitudeOf1stPoint, false);
            this.longitudeOf1stPoint = this.doubleValue(expected, Provider_TwoPoint.LONG_OF_1ST_POINT, parameters);
            ObliqueMercator.ensureLongitudeInRange(Provider_TwoPoint.LONG_OF_1ST_POINT, this.longitudeOf1stPoint, true);
            this.latitudeOf2ndPoint = this.doubleValue(expected, Provider_TwoPoint.LAT_OF_2ND_POINT, parameters);
            ObliqueMercator.ensureLatitudeInRange(Provider_TwoPoint.LAT_OF_2ND_POINT, this.latitudeOf2ndPoint, true);
            this.longitudeOf2ndPoint = this.doubleValue(expected, Provider_TwoPoint.LONG_OF_2ND_POINT, parameters);
            ObliqueMercator.ensureLongitudeInRange(Provider_TwoPoint.LONG_OF_2ND_POINT, this.longitudeOf2ndPoint, true);
            double con = Math.abs(this.latitudeOf1stPoint);
            if (Math.abs(this.latitudeOf1stPoint - this.latitudeOf2ndPoint) < 1.0E-10) {
                throw new IllegalArgumentException(Errors.format(59));
            }
            if (Math.abs(this.latitudeOf1stPoint) < 1.0E-10) {
                throw new IllegalArgumentException(Errors.format(60));
            }
            if (Math.abs(this.latitudeOf2ndPoint + 1.5707963267948966) < 1.0E-10) {
                throw new IllegalArgumentException(Errors.format(61));
            }
        } else {
            this.latitudeOf1stPoint = Double.NaN;
            this.longitudeOf1stPoint = Double.NaN;
            this.latitudeOf2ndPoint = Double.NaN;
            this.longitudeOf2ndPoint = Double.NaN;
            this.longitudeOfCentre = this.doubleValue(expected, Provider.LONG_OF_CENTRE, parameters);
            ObliqueMercator.ensureLongitudeInRange(Provider.LONG_OF_CENTRE, this.longitudeOfCentre, true);
            this.alpha_c = this.doubleValue(expected, Provider.AZIMUTH, parameters);
            if (this.alpha_c > -4.71238898038469 && this.alpha_c < -1.5707963267948966 || this.alpha_c > 1.5707963267948966 && this.alpha_c < 4.71238898038469) {
                throw new IllegalArgumentException(Errors.format(145, new Double(Math.toDegrees(this.alpha_c)), new Double(-90.0), new Double(90.0)));
            }
            this.rectGridAngle = this.doubleValue(expected, Provider.RECTIFIED_GRID_ANGLE, parameters);
            if (Double.isNaN(this.rectGridAngle)) {
                this.rectGridAngle = this.alpha_c;
            }
        }
        double com = Math.sqrt(1.0 - this.excentricitySquared);
        double sinphi0 = Math.sin(this.latitudeOfCentre);
        double cosphi0 = Math.cos(this.latitudeOfCentre);
        this.B = cosphi0 * cosphi0;
        this.B = Math.sqrt(1.0 + this.excentricitySquared * this.B * this.B / (1.0 - this.excentricitySquared));
        double con = 1.0 - this.excentricitySquared * sinphi0 * sinphi0;
        this.A = this.B * com / con;
        double D = this.B * com / (cosphi0 * Math.sqrt(con));
        double F = D * D - 1.0;
        if (F < 0.0) {
            F = 0.0;
        } else {
            F = Math.sqrt(F);
            if (this.latitudeOfCentre < 0.0) {
                F = -F;
            }
        }
        F += D;
        this.E = F * Math.pow(this.tsfn(this.latitudeOfCentre, sinphi0), this.B);
        if (twoPoint) {
            double H = Math.pow(this.tsfn(this.latitudeOf1stPoint, Math.sin(this.latitudeOf1stPoint)), this.B);
            double L = Math.pow(this.tsfn(this.latitudeOf2ndPoint, Math.sin(this.latitudeOf2ndPoint)), this.B);
            double Fp = this.E / H;
            double P = (L - H) / (L + H);
            double J = this.E * this.E;
            J = (J - L * H) / (J + L * H);
            double diff = this.longitudeOf1stPoint - this.longitudeOf2ndPoint;
            if (diff < -Math.PI) {
                this.longitudeOf2ndPoint -= Math.PI * 2;
            } else if (diff > Math.PI) {
                this.longitudeOf2ndPoint += Math.PI * 2;
            }
            this.centralMeridian = ObliqueMercator.rollLongitude(0.5 * (this.longitudeOf1stPoint + this.longitudeOf2ndPoint) - Math.atan(J * Math.tan(0.5 * this.B * (this.longitudeOf1stPoint - this.longitudeOf2ndPoint)) / P) / this.B);
            gamma0 = Math.atan(2.0 * Math.sin(this.B * ObliqueMercator.rollLongitude(this.longitudeOf1stPoint - this.centralMeridian)) / (Fp - 1.0 / Fp));
            this.rectGridAngle = this.alpha_c = Math.asin(D * Math.sin(gamma0));
        } else {
            gamma0 = Math.asin(Math.sin(this.alpha_c) / D);
            double temp = 0.5 * (F - 1.0 / F) * Math.tan(gamma0);
            if (Math.abs(temp) > 1.0) {
                if (Math.abs(Math.abs(temp) - 1.0) > 1.0E-6) {
                    throw new IllegalArgumentException("Tolerance condition error");
                }
                temp = temp > 0.0 ? 1.0 : -1.0;
            }
            this.centralMeridian = this.longitudeOfCentre - Math.asin(temp) / this.B;
        }
        this.singamma0 = Math.sin(gamma0);
        this.cosgamma0 = Math.cos(gamma0);
        this.sinrot = Math.sin(this.rectGridAngle);
        this.cosrot = Math.cos(this.rectGridAngle);
        this.ArB = this.A / this.B;
        this.AB = this.A * this.B;
        this.BrA = this.B / this.A;
        this.v_pole_n = this.ArB * Math.log(Math.tan(0.5 * (1.5707963267948966 - gamma0)));
        this.v_pole_s = this.ArB * Math.log(Math.tan(0.5 * (1.5707963267948966 + gamma0)));
        if (hotine) {
            this.u_c = 0.0;
        } else if (Math.abs(Math.abs(this.alpha_c) - 1.5707963267948966) < 1.0E-10) {
            this.u_c = this.A * (this.longitudeOfCentre - this.centralMeridian);
        } else {
            this.u_c = Math.abs(this.ArB * Math.atan2(Math.sqrt(D * D - 1.0), Math.cos(this.alpha_c)));
            if (this.latitudeOfCentre < 0.0) {
                this.u_c = -this.u_c;
            }
        }
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        if (this.hotine) {
            return this.twoPoint ? Provider_Hotine_TwoPoint.PARAMETERS : Provider_Hotine.PARAMETERS;
        }
        return this.twoPoint ? Provider_TwoPoint.PARAMETERS : Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        List expected = this.getParameterDescriptors().descriptors();
        if (this.twoPoint) {
            this.set(expected, Provider_TwoPoint.LAT_OF_CENTRE, values, this.latitudeOfCentre);
            this.set(expected, Provider_TwoPoint.LAT_OF_1ST_POINT, values, this.latitudeOf1stPoint);
            this.set(expected, Provider_TwoPoint.LONG_OF_1ST_POINT, values, this.longitudeOf1stPoint);
            this.set(expected, Provider_TwoPoint.LAT_OF_2ND_POINT, values, this.latitudeOf2ndPoint);
            this.set(expected, Provider_TwoPoint.LONG_OF_2ND_POINT, values, this.longitudeOf2ndPoint);
        } else {
            this.set(expected, Provider.LAT_OF_CENTRE, values, this.latitudeOfCentre);
            this.set(expected, Provider.LONG_OF_CENTRE, values, this.longitudeOfCentre);
            this.set(expected, Provider.AZIMUTH, values, this.alpha_c);
            this.set(expected, Provider.RECTIFIED_GRID_ANGLE, values, this.rectGridAngle);
        }
        return values;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double u;
        double v;
        if (Math.abs(Math.abs(y) - 1.5707963267948966) > 1.0E-6) {
            double V;
            double temp;
            double Q = this.E / Math.pow(this.tsfn(y, Math.sin(y)), this.B);
            double S = 0.5 * (Q - (temp = 1.0 / Q));
            double U = (S * this.singamma0 - (V = Math.sin(this.B * x)) * this.cosgamma0) / (0.5 * (Q + temp));
            if (Math.abs(Math.abs(U) - 1.0) < 1.0E-6) {
                throw new ProjectionException(Errors.format(147, "v"));
            }
            v = 0.5 * this.ArB * Math.log((1.0 - U) / (1.0 + U));
            temp = Math.cos(this.B * x);
            u = Math.abs(temp) < 1.0E-10 ? this.AB * x : this.ArB * Math.atan2(S * this.cosgamma0 + V * this.singamma0, temp);
        } else {
            v = y > 0.0 ? this.v_pole_n : this.v_pole_s;
            u = this.ArB * y;
        }
        x = v * this.cosrot + (u -= this.u_c) * this.sinrot;
        y = u * this.cosrot - v * this.sinrot;
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double v = x * this.cosrot - y * this.sinrot;
        double u = y * this.cosrot + x * this.sinrot + this.u_c;
        double Qp = Math.exp(-this.BrA * v);
        double temp = 1.0 / Qp;
        double Sp = 0.5 * (Qp - temp);
        double Vp = Math.sin(this.BrA * u);
        double Up = (Vp * this.cosgamma0 + Sp * this.singamma0) / (0.5 * (Qp + temp));
        if (Math.abs(Math.abs(Up) - 1.0) < 1.0E-6) {
            x = 0.0;
            y = Up < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            y = Math.pow(this.E / Math.sqrt((1.0 + Up) / (1.0 - Up)), 1.0 / this.B);
            y = this.cphi2(y);
            x = -Math.atan2(Sp * this.cosgamma0 - Vp * this.singamma0, Math.cos(this.BrA * u)) / this.B;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected double getToleranceForAssertions(double longitude, double latitude) {
        if (Math.abs(longitude - this.centralMeridian) / 2.0 + Math.abs(latitude - this.latitudeOfCentre) > 10.0) {
            return 1.0;
        }
        return super.getToleranceForAssertions(longitude, latitude);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.latitudeOfCentre);
        code = code * 37L + Double.doubleToLongBits(this.longitudeOfCentre);
        code = code * 37L + Double.doubleToLongBits(this.alpha_c);
        code = code * 37L + Double.doubleToLongBits(this.rectGridAngle);
        code = code * 37L + Double.doubleToLongBits(this.latitudeOf1stPoint);
        code = code * 37L + Double.doubleToLongBits(this.latitudeOf2ndPoint);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ObliqueMercator that = (ObliqueMercator)object;
            return ObliqueMercator.equals(this.latitudeOfCentre, that.latitudeOfCentre) && ObliqueMercator.equals(this.longitudeOfCentre, that.longitudeOfCentre) && ObliqueMercator.equals(this.alpha_c, that.alpha_c) && ObliqueMercator.equals(this.rectGridAngle, that.rectGridAngle) && ObliqueMercator.equals(this.u_c, that.u_c) && ObliqueMercator.equals(this.latitudeOf1stPoint, that.latitudeOf1stPoint) && ObliqueMercator.equals(this.longitudeOf1stPoint, that.longitudeOf1stPoint) && ObliqueMercator.equals(this.latitudeOf2ndPoint, that.latitudeOf2ndPoint) && ObliqueMercator.equals(this.longitudeOf2ndPoint, that.longitudeOf2ndPoint) && this.twoPoint == that.twoPoint && this.hotine == that.hotine;
        }
        return false;
    }

    public static final class Provider_Hotine_TwoPoint
    extends Provider_TwoPoint {
        static final ParameterDescriptorGroup PARAMETERS = Provider_Hotine_TwoPoint.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Hotine_Oblique_Mercator_Two_Point_Natural_Origin"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(115))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LAT_OF_1ST_POINT, LONG_OF_1ST_POINT, LAT_OF_2ND_POINT, LONG_OF_2ND_POINT, LAT_OF_CENTRE, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider_Hotine_TwoPoint() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$CylindricalProjection == null ? (class$org$opengis$referencing$operation$CylindricalProjection = ObliqueMercator.class$("org.opengis.referencing.operation.CylindricalProjection")) : class$org$opengis$referencing$operation$CylindricalProjection;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            return new ObliqueMercator(parameters, descriptors, true, true);
        }
    }

    public static class Provider_TwoPoint
    extends Provider {
        public static final ParameterDescriptor LAT_OF_CENTRE = Provider_TwoPoint.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "latitude_of_center"), new NamedIdentifier(Citations.EPSG, "Latitude of projection centre"), new NamedIdentifier(Citations.ESRI, "Latitude_Of_Center"), new NamedIdentifier(Citations.GEOTIFF, "CenterLat")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LAT_OF_1ST_POINT = Provider_TwoPoint.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Latitude_Of_1st_Point")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LONG_OF_1ST_POINT = Provider_TwoPoint.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Longitude_Of_1st_Point")}, 0.0, -180.0, 180.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LAT_OF_2ND_POINT = Provider_TwoPoint.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Latitude_Of_2nd_Point")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LONG_OF_2ND_POINT = Provider_TwoPoint.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Longitude_Of_2nd_Point")}, 0.0, -180.0, 180.0, NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider_TwoPoint.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Hotine_Oblique_Mercator_Two_Point_Center"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(115))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LAT_OF_1ST_POINT, LONG_OF_1ST_POINT, LAT_OF_2ND_POINT, LONG_OF_2ND_POINT, LAT_OF_CENTRE, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider_TwoPoint() {
            super(PARAMETERS);
        }

        protected Provider_TwoPoint(ParameterDescriptorGroup params) {
            super(params);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$CylindricalProjection == null ? (class$org$opengis$referencing$operation$CylindricalProjection = ObliqueMercator.class$("org.opengis.referencing.operation.CylindricalProjection")) : class$org$opengis$referencing$operation$CylindricalProjection;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            return new ObliqueMercator(parameters, descriptors, false, true);
        }
    }

    public static final class Provider_Hotine
    extends Provider {
        static final ParameterDescriptorGroup PARAMETERS = Provider_Hotine.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Hotine_Oblique_Mercator"), new NamedIdentifier(Citations.EPSG, "Hotine Oblique Mercator"), new NamedIdentifier(Citations.EPSG, "9812"), new NamedIdentifier(Citations.GEOTIFF, "CT_ObliqueMercator_Hotine"), new NamedIdentifier(Citations.ESRI, "Hotine_Oblique_Mercator_Azimuth_Natural_Origin"), new NamedIdentifier(Citations.ESRI, "Rectified_Skew_Orthomorphic_Natural_Origin"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(115))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LONG_OF_CENTRE, LAT_OF_CENTRE, AZIMUTH, RECTIFIED_GRID_ANGLE, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider_Hotine() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$CylindricalProjection == null ? (class$org$opengis$referencing$operation$CylindricalProjection = ObliqueMercator.class$("org.opengis.referencing.operation.CylindricalProjection")) : class$org$opengis$referencing$operation$CylindricalProjection;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            return new ObliqueMercator(parameters, descriptors, true, false);
        }
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptor LAT_OF_CENTRE = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "latitude_of_center"), new NamedIdentifier(Citations.EPSG, "Latitude of projection centre"), new NamedIdentifier(Citations.ESRI, "Latitude_Of_Center"), new NamedIdentifier(Citations.GEOTIFF, "CenterLat")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LONG_OF_CENTRE = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "longitude_of_center"), new NamedIdentifier(Citations.EPSG, "Longitude of projection centre"), new NamedIdentifier(Citations.ESRI, "Longitude_Of_Center"), new NamedIdentifier(Citations.GEOTIFF, "CenterLong")}, 0.0, -180.0, 180.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor AZIMUTH = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "azimuth"), new NamedIdentifier(Citations.ESRI, "Azimuth"), new NamedIdentifier(Citations.EPSG, "Azimuth of initial line"), new NamedIdentifier(Citations.GEOTIFF, "AzimuthAngle")}, 0.0, -360.0, 360.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor RECTIFIED_GRID_ANGLE = Provider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "rectified_grid_angle"), new NamedIdentifier(Citations.EPSG, "Angle from Rectified to Skew Grid"), new NamedIdentifier(Citations.ESRI, "XY_Plane_Rotation"), new NamedIdentifier(Citations.GEOTIFF, "RectifiedGridAngle")}, -360.0, 360.0, NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Oblique_Mercator"), new NamedIdentifier(Citations.EPSG, "Oblique Mercator"), new NamedIdentifier(Citations.EPSG, "9815"), new NamedIdentifier(Citations.GEOTIFF, "CT_ObliqueMercator"), new NamedIdentifier(Citations.ESRI, "Hotine_Oblique_Mercator_Azimuth_Center"), new NamedIdentifier(Citations.ESRI, "Rectified_Skew_Orthomorphic_Center"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(115))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LONG_OF_CENTRE, LAT_OF_CENTRE, AZIMUTH, RECTIFIED_GRID_ANGLE, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        protected Provider(ParameterDescriptorGroup params) {
            super(params);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$CylindricalProjection == null ? (class$org$opengis$referencing$operation$CylindricalProjection = ObliqueMercator.class$("org.opengis.referencing.operation.CylindricalProjection")) : class$org$opengis$referencing$operation$CylindricalProjection;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            return new ObliqueMercator(parameters, descriptors, false, false);
        }
    }
}

