/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.dbf;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.geotools.data.shapefile.dbf.DbaseFileReader;

public class IndexedDbaseFileReader
extends DbaseFileReader {
    public void goTo(int recno) throws IOException, UnsupportedOperationException {
        if (this.randomAccessEnabled) {
            int newPosition = this.header.getHeaderLength() + this.header.getRecordLength() * (recno - 1);
            if (this.useMemoryMappedBuffer) {
                this.buffer.position(newPosition);
            } else {
                FileChannel fc = (FileChannel)this.channel;
                fc.position(newPosition);
                this.buffer.limit(this.buffer.capacity());
                this.buffer.position(0);
                this.fill(this.buffer, this.channel);
                this.buffer.position(0);
                this.currentOffset = newPosition;
            }
        } else {
            throw new UnsupportedOperationException("Random access not enabled!");
        }
    }

    public IndexedDbaseFileReader(ReadableByteChannel channel) throws IOException {
        this(channel, true);
    }

    public IndexedDbaseFileReader(ReadableByteChannel channel, boolean useMemoryMappedBuffer) throws IOException {
        super(channel, useMemoryMappedBuffer);
    }

    public IndexedDbaseFileReader(ReadableByteChannel channel, boolean useMemoryMappedBuffer, Charset stringCharset) throws IOException {
        super(channel, useMemoryMappedBuffer, stringCharset);
    }

    public boolean IsRandomAccessEnabled() {
        return this.randomAccessEnabled;
    }

    public static void main(String[] args) throws Exception {
        FileChannel channel = new FileInputStream(args[0]).getChannel();
        IndexedDbaseFileReader reader = new IndexedDbaseFileReader(channel, true);
        System.out.println(reader.getHeader());
        int r = 0;
        while (reader.hasNext()) {
            System.out.println(++r + "," + Arrays.asList(reader.readEntry()));
        }
        reader.close();
    }
}

