/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.data.shapefile.indexed.IndexedFidReader;
import org.geotools.resources.NIOUtilities;

public class IndexedFidWriter {
    public static final int HEADER_SIZE = 13;
    public static final int RECORD_SIZE = 12;
    private FileChannel channel;
    private ByteBuffer writeBuffer;
    private IndexedFidReader reader;
    long fidIndex;
    private int recordIndex;
    private boolean closed;
    private long current;
    private long position;
    private int removes;
    StreamLogging streamLogger = new StreamLogging("IndexedFidReader");

    public IndexedFidWriter(FileChannel writeChannel, IndexedFidReader reader2) throws IOException {
        this.channel = writeChannel;
        this.reader = reader2;
        this.streamLogger.open();
        this.allocateBuffers();
        this.removes = this.reader.getRemoves();
        this.writeBuffer.position(13);
        this.closed = false;
        this.position = 0L;
        this.current = -1L;
        this.recordIndex = 0;
        this.fidIndex = 0L;
    }

    private void allocateBuffers() {
        this.writeBuffer = ByteBuffer.allocateDirect(12301);
    }

    private void drain() throws IOException {
        this.writeBuffer.flip();
        int written = 0;
        while (this.writeBuffer.remaining() > 0) {
            written += this.channel.write(this.writeBuffer, this.position);
        }
        this.position += (long)written;
        this.writeBuffer.flip().limit(this.writeBuffer.capacity());
    }

    private void writeHeader() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(13);
        buffer.put((byte)1);
        buffer.putLong(this.recordIndex);
        buffer.putInt(this.removes);
        buffer.flip();
        this.channel.write(buffer, 0L);
    }

    public boolean hasNext() throws IOException {
        return this.reader.hasNext();
    }

    public long next() throws IOException {
        if (this.current != -1L) {
            this.write();
        }
        if (this.reader.hasNext()) {
            String fid = this.reader.next();
            this.fidIndex = Integer.parseInt(fid.substring(fid.lastIndexOf(".") + 1));
        } else {
            ++this.fidIndex;
        }
        this.current = this.fidIndex;
        return this.fidIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            while (this.hasNext()) {
                this.next();
            }
            if (this.current != -1L) {
                this.write();
            }
            this.drain();
            this.writeHeader();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                if (this.writeBuffer != null && this.writeBuffer instanceof MappedByteBuffer) {
                    NIOUtilities.clean((ByteBuffer)this.writeBuffer);
                }
                if (this.channel.isOpen()) {
                    this.channel.close();
                }
                this.streamLogger.close();
            }
            finally {
                this.reader.close();
            }
            throw throwable;
        }
        try {
            if (this.writeBuffer != null && this.writeBuffer instanceof MappedByteBuffer) {
                NIOUtilities.clean((ByteBuffer)this.writeBuffer);
            }
            if (this.channel.isOpen()) {
                this.channel.close();
            }
            this.streamLogger.close();
        }
        finally {
            this.reader.close();
        }
        this.closed = true;
    }

    public void remove() throws IOException {
        if (this.current == -1L) {
            throw new IOException("Current fid index is null, next must be called before remove");
        }
        if (this.hasNext()) {
            ++this.removes;
            this.current = -1L;
        }
    }

    public void write() throws IOException {
        if (this.current == -1L) {
            throw new IOException("Current fid index is null, next must be called before remove");
        }
        if (this.writeBuffer == null) {
            this.allocateBuffers();
        }
        if (this.writeBuffer.remaining() < 12) {
            this.drain();
        }
        this.writeBuffer.putLong(this.current);
        this.writeBuffer.putInt(this.recordIndex);
        ++this.recordIndex;
        this.current = -1L;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

