/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.xsd.XSDSchema;
import org.geotools.xml.Configuration;
import org.geotools.xml.impl.ParserHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser {
    private ParserHandler handler;
    private SAXParser parser;
    private InputStream input;

    public Parser(Configuration configuration) throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        this.parser = spf.newSAXParser();
        this.handler = new ParserHandler(configuration);
    }

    public Parser(Configuration configuration, String input) throws ParserConfigurationException, SAXException, IOException, URISyntaxException {
        this(configuration, new BufferedInputStream(new FileInputStream(new File(new URI(input)))));
    }

    public Parser(Configuration configuration, InputStream input) throws ParserConfigurationException, SAXException {
        this(configuration);
        this.input = input;
    }

    public Object parse() throws IOException, SAXException {
        return this.parse(this.input);
    }

    public Object parse(InputStream input) throws IOException, SAXException {
        this.parser.parse(input, (DefaultHandler)this.handler);
        return this.handler.getValue();
    }

    public XSDSchema[] getSchemas() {
        if (this.handler != null) {
            return this.handler.getSchemas();
        }
        return null;
    }
}

