/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.eclipse.xsd.util.XSDUtil;
import org.geotools.xml.impl.TypeWalker;
import org.w3c.dom.Node;

public class Schemas {
    static /* synthetic */ Class class$org$eclipse$xsd$util$XSDSchemaLocator;
    static /* synthetic */ Class class$org$eclipse$xsd$util$XSDSchemaLocationResolver;

    public static final XSDSchema parse(String location) throws IOException {
        return Schemas.parse(location, null, null);
    }

    public static final XSDSchema parse(String location, XSDSchemaLocator[] locators, XSDSchemaLocationResolver[] resolvers) throws IOException {
        AdapterFactoryImpl adapterFactory;
        if (new File(location).exists()) {
            location = new File(location).getCanonicalPath();
        }
        URI uri = URI.createURI((String)location);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (resolvers != null && resolvers.length > 0) {
            adapterFactory = new SchemaLocationResolverAdapterFactory(resolvers);
            resourceSet.getAdapterFactories().add((Object)adapterFactory);
        }
        if (locators != null && locators.length > 0) {
            adapterFactory = new SchemaLocatorAdapterFactory(locators);
            resourceSet.getAdapterFactories().add((Object)adapterFactory);
        }
        XSDResourceImpl xsdMainResource = (XSDResourceImpl)resourceSet.createResource(URI.createURI((String)".xsd"));
        xsdMainResource.setURI(uri);
        xsdMainResource.load(resourceSet.getLoadOptions());
        return xsdMainResource.getSchema();
    }

    public static final List getChildElementDeclarations(XSDElementDeclaration element) {
        return Schemas.getChildElementDeclarations(element.getType());
    }

    public static final List getChildElementDeclarations(XSDTypeDefinition type) {
        return Schemas.getChildElementDeclarations(type, true);
    }

    public static final List getChildElementDeclarations(XSDElementDeclaration element, boolean includeParents) {
        return Schemas.getChildElementDeclarations(element.getType(), includeParents);
    }

    public static final List getChildElementDeclarations(XSDTypeDefinition type, boolean includeParents) {
        final ArrayList elements = new ArrayList();
        TypeWalker.Visitor visitor = new TypeWalker.Visitor(){

            public boolean visit(XSDTypeDefinition type) {
                if (type instanceof XSDSimpleTypeDefinition) {
                    return true;
                }
                XSDComplexTypeDefinition cType = (XSDComplexTypeDefinition)type;
                ElementVisitor visitor = new ElementVisitor(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void visit(XSDParticle particle) {
                        XSDElementDeclaration decl = (XSDElementDeclaration)particle.getContent();
                        if (!decl.isElementDeclarationReference()) {
                            1.access$000(this.this$0).add(decl);
                        } else {
                            1.access$000(this.this$0).add(decl.getResolvedElementDeclaration());
                        }
                    }
                };
                Schemas.visitElements(cType, visitor);
                return true;
            }

            static /* synthetic */ ArrayList access$000(1 x0) {
                return x0.elements;
            }
        };
        if (includeParents) {
            TypeWalker walker = new TypeWalker(type);
            walker.walk(visitor);
        } else {
            visitor.visit(type);
        }
        return elements;
    }

    public static final int getMinOccurs(XSDComplexTypeDefinition type, XSDElementDeclaration element) {
        final XSDElementDeclaration fElement = element;
        final ArrayList minOccurs = new ArrayList();
        ElementVisitor visitor = new ElementVisitor(){

            public void visit(XSDParticle particle) {
                XSDElementDeclaration decl = (XSDElementDeclaration)particle.getContent();
                if (decl.isElementDeclarationReference()) {
                    decl = decl.getResolvedElementDeclaration();
                }
                if (decl == fElement) {
                    minOccurs.add(new Integer(particle.getMinOccurs()));
                }
            }
        };
        Schemas.visitElements(type, visitor);
        if (minOccurs.isEmpty()) {
            throw new IllegalArgumentException("Element: " + element + " not found in type: " + type);
        }
        return (Integer)minOccurs.get(0);
    }

    public static final int getMaxOccurs(XSDComplexTypeDefinition type, XSDElementDeclaration element) {
        final XSDElementDeclaration fElement = element;
        final ArrayList maxOccurs = new ArrayList();
        ElementVisitor visitor = new ElementVisitor(){

            public void visit(XSDParticle particle) {
                XSDElementDeclaration decl = (XSDElementDeclaration)particle.getContent();
                if (decl.isElementDeclarationReference()) {
                    decl = decl.getResolvedElementDeclaration();
                }
                if (decl == fElement) {
                    maxOccurs.add(new Integer(particle.getMaxOccurs()));
                }
            }
        };
        Schemas.visitElements(type, visitor);
        if (maxOccurs.isEmpty()) {
            throw new IllegalArgumentException("Element: " + element + " not found in type: " + type);
        }
        return (Integer)maxOccurs.get(0);
    }

    private static void visitElements(XSDComplexTypeDefinition cType, ElementVisitor visitor) {
        if (cType.getContent() == null || cType.getContent() instanceof XSDSimpleTypeDefinition) {
            return;
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.addLast(cType.getContent());
        while (!queue.isEmpty()) {
            XSDParticle particle = (XSDParticle)queue.removeFirst();
            int pType = XSDUtil.nodeType((Node)particle.getElement());
            if (pType == 11) {
                visitor.visit(particle);
                continue;
            }
            XSDModelGroup grp = null;
            switch (pType) {
                case 16: {
                    XSDModelGroupDefinition grpDef = (XSDModelGroupDefinition)particle.getContent();
                    if (grpDef.isModelGroupDefinitionReference()) {
                        grpDef = grpDef.getResolvedModelGroupDefinition();
                    }
                    grp = grpDef.getModelGroup();
                    break;
                }
                case 0: 
                case 7: 
                case 35: {
                    grp = (XSDModelGroup)particle.getContent();
                }
            }
            if (grp == null) continue;
            EList parts = grp.getParticles();
            Iterator itr = parts.iterator();
            while (itr.hasNext()) {
                queue.addLast(itr.next());
            }
        }
    }

    public static final XSDElementDeclaration getChildElementDeclaration(XSDElementDeclaration parent, QName qName) {
        XSDElementDeclaration child;
        List children = Schemas.getChildElementDeclarations(parent);
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            XSDElementDeclaration element = (XSDElementDeclaration)itr.next();
            if (!Schemas.nameMatches((XSDNamedComponent)element, qName)) continue;
            return element;
        }
        ArrayList derived = new ArrayList();
        Iterator itr2 = children.iterator();
        while (itr2.hasNext()) {
            child = (XSDElementDeclaration)itr2.next();
            derived.addAll(Schemas.getDerivedElementDeclarations(child));
        }
        itr2 = derived.iterator();
        while (itr2.hasNext()) {
            child = (XSDElementDeclaration)itr2.next();
            if (!Schemas.nameMatches((XSDNamedComponent)child, qName)) continue;
            return child;
        }
        return null;
    }

    public static final List getDerivedElementDeclarations(XSDElementDeclaration element) {
        EList elements = element.getSchema().getElementDeclarations();
        ArrayList<XSDElementDeclaration> derived = new ArrayList<XSDElementDeclaration>();
        Iterator itr = elements.iterator();
        block0: while (itr.hasNext()) {
            XSDElementDeclaration derivee = (XSDElementDeclaration)itr.next();
            if (derivee.equals(element)) continue;
            XSDTypeDefinition type = derivee.getType();
            while (true) {
                if (type.equals(element.getType())) {
                    derived.add(derivee);
                    continue block0;
                }
                if (type.equals(type.getBaseType())) continue block0;
                type = type.getBaseType();
            }
        }
        return derived;
    }

    public static final List getAttributeDeclarations(XSDElementDeclaration element) {
        final ArrayList attributes = new ArrayList();
        TypeWalker walker = new TypeWalker(element.getType());
        TypeWalker.Visitor visitor = new TypeWalker.Visitor(){

            public boolean visit(XSDTypeDefinition type) {
                if (type instanceof XSDSimpleTypeDefinition) {
                    return true;
                }
                XSDComplexTypeDefinition cType = (XSDComplexTypeDefinition)type;
                EList attContent = cType.getAttributeContents();
                Iterator itr = attContent.iterator();
                while (itr.hasNext()) {
                    XSDAttributeGroupContent content = (XSDAttributeGroupContent)itr.next();
                    if (content instanceof XSDAttributeUse) {
                        XSDAttributeUse use = (XSDAttributeUse)content;
                        attributes.add(use.getAttributeDeclaration());
                        continue;
                    }
                    if (!(content instanceof XSDAttributeGroupDefinition)) continue;
                    XSDAttributeGroupDefinition attGrp = (XSDAttributeGroupDefinition)content;
                    if (attGrp.isAttributeGroupDefinitionReference()) {
                        attGrp = attGrp.getResolvedAttributeGroupDefinition();
                    }
                    EList uses = attGrp.getAttributeUses();
                    Iterator aitr = uses.iterator();
                    while (aitr.hasNext()) {
                        XSDAttributeUse use = (XSDAttributeUse)aitr.next();
                        attributes.add(use.getAttributeDeclaration());
                    }
                }
                return true;
            }
        };
        walker.walk(visitor);
        return attributes;
    }

    public static final XSDAttributeDeclaration getAttributeDeclaration(XSDElementDeclaration element, QName qName) {
        List atts = Schemas.getAttributeDeclarations(element);
        Iterator itr = atts.iterator();
        while (itr.hasNext()) {
            XSDAttributeDeclaration att = (XSDAttributeDeclaration)itr.next();
            if (!Schemas.nameMatches((XSDNamedComponent)att, qName)) continue;
            return att;
        }
        return null;
    }

    public static final List getIncludes(XSDSchema schema) {
        LinkedList<XSDSchema> queue = new LinkedList<XSDSchema>();
        ArrayList<XSDInclude> includes = new ArrayList<XSDInclude>();
        HashSet<String> added = new HashSet<String>();
        queue.addLast(schema);
        while (!queue.isEmpty()) {
            schema = (XSDSchema)queue.removeFirst();
            EList contents = schema.getContents();
            Iterator itr = contents.iterator();
            while (itr.hasNext()) {
                XSDInclude include;
                XSDSchemaContent content = (XSDSchemaContent)itr.next();
                if (!(content instanceof XSDInclude) || added.contains((include = (XSDInclude)content).getSchemaLocation())) continue;
                includes.add(include);
                added.add(include.getSchemaLocation());
                queue.addLast(include.getIncorporatedSchema());
            }
        }
        return includes;
    }

    private static final boolean nameMatches(XSDNamedComponent component, QName qName) {
        if (component.getTargetNamespace() == null || "".equals(component.getTargetNamespace())) {
            if (qName.getNamespaceURI() == null || "".equals(qName.getNamespaceURI())) {
                return component.getName().equals(qName.getLocalPart());
            }
            if (component.getSchema().getTargetNamespace().equals(qName.getNamespaceURI()) && component.getName().equals(qName.getLocalPart())) {
                return true;
            }
        } else if (component.getTargetNamespace().equals(qName.getNamespaceURI()) && component.getName().equals(qName.getLocalPart())) {
            return true;
        }
        return false;
    }

    public static String getTargetPrefix(XSDSchema schema) {
        String ns = schema.getTargetNamespace();
        Map pre2ns = schema.getQNamePrefixToNamespaceMap();
        Iterator itr = pre2ns.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            if (!entry.getValue().equals(ns)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    static {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
    }

    static class SchemaLocationResolverAdapter
    extends AdapterImpl
    implements XSDSchemaLocationResolver {
        XSDSchemaLocationResolver[] resolvers;

        public SchemaLocationResolverAdapter(XSDSchemaLocationResolver[] resolvers) {
            this.resolvers = resolvers;
        }

        public boolean isAdapterForType(Object type) {
            return type == (class$org$eclipse$xsd$util$XSDSchemaLocationResolver == null ? (class$org$eclipse$xsd$util$XSDSchemaLocationResolver = Schemas.class$("org.eclipse.xsd.util.XSDSchemaLocationResolver")) : class$org$eclipse$xsd$util$XSDSchemaLocationResolver);
        }

        public String resolveSchemaLocation(XSDSchema schema, String namespaceURI, String rawSchemaLocationURI) {
            for (int i = 0; i < this.resolvers.length; ++i) {
                String resolved = this.resolvers[i].resolveSchemaLocation(schema, namespaceURI, rawSchemaLocationURI);
                if (resolved == null) continue;
                return resolved;
            }
            return null;
        }
    }

    static class SchemaLocationResolverAdapterFactory
    extends AdapterFactoryImpl {
        SchemaLocationResolverAdapter adapter;

        public SchemaLocationResolverAdapterFactory(XSDSchemaLocationResolver[] resolvers) {
            this.adapter = new SchemaLocationResolverAdapter(resolvers);
        }

        public boolean isFactoryForType(Object type) {
            return type == (class$org$eclipse$xsd$util$XSDSchemaLocationResolver == null ? (class$org$eclipse$xsd$util$XSDSchemaLocationResolver = Schemas.class$("org.eclipse.xsd.util.XSDSchemaLocationResolver")) : class$org$eclipse$xsd$util$XSDSchemaLocationResolver);
        }

        public Adapter adaptNew(Notifier notifier, Object type) {
            return this.adapter;
        }
    }

    static class SchemaLocatorAdapter
    extends AdapterImpl
    implements XSDSchemaLocator {
        XSDSchemaLocator[] locators;

        public SchemaLocatorAdapter(XSDSchemaLocator[] locators) {
            this.locators = locators;
        }

        public boolean isAdapterForType(Object type) {
            return type == (class$org$eclipse$xsd$util$XSDSchemaLocator == null ? (class$org$eclipse$xsd$util$XSDSchemaLocator = Schemas.class$("org.eclipse.xsd.util.XSDSchemaLocator")) : class$org$eclipse$xsd$util$XSDSchemaLocator);
        }

        public XSDSchema locateSchema(XSDSchema xsdSchema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
            for (int i = 0; i < this.locators.length; ++i) {
                XSDSchema schema = this.locators[i].locateSchema(xsdSchema, namespaceURI, rawSchemaLocationURI, resolvedSchemaLocationURI);
                if (schema == null) continue;
                return schema;
            }
            return null;
        }
    }

    static class SchemaLocatorAdapterFactory
    extends AdapterFactoryImpl {
        SchemaLocatorAdapter adapter;

        public SchemaLocatorAdapterFactory(XSDSchemaLocator[] locators) {
            this.adapter = new SchemaLocatorAdapter(locators);
        }

        public boolean isFactoryForType(Object type) {
            return type == (class$org$eclipse$xsd$util$XSDSchemaLocator == null ? (class$org$eclipse$xsd$util$XSDSchemaLocator = Schemas.class$("org.eclipse.xsd.util.XSDSchemaLocator")) : class$org$eclipse$xsd$util$XSDSchemaLocator);
        }

        public Adapter adaptNew(Notifier notifier, Object type) {
            return this.adapter;
        }
    }

    private static interface ElementVisitor {
        public void visit(XSDParticle var1);
    }
}

