/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.xml.Configuration;
import org.geotools.xml.impl.StreamingParserHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StreamingParser {
    private StreamingParserHandler handler;
    private SAXParser parser;
    private InputStream input;
    private Thread thread;

    public StreamingParser(Configuration configuration, String input, String xpath) throws ParserConfigurationException, SAXException, FileNotFoundException {
        this(configuration, new BufferedInputStream(new FileInputStream(input)), xpath);
    }

    public StreamingParser(Configuration configuration, InputStream input, String xpath) throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        this.parser = spf.newSAXParser();
        this.handler = new StreamingParserHandler(configuration, xpath);
        this.input = input;
    }

    public Object parse() {
        if (this.thread == null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        StreamingParser.this.parser.parse(StreamingParser.this.input, (DefaultHandler)StreamingParser.this.handler);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
            };
            this.thread = new Thread(runnable);
            this.thread.start();
        }
        return this.handler.getBuffer().get();
    }
}

