/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.codegen;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.xsd.XSDSchema;

public abstract class AbstractGenerator {
    static Logger logger = Logger.getLogger("org.geotools.xml");
    String packageBase;
    String location;
    boolean overwriting = false;
    Class[] bindingConstructorArguments;

    public void setPackageBase(String packageBase) {
        this.packageBase = packageBase;
    }

    public String getPackageBase() {
        return this.packageBase;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setOverwriting(boolean overwriting) {
        this.overwriting = overwriting;
    }

    public void setBindingConstructorArguments(Class[] bindingConstructorArguments) {
        this.bindingConstructorArguments = bindingConstructorArguments;
    }

    protected void write(String result, String className) throws IOException {
        File location = this.outputLocation();
        location.mkdirs();
        location = new File(location, className + ".java");
        if (location.exists() && !this.overwriting) {
            logger.warning("Generated file: " + location + " already exists.");
            return;
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(location));
        if (this.packageBase != null) {
            out.write(("package " + this.packageBase + ";\n\n").getBytes());
        }
        out.write(result.getBytes());
        out.flush();
        out.close();
    }

    protected void copy(File file) throws IOException {
        File dest = new File(this.outputLocation(), file.getName());
        if (dest.exists() && !this.overwriting) {
            logger.warning("Generated file: " + dest + " already exists.");
            return;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        int b = -1;
        while ((b = ((InputStream)in).read()) != -1) {
            ((OutputStream)out).write(b);
        }
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        ((InputStream)in).close();
    }

    protected File outputLocation() {
        File location = null;
        location = this.location != null ? new File(this.location) : new File(System.getProperty("user.dir"));
        if (this.packageBase != null) {
            String path = this.packageBase.replace('.', File.separatorChar);
            location = new File(location, path);
        }
        return location;
    }

    protected String execute(String templateName, Object input) throws ClassNotFoundException, RuntimeException {
        Class<?> c = Class.forName("org.geotools.xml.codegen.templates." + templateName);
        try {
            Object template = c.newInstance();
            Method generate = c.getMethod("generate", Object.class);
            return (String)generate.invoke(template, input);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    String prefix(XSDSchema schema) {
        String uri = schema.getTargetNamespace();
        Iterator i = schema.getQNamePrefixToNamespaceMap().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (!entry.getValue().equals(uri)) continue;
            return (String)entry.getKey();
        }
        return null;
    }
}

