/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.codegen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.xml.Schemas;
import org.geotools.xml.codegen.AbstractGenerator;

public class BindingGenerator
extends AbstractGenerator {
    static Logger logger = Logger.getLogger("org.geotools.xml");
    boolean generatingBindingInterface = true;
    boolean generatingBindingConfiguration = true;
    boolean generateAttributes = true;
    boolean generateElements = true;
    boolean generateTypes = true;

    public void setGeneratingBindingConfiguration(boolean generatingBindingConfiguration) {
        this.generatingBindingConfiguration = generatingBindingConfiguration;
    }

    public void setGeneratingBindingInterface(boolean generatingBindingInterface) {
        this.generatingBindingInterface = generatingBindingInterface;
    }

    public void setGenerateAttributes(boolean generateAttributes) {
        this.generateAttributes = generateAttributes;
    }

    public void setGenerateElements(boolean generateElements) {
        this.generateElements = generateElements;
    }

    public void setGenerateTypes(boolean generateTypes) {
        this.generateTypes = generateTypes;
    }

    public void generate(XSDSchema schema) {
        String msg;
        String result;
        ArrayList<Object> components = new ArrayList<Object>();
        if (this.generateElements) {
            EList elements = schema.getElementDeclarations();
            Iterator e = elements.iterator();
            while (e.hasNext()) {
                XSDElementDeclaration element = (XSDElementDeclaration)e.next();
                this.generate((XSDNamedComponent)element, schema);
                if (!this.target((XSDNamedComponent)element, schema)) continue;
                components.add(element);
            }
        }
        if (this.generateTypes) {
            EList types = schema.getTypeDefinitions();
            Iterator t = types.iterator();
            while (t.hasNext()) {
                XSDTypeDefinition type = (XSDTypeDefinition)t.next();
                this.generate((XSDNamedComponent)type, schema);
                if (!this.target((XSDNamedComponent)type, schema)) continue;
                components.add(type);
            }
        }
        if (this.generateAttributes) {
            EList attributes = schema.getAttributeDeclarations();
            Iterator a = attributes.iterator();
            while (a.hasNext()) {
                XSDAttributeDeclaration attribute = (XSDAttributeDeclaration)a.next();
                this.generate((XSDNamedComponent)attribute, schema);
                if (!this.target((XSDNamedComponent)attribute, schema)) continue;
                components.add(attribute);
            }
        }
        if (this.generatingBindingConfiguration) {
            try {
                result = this.execute("BindingConfigurationTemplate", new Object[]{schema, components});
                this.write(result, this.prefix(schema).toUpperCase() + "BindingConfiguration");
            }
            catch (Exception e) {
                msg = "Error generating binding configuration";
                logger.log(Level.WARNING, msg, e);
            }
        }
        if (this.generatingBindingInterface) {
            try {
                result = this.execute("BindingInterfaceTemplate", schema);
                this.write(result, this.prefix(schema).toUpperCase());
            }
            catch (Exception e) {
                msg = "Error generating binding interface";
                logger.log(Level.WARNING, msg, e);
            }
        }
    }

    boolean target(XSDNamedComponent c, XSDSchema schema) {
        return c.getTargetNamespace().equals(schema.getTargetNamespace());
    }

    void generate(XSDNamedComponent c, XSDSchema schema) {
        if (!this.target(c, schema)) {
            return;
        }
        try {
            String result = this.execute("CLASS", new Object[]{c, this.bindingConstructorArguments});
            this.write(result, this.name(c));
        }
        catch (Exception ioe) {
            String msg = "Unable to generate binding for " + c;
            logger.log(Level.WARNING, msg, ioe);
        }
    }

    String name(XSDNamedComponent c) {
        return c.getName().substring(0, 1).toUpperCase() + c.getName().substring(1) + "Binding";
    }

    public static void main(String[] args) throws Exception {
        XSDSchema schema = null;
        ArrayList cargList = new ArrayList();
        BindingGenerator g = new BindingGenerator();
        if (args.length == 0) {
            BindingGenerator.usage();
            System.exit(0);
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("--help".equals(arg)) {
                BindingGenerator.usage();
                System.exit(0);
            }
            if ("--schema".equals(arg)) {
                schema = Schemas.parse(args[++i]);
                continue;
            }
            if ("--output".equals(arg)) {
                g.setLocation(args[++i]);
                continue;
            }
            if ("--package".equals(arg)) {
                g.setPackageBase(args[++i]);
                continue;
            }
            if ("--carg".equals(arg)) {
                try {
                    cargList.add(Class.forName(args[++i]));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    String msg = "Could not load class: " + args[i];
                    throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
                }
            }
            if ("--noelements".equals(arg)) {
                g.setGenerateElements(false);
                continue;
            }
            if ("--noattributes".equals(arg)) {
                g.setGenerateAttributes(false);
                continue;
            }
            if (!"--notypes".equals(arg)) continue;
            g.setGenerateTypes(false);
        }
        Class[] cargs = null;
        if (!cargList.isEmpty()) {
            cargs = cargList.toArray(new Class[cargList.size()]);
        }
        if (schema == null) {
            String msg = "ERROR: schema not specified";
            BindingGenerator.usage();
            throw new IllegalArgumentException(msg);
        }
        if (g.getLocation() == null) {
            g.setLocation(System.getProperty("user.dir"));
        }
        g.setBindingConstructorArguments(cargs);
        g.generate(schema);
    }

    public static void usage() {
        System.out.println("Options");
        System.out.println("\t\t--help: Print this message");
        System.out.println("\t\t--schema <path>: Path to schema file");
        System.out.println("\t\t--output <path>: Path to output directory");
        System.out.println("\t\t--package <package>: Package out writen files");
        System.out.println("\t\t--carg <class>: Qualified class name of binding constructor argument");
        System.out.println("\t\t--noelements: Turn off element binding generation");
        System.out.println("\t\t--noattributes: Turn off attribute binding generation");
        System.out.println("\t\t--notypes: Turn off type binding generation");
    }
}

