/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.codegen;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDUtil;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Name;
import org.geotools.feature.type.SchemaImpl;
import org.geotools.xml.Schemas;
import org.geotools.xml.codegen.AbstractGenerator;
import org.opengis.feature.type.Schema;

public class SchemaGenerator
extends AbstractGenerator {
    XSDSchema schema;
    HashMap types;
    boolean simpleTypes;
    boolean complexTypes;
    boolean followComplexTypes;
    HashMap imports;
    Logger logger = Logger.getLogger("org.geotools.xml");
    static final /* synthetic */ boolean $assertionsDisabled;

    public SchemaGenerator(XSDSchema schema) {
        this.schema = schema;
        this.types = new HashMap();
        this.simpleTypes = true;
        this.complexTypes = true;
        this.followComplexTypes = true;
        this.imports = new HashMap();
    }

    public XSDSchema getSchema() {
        return this.schema;
    }

    public void setComplexTypes(boolean complexTypes) {
        this.complexTypes = complexTypes;
    }

    public void setSimpleTypes(boolean simpleTypes) {
        this.simpleTypes = simpleTypes;
    }

    public void setFollowComplexTypes(boolean followComplexTypes) {
        this.followComplexTypes = followComplexTypes;
    }

    public void addTypeMapping(String namespace, String name, AttributeType gtType) {
        if (namespace == null) {
            namespace = this.schema.getTargetNamespace();
        }
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        EList typeDefs = this.schema.getTypeDefinitions();
        Iterator itr = typeDefs.iterator();
        while (itr.hasNext()) {
            XSDTypeDefinition xsdType = (XSDTypeDefinition)itr.next();
            String tns = xsdType.getTargetNamespace();
            String tn = xsdType.getName();
            if (!namespace.equals(tns) || !name.equals(tn)) continue;
            this.types.put(xsdType, gtType);
            return;
        }
        throw new IllegalArgumentException("Type: [" + namespace + "," + name + "] not found");
    }

    public void addImport(Schema imported) {
        this.imports.put(imported.namespace().getURI(), imported);
    }

    public Schema getImport(String namespace) {
        return (Schema)this.imports.get(namespace);
    }

    public Collection getImports() {
        return this.imports.values();
    }

    public XSDTypeDefinition getXSDType(AttributeType type) {
        Iterator itr = this.types.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            XSDTypeDefinition xsdType = (XSDTypeDefinition)entry.getKey();
            AttributeType gtType = (AttributeType)entry.getValue();
            if (!gtType.equals(type)) continue;
            return xsdType;
        }
        return null;
    }

    public void generate() throws Exception {
        XSDTypeDefinition xsdType;
        Iterator itr;
        EList typeDefs = this.schema.getTypeDefinitions();
        if (this.simpleTypes) {
            itr = typeDefs.iterator();
            while (itr.hasNext()) {
                xsdType = (XSDTypeDefinition)itr.next();
                if (xsdType.getName() == null || !xsdType.getTargetNamespace().equals(this.schema.getTargetNamespace()) || !(xsdType instanceof XSDSimpleTypeDefinition)) continue;
                this.logger.info(xsdType.getName());
                this.createType((XSDTypeDefinition)((XSDSimpleTypeDefinition)xsdType));
            }
        }
        if (this.complexTypes) {
            itr = typeDefs.iterator();
            while (itr.hasNext()) {
                xsdType = (XSDTypeDefinition)itr.next();
                if (xsdType.getName() == null || !xsdType.getTargetNamespace().equals(this.schema.getTargetNamespace()) || !(xsdType instanceof XSDComplexTypeDefinition)) continue;
                this.logger.info(xsdType.getName());
                this.createType((XSDTypeDefinition)((XSDComplexTypeDefinition)xsdType));
            }
        }
        SchemaImpl gtSchema = new SchemaImpl(this.schema.getTargetNamespace());
        Iterator itr2 = this.types.values().iterator();
        while (itr2.hasNext()) {
            AttributeType gtType = (AttributeType)itr2.next();
            gtSchema.put((Object)new Name(this.schema.getTargetNamespace(), gtType.getName()), (Object)gtType);
        }
        Object[] input = new Object[]{gtSchema, Schemas.getTargetPrefix(this.schema), this};
        String result = this.execute("SchemaClassTemplate", input);
        String className = Schemas.getTargetPrefix(this.schema).toUpperCase() + "Schema";
        this.write(result, className);
    }

    private AttributeType createType(XSDTypeDefinition xsdType) {
        if (this.types.containsKey(xsdType)) {
            return (AttributeType)this.types.get(xsdType);
        }
        if (!xsdType.getTargetNamespace().equals(this.schema.getTargetNamespace())) {
            return this.findType(xsdType);
        }
        AttributeType superType = null;
        XSDTypeDefinition baseType = xsdType.getBaseType();
        if (baseType != null && !baseType.equals(xsdType) && baseType.getName() != null) {
            superType = this.createType(baseType);
            if (!$assertionsDisabled && superType == null) {
                throw new AssertionError();
            }
        }
        AttributeType gtType = AttributeTypeFactory.newAttributeType((String)xsdType.getName(), (Class)Object.class);
        this.types.put(xsdType, gtType);
        return gtType;
    }

    private AttributeType findType(XSDTypeDefinition xsdType) {
        org.opengis.feature.type.Name name = this.name(xsdType);
        if (this.imports != null) {
            Iterator itr = this.imports.values().iterator();
            while (itr.hasNext()) {
                Schema imported = (Schema)itr.next();
                if (!imported.containsKey((Object)name)) continue;
                return (AttributeType)imported.get((Object)name);
            }
        }
        throw new IllegalStateException("Could not find imported type: " + name);
    }

    private org.opengis.feature.type.Name name(XSDTypeDefinition type) {
        return new Name(type.getTargetNamespace(), type.getName());
    }

    public static void main(String[] args) throws Exception {
        XSDSchema schema = XSDUtil.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
        SchemaGenerator generator = new SchemaGenerator(schema);
        generator.setComplexTypes(false);
        generator.setFollowComplexTypes(false);
        generator.setSimpleTypes(true);
        generator.generate();
    }

    static {
        $assertionsDisabled = !SchemaGenerator.class.desiredAssertionStatus();
    }
}

