/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.codegen;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDSchema;
import org.geotools.xml.Schemas;
import org.geotools.xml.codegen.AbstractGenerator;

public class SchemaLocationResolverGenerator
extends AbstractGenerator {
    public void generate(XSDSchema schema) throws Exception {
        ArrayList<File> includes = new ArrayList<File>();
        ArrayList<String> namespaces = new ArrayList<String>();
        includes.add(new File(schema.getSchemaLocation()));
        namespaces.add(schema.getTargetNamespace());
        List included = Schemas.getIncludes(schema);
        Iterator i = included.iterator();
        while (i.hasNext()) {
            XSDInclude include = (XSDInclude)i.next();
            includes.add(new File(include.getSchemaLocation()));
            namespaces.add(include.getSchema().getTargetNamespace());
        }
        String result = this.execute("SchemaLocationResolverTemplate", new Object[]{schema, includes, namespaces});
        String prefix = Schemas.getTargetPrefix(schema).toUpperCase();
        this.write(result, prefix + "SchemaLocationResolver");
        Iterator i2 = includes.iterator();
        while (i2.hasNext()) {
            File include = (File)i2.next();
            this.copy(include);
        }
    }

    public static void main(String[] args) throws Exception {
        SchemaLocationResolverGenerator g = new SchemaLocationResolverGenerator();
        XSDSchema schema = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("--schema".equals(arg)) {
                schema = Schemas.parse(args[++i]);
                continue;
            }
            if ("--output".equals(arg)) {
                g.setLocation(args[++i]);
                continue;
            }
            if (!"--package".equals(arg)) continue;
            g.setPackageBase(args[++i]);
        }
        g.generate(schema);
    }
}

