/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.util.ArrayList;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.xml.Binding;
import org.geotools.xml.impl.BindingFactory;
import org.geotools.xml.impl.TypeWalker;
import org.geotools.xs.bindings.XSAnyTypeBinding;
import org.picocontainer.MutablePicoContainer;

public class BindingWalker
implements TypeWalker.Visitor {
    BindingFactory factory;
    MutablePicoContainer context;
    ArrayList bindings;

    public BindingWalker(BindingFactory factory, MutablePicoContainer context) {
        this.factory = factory;
        this.context = context;
    }

    public boolean visit(XSDTypeDefinition type) {
        Binding binding = null;
        if (type.getName() != null) {
            QName qName = new QName(type.getTargetNamespace(), type.getName());
            binding = this.factory.loadBinding(qName, this.context);
        } else if (type instanceof XSDComplexTypeDefinition && type.getBaseType() instanceof XSDSimpleTypeDefinition) {
            binding = new XSAnyTypeBinding();
        }
        if (binding != null) {
            this.bindings.add(binding);
            if (binding.getExecutionMode() == 2) {
                return false;
            }
        } else if (!this.bindings.isEmpty()) {
            return false;
        }
        return true;
    }

    public void walk(XSDFeature component, Visitor visitor) {
        QName qName;
        Binding binding;
        this.bindings = new ArrayList();
        TypeWalker walker = new TypeWalker(component.getType());
        walker.walk(this);
        if (component.getName() != null && (binding = this.factory.loadBinding(qName = new QName(component.getTargetNamespace(), component.getName()), this.context)) != null) {
            this.bindings.add(0, binding);
        }
        Stack<Binding> stack = new Stack<Binding>();
        for (int i = 0; i < this.bindings.size(); ++i) {
            Binding binding2 = (Binding)this.bindings.get(i);
            if (binding2.getExecutionMode() == 0) {
                stack.push(binding2);
                continue;
            }
            visitor.visit(binding2);
        }
        while (!stack.isEmpty()) {
            binding = (Binding)stack.pop();
            visitor.visit(binding);
        }
    }

    public static interface Visitor {
        public void visit(Binding var1);
    }
}

