/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDSchemaContent;
import org.geotools.xml.AttributeInstance;
import org.geotools.xml.Binding;
import org.geotools.xml.InstanceComponent;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.Schemas;
import org.geotools.xml.impl.AttributeImpl;
import org.geotools.xml.impl.BindingWalker;
import org.geotools.xml.impl.ContextInitializer;
import org.geotools.xml.impl.ElementHandler;
import org.geotools.xml.impl.ElementImpl;
import org.geotools.xml.impl.Handler;
import org.geotools.xml.impl.HandlerImpl;
import org.geotools.xml.impl.NodeImpl;
import org.geotools.xml.impl.ParseExecutor;
import org.geotools.xml.impl.ParserHandler;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementHandlerImpl
extends HandlerImpl
implements ElementHandler {
    Handler parent;
    XSDElementDeclaration content;
    ElementImpl element;
    ParserHandler parser;
    Binding strategy;
    ArrayList childHandlers;
    NodeImpl node;
    Object value;

    public ElementHandlerImpl(XSDElementDeclaration content, Handler parent, ParserHandler parser) {
        this.content = content;
        this.parent = parent;
        this.parser = parser;
        this.childHandlers = new ArrayList();
    }

    public void startElement(QName qName, Attributes attributes) throws SAXException {
        int i;
        this.childHandlers.clear();
        ArrayList<AttributeImpl> atts = new ArrayList<AttributeImpl>();
        for (i = 0; i < attributes.getLength(); ++i) {
            QName attQName;
            XSDAttributeDeclaration decl;
            String uri = attributes.getURI(i);
            String name = attributes.getLocalName(i);
            if (uri == null || "".equals(uri)) {
                uri = qName.getNamespaceURI();
            }
            if ((decl = Schemas.getAttributeDeclaration(this.content, attQName = new QName(uri, name))) == null) continue;
            AttributeImpl att = new AttributeImpl(decl);
            att.setNamespace(decl.getTargetNamespace());
            att.setName(decl.getName());
            att.setText(attributes.getValue(i));
            atts.add(att);
        }
        this.element = new ElementImpl(this.content);
        this.element.setNamespace(qName.getNamespaceURI());
        this.element.setName(qName.getLocalPart());
        this.element.setAttributes(atts.toArray(new AttributeInstance[atts.size()]));
        this.node = new NodeImpl(this.element);
        for (i = 0; i < this.element.getAttributes().length; ++i) {
            AttributeInstance attribute = this.element.getAttributes()[i];
            ParseExecutor executor = new ParseExecutor(attribute, null, this.parent.getContext());
            BindingWalker walker = new BindingWalker(this.parser.getBindingFactory(), this.parent.getContext());
            walker.walk((XSDFeature)attribute.getAttributeDeclaration(), executor);
            Object parsed = executor.getValue();
            this.node.addAttribute(new NodeImpl(attribute, parsed));
        }
        this.setContext((MutablePicoContainer)new DefaultPicoContainer((PicoContainer)this.parent.getContext()));
        ContextInitializer initer = new ContextInitializer(this.element, this.node, this.getContext());
        new BindingWalker(this.parser.getBindingFactory(), this.getContext()).walk((XSDFeature)this.element.getElementDeclaration(), initer);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.element.addText(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        for (int i = 0; i < this.childHandlers.size(); ++i) {
            Handler handler = (Handler)this.childHandlers.get(i);
            this.node.addChild(new NodeImpl(handler.getComponent(), handler.getValue()));
        }
        ParseExecutor executor = new ParseExecutor(this.element, this.node, this.getParentHandler().getContext());
        new BindingWalker(this.parser.getBindingFactory(), this.getParentHandler().getContext()).walk((XSDFeature)this.element.getElementDeclaration(), executor);
        this.value = executor.getValue();
        if (this.value == null) {
            String msg = "Parsing failed for " + this.element.getName() + ", no value returned from strategy";
            throw new RuntimeException(msg);
        }
        this.parent.getContext().removeChildContainer((PicoContainer)this.getContext());
    }

    private Handler getChildHandlerInternal(QName qName) {
        QName subQName;
        Handler handler;
        XSDElementDeclaration sub;
        SchemaIndex index = this.parser.getSchemaIndex();
        XSDElementDeclaration element = Schemas.getChildElementDeclaration(this.content, qName);
        if (element != null) {
            ElementHandler handler2 = this.parser.getHandlerFactory().createElementHandler(element, (Handler)this);
            return handler2;
        }
        element = index.getElementDeclaration(qName);
        if (element != null && (sub = element.getSubstitutionGroupAffiliation()) != null && (handler = this.getChildHandlerInternal(subQName = new QName(sub.getTargetNamespace(), sub.getName()))) != null) {
            handler = this.parser.getHandlerFactory().createElementHandler(element, (Handler)this);
            return handler;
        }
        return null;
    }

    public Handler getChildHandler(QName qName) {
        Handler handler = this.getChildHandlerInternal(qName);
        if (handler != null) {
            this.childHandlers.add(handler);
        }
        return handler;
    }

    public List getChildHandlers() {
        return this.childHandlers;
    }

    public void removeChildHandler(Handler child) {
        this.childHandlers.remove(child);
    }

    public Handler getParentHandler() {
        return this.parent;
    }

    public XSDSchemaContent getSchemaContent() {
        return this.content;
    }

    public XSDElementDeclaration getElementDeclaration() {
        return this.content;
    }

    public InstanceComponent getComponent() {
        return this.element;
    }

    public void setComponent(ElementImpl element) {
        this.element = element;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.node != null ? this.node.toString() : "";
    }
}

