/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.xml.Binding;
import org.geotools.xml.ComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.InstanceComponent;
import org.geotools.xml.Node;
import org.geotools.xml.SimpleBinding;
import org.geotools.xml.impl.BindingWalker;
import org.geotools.xs.facets.Whitespace;
import org.picocontainer.MutablePicoContainer;

public class ParseExecutor
implements BindingWalker.Visitor {
    private InstanceComponent instance;
    private Node node;
    private Object value;
    private MutablePicoContainer context;

    public ParseExecutor(InstanceComponent instance, Node node, MutablePicoContainer context) {
        this.instance = instance;
        this.node = node;
        this.context = context;
        this.value = this.parseFacets(instance);
    }

    public void visit(Binding binding) {
        binding = (Binding)this.context.getComponentInstanceOfType(binding.getClass());
        try {
            Object result = this.value;
            result = binding instanceof SimpleBinding ? ((SimpleBinding)binding).parse(this.instance, result) : ((ComplexBinding)binding).parse((ElementInstance)this.instance, this.node, result);
            if (result != null) {
                this.value = result;
            }
        }
        catch (Throwable t) {
            String msg = "Parsing failed for " + this.instance.getName() + ": " + t.toString();
            throw new RuntimeException(msg, t);
        }
    }

    public Object getValue() {
        return this.value;
    }

    protected Object parseFacets(InstanceComponent instance) {
        String value = instance.getText();
        for (XSDTypeDefinition type = instance.getTypeDefinition(); type != null; type = type.getBaseType()) {
            if (type instanceof XSDSimpleTypeDefinition) {
                XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)type;
                EList facets = simpleType.getFacets();
                Iterator itr = facets.iterator();
                while (itr.hasNext()) {
                    Whitespace whitespace;
                    XSDFacet facet = (XSDFacet)itr.next();
                    if (!"whiteSpace".equals(facet.getFacetName()) || (whitespace = Whitespace.valueOf(facet.getLexicalValue())) == null) continue;
                    value = whitespace.preparse(value);
                }
            }
            if (type.equals(type.getBaseType())) break;
        }
        return value;
    }
}

