/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geotools.xml.Configuration;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.Schemas;
import org.geotools.xml.impl.BindingFactory;
import org.geotools.xml.impl.BindingFactoryImpl;
import org.geotools.xml.impl.DocumentHandler;
import org.geotools.xml.impl.ElementHandler;
import org.geotools.xml.impl.Handler;
import org.geotools.xml.impl.HandlerFactory;
import org.geotools.xml.impl.HandlerFactoryImpl;
import org.geotools.xml.impl.SchemaIndexImpl;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class ParserHandler
extends DefaultHandler {
    Stack handlers;
    NamespaceSupport namespaces;
    XSDSchema[] schemas;
    SchemaIndex index;
    HandlerFactory handlerFactory;
    BindingFactory strategyFactory;
    DocumentHandler documentHandler;
    Configuration config;
    MutablePicoContainer context;
    Logger logger;

    public ParserHandler(Configuration config) {
        this.config = config;
    }

    public HandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    public BindingFactory getBindingFactory() {
        return this.strategyFactory;
    }

    public XSDSchema[] getSchemas() {
        return this.schemas;
    }

    public SchemaIndex getSchemaIndex() {
        return this.index;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.declarePrefix(prefix, uri);
    }

    public void startDocument() throws SAXException {
        this.configure(this.config);
        DocumentHandler docHandler = this.handlerFactory.createDocumentHandler();
        this.context = new DefaultPicoContainer();
        this.config.configureContext(this.context);
        docHandler.setContext(this.context);
        this.handlers = new Stack();
        this.handlers.push(docHandler);
        this.logger = (Logger)this.context.getComponentInstanceOfType(Logger.class);
        if (this.logger == null) {
            this.logger = Logger.getLogger("org.geotools.xml");
            this.context.registerComponentInstance((Object)this.logger);
        }
        this.namespaces = new NamespaceSupport();
        this.context.registerComponentInstance((Object)this.namespaces);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.schemas == null) {
            int i;
            String[] locations = null;
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                String name = attributes.getQName(i2);
                if (!name.endsWith("schemaLocation")) continue;
                locations = attributes.getValue(i2).split(" +");
                break;
            }
            XSDSchemaLocator[] locators = this.findSchemaLocators();
            XSDSchemaLocationResolver[] resolvers = this.findSchemaLocationResolvers();
            if (locations != null && locations.length > 0) {
                this.schemas = new XSDSchema[locations.length / 2];
                for (i = 0; i < locations.length; i += 2) {
                    int j;
                    String namespace = locations[i];
                    String location = locations[i + 1];
                    for (j = 0; j < resolvers.length; ++j) {
                        String override = resolvers[j].resolveSchemaLocation(null, namespace, location);
                        if (override == null) continue;
                        location = override;
                        break;
                    }
                    for (j = 0; j < locators.length; ++j) {
                        XSDSchema schema = locators[j].locateSchema(null, namespace, location, null);
                        if (schema == null) continue;
                        this.schemas[i / 2] = schema;
                        break;
                    }
                    if (this.schemas[i / 2] != null) continue;
                    try {
                        this.schemas[i / 2] = Schemas.parse(location, locators, resolvers);
                        continue;
                    }
                    catch (Exception e) {
                        String msg = "Error parsing: " + location;
                        this.logger.warning(msg);
                        throw new SAXException(msg, e);
                    }
                }
            } else {
                for (i = 0; i < locators.length; ++i) {
                    XSDSchema schema = locators[i].locateSchema(null, uri, null, null);
                    if (schema == null) continue;
                    this.schemas = new XSDSchema[]{schema};
                    break;
                }
            }
            if (this.schemas == null) {
                String msg = "Could not find a schemaLocation attribute or appropriate locator";
                throw new SAXException(msg);
            }
            this.index = new SchemaIndexImpl(this.schemas);
        }
        this.namespaces.pushContext();
        QName qualifiedName = new QName(uri, localName);
        Handler parent = (Handler)this.handlers.peek();
        ElementHandler handler = (ElementHandler)parent.getChildHandler(qualifiedName);
        if (handler == null) {
            String msg = "Handler for " + qName + " could not be found.";
            throw new SAXException(msg);
        }
        handler.startElement(qualifiedName, attributes);
        this.handlers.push(handler);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        ElementHandler handler = (ElementHandler)this.handlers.peek();
        handler.characters(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        ElementHandler handler = (ElementHandler)this.handlers.pop();
        handler.endElement(uri, localName, qName);
        this.endElementInternal(handler);
        this.namespaces.popContext();
    }

    protected void endElementInternal(ElementHandler handler) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDocument() throws SAXException {
        this.documentHandler = (DocumentHandler)this.handlers.pop();
        ParserHandler parserHandler = this;
        synchronized (parserHandler) {
            this.notifyAll();
        }
    }

    public Object getValue() {
        return this.documentHandler.getValue();
    }

    protected void configure(Configuration config) {
        this.handlerFactory = new HandlerFactoryImpl(this);
        this.strategyFactory = new BindingFactoryImpl();
        config.configureBindings(this.strategyFactory.getContainer());
    }

    protected XSDSchemaLocator[] findSchemaLocators() {
        List l = this.context.getComponentInstancesOfType(XSDSchemaLocator.class);
        if (l == null || l.isEmpty()) {
            return new XSDSchemaLocator[0];
        }
        return l.toArray(new XSDSchemaLocator[l.size()]);
    }

    protected XSDSchemaLocationResolver[] findSchemaLocationResolvers() {
        List l = this.context.getComponentInstancesOfType(XSDSchemaLocationResolver.class);
        if (l == null || l.isEmpty()) {
            return new XSDSchemaLocationResolver[0];
        }
        return l.toArray(new XSDSchemaLocationResolver[l.size()]);
    }
}

