/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.xml.SchemaIndex;

public class SchemaIndexImpl
implements SchemaIndex {
    XSDSchema[] schemas;
    HashMap elementIndex;
    HashMap attributeIndex;
    HashMap attributeGroupIndex;
    HashMap complexTypeIndex;
    HashMap simpleTypeIndex;

    public SchemaIndexImpl(XSDSchema[] schemas) {
        this.schemas = schemas;
    }

    public XSDSchema[] getSchemas() {
        return this.schemas;
    }

    public XSDImport[] getImports() {
        Collection imports = this.find(XSDImport.class);
        return imports.toArray(new XSDImport[imports.size()]);
    }

    public XSDInclude[] getIncludes() {
        Collection includes = this.find(XSDInclude.class);
        return includes.toArray(new XSDInclude[includes.size()]);
    }

    public XSDElementDeclaration getElementDeclaration(QName qName) {
        return (XSDElementDeclaration)this.getElementIndex().get(qName);
    }

    public XSDAttributeDeclaration getAttributeDeclaration(QName qName) {
        return (XSDAttributeDeclaration)this.getAttributeIndex().get(qName);
    }

    public XSDAttributeGroupDefinition getAttributeGroupDefinition(QName qName) {
        return (XSDAttributeGroupDefinition)this.getAttributeGroupIndex().get(qName);
    }

    public XSDComplexTypeDefinition getComplexTypeDefinition(QName qName) {
        return (XSDComplexTypeDefinition)this.getComplexTypeIndex().get(qName);
    }

    public XSDSimpleTypeDefinition getSimpleTypeDefinition(QName qName) {
        return (XSDSimpleTypeDefinition)this.getSimpleTypeIndex().get(qName);
    }

    public XSDTypeDefinition getTypeDefinition(QName qName) {
        XSDComplexTypeDefinition type = this.getComplexTypeDefinition(qName);
        if (type == null) {
            type = this.getSimpleTypeDefinition(qName);
        }
        return type;
    }

    protected Collection find(Class c) {
        ArrayList found = new ArrayList();
        for (int i = 0; i < this.schemas.length; ++i) {
            XSDSchema schema = this.schemas[i];
            EList content = schema.getContents();
            Iterator itr = content.iterator();
            while (itr.hasNext()) {
                Object o = itr.next();
                if (!c.isAssignableFrom(o.getClass())) continue;
                found.add(o);
            }
        }
        return found;
    }

    protected HashMap getElementIndex() {
        if (this.elementIndex == null) {
            this.buildElementIndex();
        }
        return this.elementIndex;
    }

    protected HashMap getAttributeIndex() {
        if (this.attributeIndex == null) {
            this.buildAttriubuteIndex();
        }
        return this.attributeIndex;
    }

    protected HashMap getAttributeGroupIndex() {
        if (this.attributeGroupIndex == null) {
            this.buildAttributeGroupIndex();
        }
        return this.attributeGroupIndex;
    }

    protected HashMap getComplexTypeIndex() {
        if (this.complexTypeIndex == null) {
            this.buildTypeIndex();
        }
        return this.complexTypeIndex;
    }

    protected HashMap getSimpleTypeIndex() {
        if (this.simpleTypeIndex == null) {
            this.buildTypeIndex();
        }
        return this.simpleTypeIndex;
    }

    protected void buildElementIndex() {
        this.elementIndex = new HashMap();
        for (int i = 0; i < this.schemas.length; ++i) {
            XSDSchema schema = this.schemas[i];
            Iterator e = schema.getElementDeclarations().iterator();
            while (e.hasNext()) {
                XSDElementDeclaration element = (XSDElementDeclaration)e.next();
                QName qName = new QName(element.getTargetNamespace(), element.getName());
                this.elementIndex.put(qName, element);
            }
        }
    }

    protected void buildAttriubuteIndex() {
        this.attributeIndex = new HashMap();
        for (int i = 0; i < this.schemas.length; ++i) {
            XSDSchema schema = this.schemas[i];
            Iterator a = schema.getAttributeDeclarations().iterator();
            while (a.hasNext()) {
                XSDAttributeDeclaration attribute = (XSDAttributeDeclaration)a.next();
                QName qName = new QName(attribute.getTargetNamespace(), attribute.getName());
                this.attributeIndex.put(qName, attribute);
            }
        }
    }

    protected void buildAttributeGroupIndex() {
        this.attributeGroupIndex = new HashMap();
        for (int i = 0; i < this.schemas.length; ++i) {
            XSDSchema schema = this.schemas[i];
            Iterator g = schema.getAttributeGroupDefinitions().iterator();
            while (g.hasNext()) {
                XSDAttributeGroupDefinition group = (XSDAttributeGroupDefinition)g.next();
                QName qName = new QName(group.getTargetNamespace(), group.getName());
                this.attributeGroupIndex.put(qName, group);
            }
        }
    }

    protected void buildTypeIndex() {
        this.complexTypeIndex = new HashMap();
        this.simpleTypeIndex = new HashMap();
        for (int i = 0; i < this.schemas.length; ++i) {
            XSDSchema schema = this.schemas[i];
            Iterator t = schema.getTypeDefinitions().iterator();
            while (t.hasNext()) {
                XSDTypeDefinition type = (XSDTypeDefinition)t.next();
                HashMap index = null;
                index = type instanceof XSDComplexTypeDefinition ? this.complexTypeIndex : this.simpleTypeIndex;
                QName qName = new QName(type.getTargetNamespace(), type.getName());
                index.put(qName, type);
            }
        }
    }
}

