/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.util.Iterator;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathContextFactory;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.geotools.xml.Configuration;
import org.geotools.xml.impl.Buffer;
import org.geotools.xml.impl.DocumentHandler;
import org.geotools.xml.impl.ElementHandler;
import org.geotools.xml.impl.ElementHandlerImpl;
import org.geotools.xml.impl.ParserHandler;
import org.geotools.xml.impl.jxpath.ElementHandlerPropertyHandler;
import org.xml.sax.SAXException;

public class StreamingParserHandler
extends ParserHandler {
    String xpath;
    Buffer buffer;

    public StreamingParserHandler(Configuration config, String xpath) {
        super(config);
        this.xpath = xpath;
        this.buffer = new Buffer();
    }

    protected void endElementInternal(ElementHandler handler) {
        super.endElementInternal(handler);
        JXPathIntrospector.registerDynamicClass((Class)ElementHandlerImpl.class, (Class)ElementHandlerPropertyHandler.class);
        JXPathContext jxpContext = JXPathContextFactory.newInstance().newContext(null, (Object)((DocumentHandler)this.handlers.firstElement()).getDocumentElementHandler());
        jxpContext.setLenient(true);
        Iterator itr = jxpContext.iterate(this.xpath);
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (!handler.equals(obj)) continue;
            this.buffer.put(handler.getValue());
            if (!(handler.getParentHandler() instanceof ElementHandler)) break;
            ElementHandler parent = (ElementHandler)handler.getParentHandler();
            parent.removeChildHandler(handler);
            break;
        }
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.buffer.close();
    }

    public Buffer getBuffer() {
        return this.buffer;
    }
}

