/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.test;

import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.geotools.xml.Configuration;
import org.geotools.xml.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class XMLTestSupport
extends TestCase {
    protected Document document;

    protected void setUp() throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        this.document = docFactory.newDocumentBuilder().newDocument();
        Element root = this.createRootElement(this.document);
        this.document.appendChild(root);
        this.registerNamespaces(root);
        this.registerSchemaLocation(root);
    }

    protected abstract Element createRootElement(Document var1);

    protected void registerNamespaces(Element root) {
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    protected abstract void registerSchemaLocation(Element var1);

    protected abstract Configuration createConfiguration();

    protected Object parse() throws Exception {
        Configuration config = this.createConfiguration();
        DOMParser parser = new DOMParser(config, this.document);
        return parser.parse();
    }
}

