/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgresql.util.PGtokenizer;

public class MultiLineString
extends Geometry {
    LineString[] lines;

    public MultiLineString() {
        this.type = Geometry.MULTILINESTRING;
    }

    public MultiLineString(LineString[] lines) {
        this();
        this.lines = lines;
        this.dimension = lines[0].dimension;
    }

    public MultiLineString(String value) throws SQLException {
        this();
        value = value.trim();
        if (value.indexOf("MULTILINESTRING") == 0) {
            PGtokenizer t = new PGtokenizer(PGtokenizer.removePara((String)value.substring(15).trim()), ',');
            int nlines = t.getSize();
            this.lines = new LineString[nlines];
            int p = 0;
            while (p < nlines) {
                this.lines[p] = new LineString(t.getToken(p));
                ++p;
            }
        } else {
            throw new SQLException("postgis.multilinestringgeometry");
        }
        this.dimension = this.lines[0].dimension;
    }

    public String toString() {
        return "MULTILINESTRING " + this.getValue();
    }

    public String getValue() {
        StringBuffer b = new StringBuffer("(");
        int p = 0;
        while (p < this.lines.length) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.lines[p].getValue());
            ++p;
        }
        b.append(")");
        return b.toString();
    }

    public int numLines() {
        return this.lines.length;
    }

    public LineString getLine(int idx) {
        if (idx >= 0 & idx < this.lines.length) {
            return this.lines[idx];
        }
        return null;
    }
}

