/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import com.ibm.db2.jcc.DB2ConnectionPoolDataSource;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.ConnectionPoolManager;

public class DB2ConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.db2");
    private static final String DB2_URL_PREFIX = "jdbc:db2://";
    private static Map DATA_SOURCES = new HashMap();
    private String dbURL = null;
    private String dbname = null;
    private String user = null;
    private String pw = null;
    private String host = null;
    private String portnum = null;

    public DB2ConnectionFactory(String host, String portnum, String dbname) {
        this.dbURL = DB2_URL_PREFIX + host + ":" + portnum + "/" + dbname;
        this.dbname = dbname;
        this.portnum = portnum;
        this.host = host;
    }

    public void setLogin(String user, String pw) {
        this.user = user;
        this.pw = pw;
    }

    public String getDbURL() {
        return this.dbURL;
    }

    public ConnectionPool getConnectionPool() throws SQLException {
        String key = this.dbURL + this.user + this.pw;
        DB2ConnectionPoolDataSource poolDataSource = (DB2ConnectionPoolDataSource)DATA_SOURCES.get(key);
        if (poolDataSource == null) {
            poolDataSource = new DB2ConnectionPoolDataSource();
            int portValue = Integer.valueOf(this.portnum);
            int driverType = 4;
            poolDataSource = new DB2ConnectionPoolDataSource();
            if (portValue == 0) {
                driverType = 2;
            }
            poolDataSource.setDriverType(driverType);
            poolDataSource.setPortNumber(portValue);
            poolDataSource.setServerName(this.host);
            poolDataSource.setDatabaseName(this.dbname);
            poolDataSource.setUser(this.user);
            poolDataSource.setPassword(this.pw);
            DATA_SOURCES.put(key, poolDataSource);
            LOGGER.info("Created new DB2ConnectionPoolDataSource for dbUrl " + this.dbURL);
        }
        ConnectionPoolManager manager = ConnectionPoolManager.getInstance();
        ConnectionPool connectionPool = manager.getConnectionPool((ConnectionPoolDataSource)poolDataSource);
        LOGGER.info("Successfully obtained DB2 ConnectionPool");
        return connectionPool;
    }
}

