/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.Transaction;
import org.geotools.data.db2.DB2FIDMapperFactory;
import org.geotools.data.db2.DB2FeatureLocking;
import org.geotools.data.db2.DB2FeatureSource;
import org.geotools.data.db2.DB2FeatureStore;
import org.geotools.data.db2.DB2FeatureTypeHandler;
import org.geotools.data.db2.DB2FeatureWriter;
import org.geotools.data.db2.DB2SQLBuilder;
import org.geotools.data.db2.DB2SpatialCatalog;
import org.geotools.data.db2.filter.SQLEncoderDB2;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.FeatureTypeHandler;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.JDBCFeatureWriter;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.data.jdbc.attributeio.WKTAttributeIO;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapperFactory;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DB2DataStore
extends JDBCDataStore {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.db2");
    private static final Map DB2_GEOM_TYPE_MAPPING = new HashMap();
    private DB2SpatialCatalog catalog;
    private String dbURL = null;
    private long lastTypeNameRequestTime = 0L;

    public DB2DataStore(ConnectionPool connectionPool, JDBCDataStoreConfig config, String dbURL) throws IOException {
        super(connectionPool, config);
        if (connectionPool == null) {
            throw new IOException("Connection pool is null");
        }
        this.dbURL = dbURL;
        Connection conn = this.getConnection(Transaction.AUTO_COMMIT);
        try {
            this.catalog = DB2SpatialCatalog.getInstance(dbURL, config.getDatabaseSchemaName(), conn);
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        }
        catch (SQLException e) {
            LOGGER.info("DB2SpatialCatalog create failed: " + e);
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, (SQLException)e);
            throw new IOException("DB2SpatialCatalog create failed");
        }
    }

    protected AttributeType buildAttributeType(ResultSet rs) throws IOException {
        try {
            String spatialTypePrefix = "\"DB2GSE\".\"ST_";
            int dataType = rs.getInt("DATA_TYPE");
            String typeName = rs.getString("TYPE_NAME");
            String tableSchema = rs.getString("TABLE_SCHEM");
            String tableName = rs.getString("TABLE_NAME");
            String columnName = rs.getString("COLUMN_NAME");
            if (!typeName.startsWith(spatialTypePrefix)) {
                return super.buildAttributeType(rs);
            }
            String geomTypeName = this.catalog.getDB2GeometryTypeName(tableSchema, tableName, columnName);
            Class geomClass = (Class)DB2_GEOM_TYPE_MAPPING.get(geomTypeName);
            if (geomClass != null) {
                CoordinateReferenceSystem crs;
                try {
                    crs = this.catalog.getCRS(tableSchema, tableName, columnName);
                }
                catch (Exception e) {
                    throw new IOException("Exception: " + e.getMessage());
                }
                GeometryAttributeType geometryAttribute = (GeometryAttributeType)AttributeTypeFactory.newAttributeType((String)columnName, (Class)geomClass, (boolean)true, (int)0, null, (Object)crs);
                return geometryAttribute;
            }
            LOGGER.fine("Type '" + geomTypeName + "' is not recognized");
            return null;
        }
        catch (SQLException e) {
            throw new IOException("SQL exception occurred: " + e.getMessage());
        }
    }

    protected FIDMapperFactory buildFIDMapperFactory(JDBCDataStoreConfig config) {
        return new DB2FIDMapperFactory(config.getDatabaseSchemaName());
    }

    protected int determineSRID(String tableName, String geometryColumnName) throws IOException {
        int srid = -1;
        String tableSchema = this.config.getDatabaseSchemaName();
        srid = this.catalog.getCsId(tableSchema, tableName, geometryColumnName);
        LOGGER.fine(DB2SpatialCatalog.geomID(tableSchema, tableName, geometryColumnName) + " srid=" + srid);
        return srid;
    }

    String getDbURL() {
        return this.dbURL;
    }

    protected FeatureTypeHandler getFeatureTypeHandler(JDBCDataStoreConfig config) throws IOException {
        return new DB2FeatureTypeHandler(this, this.buildFIDMapperFactory(config), config.getTypeHandlerTimeout());
    }

    protected AttributeIO getGeometryAttributeIO(AttributeType type, QueryData queryData) {
        return new WKTAttributeIO();
    }

    DB2SpatialCatalog getSpatialCatalog() {
        return this.catalog;
    }

    public SQLBuilder getSqlBuilder(String typeName) throws IOException {
        FeatureTypeInfo info = this.typeHandler.getFeatureTypeInfo(typeName);
        int srid = 0;
        SQLEncoderDB2 encoder = new SQLEncoderDB2();
        encoder.setSqlNameEscape("\"");
        FIDMapper mapper = this.getFIDMapper(typeName);
        encoder.setFIDMapper(mapper);
        if (info.getSchema().getDefaultGeometry() != null) {
            String geom = info.getSchema().getDefaultGeometry().getName();
            srid = this.catalog.getSRID(this.getTableSchema(), typeName, geom);
        }
        encoder.setSRID(srid);
        return new DB2SQLBuilder(encoder, this.getTableSchema(), info.getSchema());
    }

    public String[] getTypeNames() throws IOException {
        long now;
        long lastTime = this.lastTypeNameRequestTime;
        this.lastTypeNameRequestTime = now = System.currentTimeMillis();
        if (lastTime < now - this.config.getTypeHandlerTimeout()) {
            this.refreshCatalog();
        }
        return this.getSpatialCatalog().getTypeNames();
    }

    public void refreshCatalog() throws IOException {
        try {
            Connection conn = this.getConnection(Transaction.AUTO_COMMIT);
            this.getSpatialCatalog().loadCatalog(conn, this.getTableSchema());
            this.lastTypeNameRequestTime = System.currentTimeMillis();
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
            LOGGER.fine("Refreshing spatial catalog");
        }
        catch (SQLException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public String getTableSchema() {
        return this.config.getDatabaseSchemaName();
    }

    public FeatureSource getFeatureSource(String typeName) throws IOException {
        if (!this.typeHandler.getFIDMapper(typeName).isVolatile() || this.allowWriteOnVolatileFIDs) {
            if (this.getLockingManager() != null) {
                return new DB2FeatureLocking(this, this.getSchema(typeName));
            }
            return new DB2FeatureStore(this, this.getSchema(typeName));
        }
        return new DB2FeatureSource(this, this.getSchema(typeName));
    }

    protected QueryData executeQuery(FeatureTypeInfo featureTypeInfo, String tableName, String sqlQuery, Transaction transaction, boolean forWrite) throws IOException {
        LOGGER.fine("About to execute query: " + sqlQuery);
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(transaction);
            statement = conn.createStatement(this.getResultSetType(forWrite), this.getConcurrency(forWrite));
            statement.setFetchSize(200);
            int rsc1 = statement.getResultSetConcurrency();
            rs = statement.executeQuery(sqlQuery);
            int rsc2 = statement.getResultSetConcurrency();
            int c = rs.getConcurrency();
            int update = 1008;
            int read = 1007;
            return new QueryData(featureTypeInfo, (JDBC1DataStore)this, conn, statement, rs, transaction);
        }
        catch (SQLException e) {
            String msg = "Error Performing SQL query: " + sqlQuery;
            LOGGER.log(Level.SEVERE, msg, e);
            JDBCUtils.close(rs);
            JDBCUtils.close((Statement)statement);
            JDBCUtils.close((Connection)conn, (Transaction)transaction, (SQLException)e);
            throw new DataSourceException(msg, (Throwable)e);
        }
    }

    protected JDBCFeatureWriter createFeatureWriter(FeatureReader featureReader, QueryData queryData) throws IOException {
        String featureName = queryData.getFeatureType().getTypeName();
        return new DB2FeatureWriter(featureReader, queryData, (DB2SQLBuilder)this.getSqlBuilder(featureName));
    }

    /*
     * WARNING - void declaration
     */
    public FeatureReader getFeatureReader(FeatureType requestType, Filter filter, Transaction transaction) throws IOException {
        void var7_7;
        DefaultQuery query;
        String typeName = requestType.getTypeName();
        FeatureType schemaType = this.getSchema(typeName);
        LOGGER.fine("requestType: " + requestType);
        LOGGER.fine("schemaType: " + schemaType);
        int compare = DataUtilities.compare((FeatureType)requestType, (FeatureType)schemaType);
        if (compare == 0) {
            query = new DefaultQuery(typeName, filter);
        } else if (compare == 1) {
            String[] names = this.attributeNames(requestType, filter);
            query = new DefaultQuery(typeName, filter, Integer.MAX_VALUE, names, "getFeatureReader");
        } else {
            throw new IOException("Type " + typeName + " does match request");
        }
        if (filter == Filter.ALL || filter.equals(Filter.ALL)) {
            return new EmptyFeatureReader(requestType);
        }
        FeatureReader reader = this.getFeatureReader((Query)var7_7, transaction);
        if (compare == 1) {
            reader = new ReTypeFeatureReader(reader, requestType);
        }
        return reader;
    }

    static {
        DB2_GEOM_TYPE_MAPPING.put("ST_POINT", Point.class);
        DB2_GEOM_TYPE_MAPPING.put("ST_LINESTRING", LineString.class);
        DB2_GEOM_TYPE_MAPPING.put("ST_POLYGON", Polygon.class);
        DB2_GEOM_TYPE_MAPPING.put("ST_MULTIPOINT", MultiPoint.class);
        DB2_GEOM_TYPE_MAPPING.put("ST_MULTILINESTRING", MultiLineString.class);
        DB2_GEOM_TYPE_MAPPING.put("ST_MULTIPOLYGON", MultiPolygon.class);
    }
}

