/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.db2.DB2ConnectionFactory;
import org.geotools.data.db2.DB2DataStore;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.JDBCDataStoreConfig;

public class DB2DataStoreFactory
extends AbstractDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.db2");
    private static final String DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";
    private static boolean isAvailable = false;
    private static final DataStoreFactorySpi.Param DBTYPE = new DataStoreFactorySpi.Param("dbtype", String.class, "must be 'DB2'", true, (Object)"DB2");
    private static final DataStoreFactorySpi.Param HOST = new DataStoreFactorySpi.Param("host", String.class, "DB2 host machine", true, (Object)"localhost");
    private static final DataStoreFactorySpi.Param PORT = new DataStoreFactorySpi.Param("port", String.class, "DB2 connection port", true, (Object)"50000");
    private static final DataStoreFactorySpi.Param DATABASE = new DataStoreFactorySpi.Param("database", String.class, "database name", true);
    private static final DataStoreFactorySpi.Param USER = new DataStoreFactorySpi.Param("user", String.class, "user name to login as", false);
    private static final DataStoreFactorySpi.Param PASSWD = new DataStoreFactorySpi.Param("passwd", String.class, "password used to login", false);
    private static final DataStoreFactorySpi.Param TABSCHEMA = new DataStoreFactorySpi.Param("tabschema", String.class, "default table schema", false);
    static final DataStoreFactorySpi.Param[] DB2PARMS = new DataStoreFactorySpi.Param[]{DBTYPE, HOST, PORT, DATABASE, USER, PASSWD, TABSCHEMA};
    private boolean canProcess = false;
    private Map lastParams = null;

    public DataStore createDataStore(Map params) throws IOException {
        DB2DataStore ds;
        ConnectionPool pool;
        if (!this.canProcess(params)) {
            throw new IOException("Invalid parameters");
        }
        String host = (String)HOST.lookUp(params);
        String user = (String)USER.lookUp(params);
        String passwd = (String)PASSWD.lookUp(params);
        String port = (String)PORT.lookUp(params);
        String database = (String)DATABASE.lookUp(params);
        String tabschema = (String)TABSCHEMA.lookUp(params);
        DB2ConnectionFactory connFact = new DB2ConnectionFactory(host, port, database);
        connFact.setLogin(user, passwd);
        try {
            pool = connFact.getConnectionPool();
        }
        catch (SQLException e) {
            LOGGER.info("Get connection pool failed: " + e);
            throw new DataSourceException("Could not create connection pool", (Throwable)e);
        }
        if (tabschema == null || tabschema.length() == 0) {
            tabschema = user;
        }
        tabschema = tabschema.startsWith("\"") ? tabschema.substring(1, tabschema.length() - 1) : tabschema.toUpperCase();
        JDBCDataStoreConfig config = new JDBCDataStoreConfig(tabschema, tabschema, 10000L);
        try {
            ds = new DB2DataStore(pool, config, connFact.getDbURL());
        }
        catch (IOException e) {
            LOGGER.info("Create DB2Datastore failed: " + e);
            throw new DataSourceException("Could not create DB2DataStore", (Throwable)e);
        }
        LOGGER.info("Successfully created DB2Datastore for: " + connFact.getDbURL());
        return ds;
    }

    public DataStore createNewDataStore(Map params) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Creating a new DB2 database is not supported");
    }

    public String getDescription() {
        return "DB2 Data Store";
    }

    public String getDisplayName() {
        return "DB2";
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return DB2PARMS;
    }

    public boolean canProcess(Map params) {
        String logInfo = "";
        if (params == null) {
            return false;
        }
        String dbtype = (String)params.get("dbtype");
        if (dbtype == null) {
            return false;
        }
        if (!dbtype.equalsIgnoreCase("DB2")) {
            return false;
        }
        if (this.canProcess && this.lastParams == params) {
            return true;
        }
        if (!super.canProcess(params)) {
            return false;
        }
        this.lastParams = params;
        this.canProcess = true;
        return true;
    }

    public boolean isAvailable() {
        if (isAvailable) {
            return isAvailable;
        }
        try {
            Class.forName(DRIVER_CLASS);
            isAvailable = true;
        }
        catch (ClassNotFoundException e) {
            isAvailable = false;
        }
        LOGGER.info("DB2 driver found: " + isAvailable);
        return isAvailable;
    }
}

