/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import org.geotools.data.db2.DB2AutoIncrementFIDMapper;
import org.geotools.data.db2.DB2NullFIDMapper;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.fidmapper.BasicFIDMapper;
import org.geotools.data.jdbc.fidmapper.DefaultFIDMapperFactory;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.MaxIncFIDMapper;
import org.geotools.data.jdbc.fidmapper.TypedFIDMapper;

public class DB2FIDMapperFactory
extends DefaultFIDMapperFactory {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.db2");
    private String databaseSchemaName = null;

    public DB2FIDMapperFactory(String databaseSchemaName) {
        super(true);
        this.databaseSchemaName = databaseSchemaName;
    }

    public DB2FIDMapperFactory(boolean returnFIDColumnsAsAttributes) {
        super(returnFIDColumnsAsAttributes);
    }

    public FIDMapper getMapper(String catalog, String schema, String tableName, Connection connection) throws IOException {
        FIDMapper fm = super.getMapper(catalog, schema, tableName, connection);
        LOGGER.fine(this.toString(fm));
        return fm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAutoIncrement(String catalog, String schema, String tableName, Connection conn, ResultSet tableInfo, String columnName, int dataType) throws SQLException {
        if (!this.isIntegralType(dataType)) {
            return false;
        }
        boolean autoIncrement = false;
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.createStatement();
            String stmtString = "SELECT IDENTITY, GENERATED FROM SYSCAT.COLUMNS WHERE TABSCHEMA = '" + tableInfo.getString("TABLE_SCHEM") + "' " + "AND TABNAME = '" + tableName + "' " + "AND COLNAME = '" + columnName + "'";
            rs = statement.executeQuery(stmtString);
            if (rs.next() && rs.getString(1).equals("Y") && rs.getString(2).equals("A")) {
                autoIncrement = true;
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close((Statement)statement);
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((Statement)statement);
        JDBCUtils.close((ResultSet)rs);
        return autoIncrement;
    }

    protected FIDMapper buildNoPKMapper(String schema, String tableName, Connection connection) {
        DB2NullFIDMapper mapper = new DB2NullFIDMapper(schema, tableName);
        return mapper;
    }

    protected FIDMapper buildSingleColumnFidMapper(String schema, String tableName, Connection connection, DefaultFIDMapperFactory.ColumnInfo ci) {
        if (ci.isAutoIncrement()) {
            return new DB2AutoIncrementFIDMapper(this.databaseSchemaName, tableName, ci.getColName(), ci.getDataType());
        }
        if (this.isIntegralType(ci.getDataType())) {
            return new MaxIncFIDMapper(this.databaseSchemaName, tableName, ci.getColName(), ci.getDataType(), true);
        }
        return new BasicFIDMapper(this.databaseSchemaName, tableName, ci.getColName(), ci.getSize(), true);
    }

    String toString(FIDMapper fm) {
        String mapperName = ((TypedFIDMapper)fm).getWrappedMapper().getClass().toString();
        String colInfo = "";
        if (fm.getColumnCount() > 0) {
            colInfo = fm.getColumnName(0) + ":" + fm.getColumnType(0) + ":" + fm.getColumnSize(0) + ":" + fm.getColumnDecimalDigits(0);
        }
        String s = mapperName + ":" + fm.getColumnCount() + ":" + colInfo + ":" + fm.returnFIDColumnsAsAttributes() + ":" + fm.hasAutoIncrementColumns() + ":" + "";
        return s;
    }
}

