/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.db2.DB2DataStore;
import org.geotools.data.db2.DB2SQLBuilder;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCFeatureSource;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.SQLEncoderException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DB2FeatureSource
extends JDBCFeatureSource {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.db2");

    public DB2FeatureSource(DB2DataStore dataStore, FeatureType featureType) {
        super((JDBC1DataStore)dataStore, featureType);
    }

    protected void closeAll(ResultSet rs, Statement stmt, Connection conn, Transaction transaction, SQLException e) {
        this.close(rs);
        this.close(stmt);
        this.close(conn, transaction, e);
    }

    public Envelope getBounds(Query query) throws IOException {
        Envelope env = new Envelope();
        CoordinateReferenceSystem crs = null;
        LOGGER.fine("Query: " + query.toString());
        if (this.getSchema() != null) {
            String typeName = this.getSchema().getTypeName();
            GeometryAttributeType geomType = this.getSchema().getDefaultGeometry();
            if (geomType != null) {
                Filter filter = query.getFilter();
                short ftype = filter.getFilterType();
                if (ftype == 7 || ftype == 4) {
                    filter = this.fixNullGeomFilter(filter);
                }
                if (filter != Filter.ALL) {
                    String sqlStmt = null;
                    try {
                        DB2SQLBuilder builder = (DB2SQLBuilder)((DB2DataStore)this.getDataStore()).getSqlBuilder(typeName);
                        LOGGER.fine("Filter: " + filter.toString());
                        sqlStmt = builder.buildSQLBoundsQuery(typeName, (AttributeType)geomType, filter);
                    }
                    catch (SQLEncoderException e) {
                        throw new IOException("SQLEncoderException: " + (Object)((Object)e));
                    }
                    Connection conn = null;
                    Transaction transaction = null;
                    Statement statement = null;
                    ResultSet results = null;
                    try {
                        conn = this.getConnection();
                        transaction = this.getTransaction();
                        statement = conn.createStatement();
                        results = statement.executeQuery(sqlStmt);
                        if (results.next()) {
                            double minx = results.getDouble(1);
                            double miny = results.getDouble(2);
                            double maxx = results.getDouble(3);
                            double maxy = results.getDouble(4);
                            env = new Envelope(minx, maxx, miny, maxy);
                        } else {
                            env = new Envelope();
                        }
                    }
                    catch (SQLException e) {
                        this.closeAll(results, statement, conn, transaction, e);
                        System.out.println(e);
                        throw new DataSourceException("Could not get bounds " + query.getHandle(), (Throwable)e);
                    }
                    this.closeAll(results, statement, conn, transaction, null);
                }
                crs = geomType.getCoordinateSystem();
                env = new ReferencedEnvelope(env, crs);
            }
        }
        LOGGER.fine("Bounds: " + env.toString());
        return env;
    }

    private Filter fixNullGeomFilter(Filter inFilter) {
        GeometryFilter gf = (GeometryFilter)inFilter;
        if (gf.getExpression1() == null) {
            String attName = null;
            GeometryAttributeType dg = this.getSchema().getDefaultGeometry();
            if (dg != null) {
                attName = dg.getName();
            }
            if (attName != null) {
                FilterFactory ff = FilterFactoryFinder.createFilterFactory();
                AttributeExpression spatialColumn = ff.createAttributeExpression(attName);
                gf.addLeftGeometry((Expression)spatialColumn);
                if (gf.getFilterType() == 7) {
                    gf = ff.createGeometryFilter((short)4);
                    gf.addLeftGeometry((Expression)spatialColumn);
                    gf.addRightGeometry(((GeometryFilter)inFilter).getRightGeometry());
                }
            }
        }
        return gf;
    }
}

