/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.db2.DB2SQLBuilder;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBCTextFeatureWriter;
import org.geotools.data.jdbc.QueryData;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;

public class DB2FeatureWriter
extends JDBCTextFeatureWriter {
    private DB2SQLBuilder sqlBuilder;
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.db2");

    public DB2FeatureWriter(FeatureReader reader, QueryData queryData, DB2SQLBuilder sqlBuilder) throws IOException {
        super(reader, queryData);
        this.sqlBuilder = sqlBuilder;
    }

    protected String makeDeleteSql(Feature feature) throws IOException {
        String deleteSQL = this.sqlBuilder.makeDeleteSql(feature);
        return deleteSQL;
    }

    protected String makeInsertSql(Feature feature) throws IOException {
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        FeatureType featureType = ftInfo.getSchema();
        AttributeType[] attributes = featureType.getAttributeTypes();
        String insertSQL = this.sqlBuilder.makeInsertSql(attributes, feature);
        return insertSQL;
    }

    protected String makeUpdateSql(Feature live, Feature current) throws IOException {
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        FeatureType featureType = ftInfo.getSchema();
        AttributeType[] attributes = featureType.getAttributeTypes();
        String updateSQL = this.sqlBuilder.makeUpdateSql(attributes, live, current);
        return updateSQL;
    }

    protected String getGeometryInsertText(Geometry geom, int srid) throws IOException {
        return null;
    }
}

