/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.db2.filter.SQLEncoderDB2;
import org.geotools.data.jdbc.DefaultSQLBuilder;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.filter.Filter;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;

public class DB2SQLBuilder
extends DefaultSQLBuilder {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.db2");
    private String tableSchema = null;
    private String tableName = null;
    private FIDMapper mapper = null;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;
    static /* synthetic */ Class class$java$lang$String;

    public DB2SQLBuilder(SQLEncoder encoder, FIDMapper mapper, String tableSchema, String tableName) {
        super(encoder);
        this.mapper = mapper;
        this.tableSchema = tableSchema;
        this.tableName = tableName;
    }

    public DB2SQLBuilder(SQLEncoder encoder, String tableSchema, FeatureType featureType) {
        this.encoder = encoder;
        this.accessor = null;
        this.tableSchema = tableSchema;
        this.tableName = featureType.getTypeName();
    }

    public void sqlGeometryColumn(StringBuffer sql, AttributeType geomAttribute) {
        sql.append("DB2GSE.ST_AsText(" + this.sqlGeometryColumnName(geomAttribute) + ")");
    }

    String sqlGeometryColumnName(AttributeType geomAttribute) {
        return this.encoder.escapeName(geomAttribute.getName());
    }

    String sqlGeometryMinMaxValues(AttributeType geomAttribute) {
        String gcName = this.sqlGeometryColumnName(geomAttribute);
        String sql = "MIN(db2gse.ST_MinX(" + gcName + ")), " + "MIN(db2gse.ST_MinY(" + gcName + ")), " + "MAX(db2gse.ST_MaxX(" + gcName + ")), " + "MAX(db2gse.ST_MaxY(" + gcName + ")) ";
        return sql;
    }

    public void sqlFrom(StringBuffer sql, String typeName) {
        sql.append(" FROM ");
        sql.append(this.getSchemaTableName(typeName));
    }

    public String buildSQLBoundsQuery(String typeName, AttributeType geomAttr, Filter filter) throws SQLEncoderException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT ");
        sqlBuffer.append(this.sqlGeometryMinMaxValues(geomAttr));
        this.sqlFrom(sqlBuffer, typeName);
        this.sqlWhere(sqlBuffer, filter);
        String sqlStmt = sqlBuffer.toString();
        LOGGER.finer(sqlStmt);
        return sqlStmt;
    }

    SQLEncoderDB2 getEncoder() {
        return (SQLEncoderDB2)this.encoder;
    }

    String getSchemaTableName(String tableName) {
        return this.escapeName(this.tableSchema) + "." + this.escapeName(tableName);
    }

    String getSchemaTableName() {
        return this.escapeName(this.tableSchema) + "." + this.escapeName(this.tableName);
    }

    String escapeName(String name) {
        return this.encoder.escapeName(name);
    }

    protected String makeInsertSql(AttributeType[] attributes, Feature feature) throws IOException {
        SQLEncoderDB2 db2Encoder = (SQLEncoderDB2)this.encoder;
        String attrValue = null;
        boolean firstAttr = true;
        StringBuffer colNameList = new StringBuffer("");
        StringBuffer valueList = new StringBuffer("");
        for (int i = 0; i < attributes.length; ++i) {
            String colName = this.escapeName(attributes[i].getName());
            if (!firstAttr) {
                colNameList.append(", ");
                valueList.append(", ");
            }
            firstAttr = false;
            colNameList.append(colName);
            Object currAtt = feature.getAttribute(i);
            attrValue = currAtt == null ? "NULL" : ((class$com$vividsolutions$jts$geom$Geometry == null ? DB2SQLBuilder.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(attributes[i].getType()) ? db2Encoder.db2Geom((Geometry)currAtt) : ((class$java$lang$String == null ? DB2SQLBuilder.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(attributes[i].getType()) ? "'" + currAtt.toString() + "'" : currAtt.toString()));
            valueList.append(attrValue);
        }
        String statementSQL = "INSERT INTO " + this.getSchemaTableName() + "( " + colNameList.toString() + ")" + " VALUES(" + valueList.toString() + ")";
        return statementSQL;
    }

    protected String makeUpdateSql(AttributeType[] attributes, Feature live, Feature current) throws IOException {
        boolean firstAttr = true;
        SQLEncoderDB2 db2Encoder = (SQLEncoderDB2)this.encoder;
        StringBuffer statementSQL = new StringBuffer("UPDATE " + this.getSchemaTableName() + " SET ");
        for (int i = 0; i < current.getNumberOfAttributes(); ++i) {
            Object liveAtt;
            Object currAtt = current.getAttribute(i);
            if (DataUtilities.attributesEqual((Object)currAtt, (Object)(liveAtt = live.getAttribute(i)))) continue;
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.fine("modifying att# " + i + " to " + currAtt);
            }
            String attrValue = null;
            String attrName = attributes[i].getName();
            attrValue = (class$com$vividsolutions$jts$geom$Geometry == null ? DB2SQLBuilder.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(attributes[i].getType()) ? db2Encoder.db2Geom((Geometry)currAtt) : ((class$java$lang$String == null ? DB2SQLBuilder.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(attributes[i].getType()) ? "'" + currAtt.toString() + "'" : currAtt.toString());
            String colName = this.escapeName(attrName);
            if (!firstAttr) {
                statementSQL.append(", ");
            }
            firstAttr = false;
            statementSQL.append(colName).append(" = ").append(attrValue);
        }
        statementSQL.append(this.makeFIDWhere(current));
        return statementSQL.toString();
    }

    public String makeDeleteSql(Feature feature) throws IOException {
        String deleteSQL = "DELETE FROM " + this.getSchemaTableName() + this.makeFIDWhere(feature);
        return deleteSQL;
    }

    protected String makeFIDWhere(Feature feature) throws IOException {
        StringBuffer statementSQL = new StringBuffer(" WHERE ");
        Object[] pkValues = this.mapper.getPKAttributes(feature.getID());
        if (this.mapper.getColumnCount() == 0) {
            throw new UnsupportedOperationException();
        }
        boolean firstCol = true;
        for (int i = 0; i < this.mapper.getColumnCount(); ++i) {
            if (!firstCol) {
                statementSQL.append(" AND ");
                firstCol = false;
            }
            statementSQL.append(this.escapeName(this.mapper.getColumnName(i))).append(" = ");
            if (this.isTypeNumeric(this.mapper.getColumnType(i))) {
                statementSQL.append(pkValues[i]);
                continue;
            }
            statementSQL.append("'" + pkValues[i] + "'");
        }
        return statementSQL.toString();
    }

    protected boolean isTypeNumeric(int columnType) {
        boolean numeric = false;
        if (columnType == -7 || columnType == -6 || columnType == 5 || columnType == 4 || columnType == -5 || columnType == 6 || columnType == 7 || columnType == 8 || columnType == 2 || columnType == 3) {
            numeric = true;
        }
        return numeric;
    }
}

