/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2.filter;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.GeometryDistanceFilter;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;

public class SQLEncoderDB2
extends SQLEncoder
implements FilterVisitor {
    private static Logger LOGGER = Logger.getLogger("org.geotools.data.db2");
    private static WKTWriter wktWriter = new WKTWriter();
    private static char SQL_WILD_MULTI = (char)37;
    private static char SQL_WILD_SINGLE = (char)95;
    private static String escapedWildcardSingle = "\\.\\?";
    private static String escapedWildcardMulti = "\\.\\*";
    private static HashMap DB2_SPATIAL_PREDICATES = new HashMap();
    private String selectivityClause = null;
    private int srid = 1;

    public SQLEncoderDB2() {
        DB2_SPATIAL_PREDICATES.put(new Integer(4), "EnvelopesIntersect");
        DB2_SPATIAL_PREDICATES.put(new Integer(11), "ST_Contains");
        DB2_SPATIAL_PREDICATES.put(new Integer(9), "ST_Crosses");
        DB2_SPATIAL_PREDICATES.put(new Integer(6), "ST_Disjoint");
        DB2_SPATIAL_PREDICATES.put(new Integer(5), "ST_Equals");
        DB2_SPATIAL_PREDICATES.put(new Integer(7), "ST_Intersects");
        DB2_SPATIAL_PREDICATES.put(new Integer(12), "ST_Overlaps");
        DB2_SPATIAL_PREDICATES.put(new Integer(8), "ST_Touches");
        DB2_SPATIAL_PREDICATES.put(new Integer(10), "ST_Within");
        DB2_SPATIAL_PREDICATES.put(new Integer(24), "ST_Distance");
        DB2_SPATIAL_PREDICATES.put(new Integer(13), "ST_Distance");
    }

    public SQLEncoderDB2(Writer out, Filter filter) throws SQLEncoderException {
        super(out, filter);
        DB2_SPATIAL_PREDICATES.put(new Integer(4), "EnvelopesIntersect");
        DB2_SPATIAL_PREDICATES.put(new Integer(11), "ST_Contains");
        DB2_SPATIAL_PREDICATES.put(new Integer(9), "ST_Crosses");
        DB2_SPATIAL_PREDICATES.put(new Integer(6), "ST_Disjoint");
        DB2_SPATIAL_PREDICATES.put(new Integer(5), "ST_Equals");
        DB2_SPATIAL_PREDICATES.put(new Integer(7), "ST_Intersects");
        DB2_SPATIAL_PREDICATES.put(new Integer(12), "ST_Overlaps");
        DB2_SPATIAL_PREDICATES.put(new Integer(8), "ST_Touches");
        DB2_SPATIAL_PREDICATES.put(new Integer(10), "ST_Within");
        DB2_SPATIAL_PREDICATES.put(new Integer(24), "ST_Distance");
        DB2_SPATIAL_PREDICATES.put(new Integer(13), "ST_Distance");
    }

    private static HashMap getPredicateTable() {
        return DB2_SPATIAL_PREDICATES;
    }

    public void visit(LikeFilter filter) throws RuntimeException {
        try {
            String pattern = filter.getPattern();
            LOGGER.fine("input pattern: '" + pattern + "'");
            String wcm = filter.getWildcardMulti();
            String wcs = filter.getWildcardSingle();
            LOGGER.fine("wcm is: '" + wcm + "'; wcs is: '" + wcs + "'");
            pattern = pattern.replace(wcm.charAt(0), SQL_WILD_MULTI);
            LOGGER.fine("pattern: '" + pattern + "' after replace of '" + wcm + "'");
            pattern = pattern.replace(wcs.charAt(0), SQL_WILD_SINGLE);
            LOGGER.fine("pattern: '" + pattern + "' after replace of '" + wcs + "'");
            ((AttributeExpression)filter.getValue()).accept((FilterVisitor)this);
            this.out.write(" LIKE ");
            this.out.write("'" + pattern + "'");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void visit(GeometryFilter filter) throws RuntimeException {
        LOGGER.finer("Generating GeometryFilter WHERE clause for " + filter);
        DefaultExpression left = (DefaultExpression)filter.getLeftGeometry();
        DefaultExpression right = (DefaultExpression)filter.getRightGeometry();
        if (null == left || null == right) {
            String msg = "Left or right expression is null - " + filter;
            LOGGER.warning(msg);
            throw new RuntimeException(msg);
        }
        try {
            String spatialPredicate = (String)SQLEncoderDB2.getPredicateTable().get(new Integer(filter.getFilterType()));
            if (spatialPredicate == null) {
                String msg = "Unsupported filter type: " + filter.getFilterType();
                LOGGER.warning(msg);
                throw new RuntimeException(msg);
            }
            switch (filter.getFilterType()) {
                case 24: {
                    this.encodeDistance(left, right, "<", (GeometryDistanceFilter)filter);
                    break;
                }
                case 13: {
                    this.encodeDistance(left, right, ">", (GeometryDistanceFilter)filter);
                    break;
                }
                case 4: {
                    this.encodeBBox(left, right);
                    break;
                }
                default: {
                    this.out.write("db2gse." + spatialPredicate + "(");
                    left.accept((FilterVisitor)this);
                    this.out.write(", ");
                    right.accept((FilterVisitor)this);
                    this.out.write(") = 1");
                }
            }
            if (this.selectivityClause != null) {
                this.out.write(" " + this.selectivityClause);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOGGER.fine(this.out.toString());
    }

    private void encodeBBox(DefaultExpression left, DefaultExpression right) throws RuntimeException {
        try {
            short leftType = left.getType();
            short rightType = right.getType();
            if (113 != leftType || 104 != rightType) {
                String msg = "Unsupported left and right types: " + leftType + ":" + rightType;
                LOGGER.warning(msg);
                throw new RuntimeException(msg);
            }
            this.out.write("db2gse.EnvelopesIntersect(");
            left.accept((FilterVisitor)this);
            this.out.write(", ");
            Envelope env = ((Geometry)((LiteralExpression)right).getLiteral()).getEnvelopeInternal();
            this.out.write(env.getMinX() + ", " + env.getMinY() + ", " + env.getMaxX() + ", " + env.getMaxY() + ", " + this.srid);
            this.out.write(") = 1");
        }
        catch (IOException e) {
            LOGGER.warning("Filter not generated; I/O problem of some sort" + e);
        }
    }

    private void encodeDistance(DefaultExpression left, DefaultExpression right, String op, GeometryDistanceFilter filter) throws RuntimeException {
        try {
            short leftType = left.getType();
            short rightType = right.getType();
            double distance = filter.getDistance();
            if (113 != leftType || 104 != rightType) {
                String msg = "Unsupported left and right types: " + leftType + ":" + rightType;
                LOGGER.warning(msg);
                throw new RuntimeException(msg);
            }
            this.out.write("db2gse.ST_Distance(");
            left.accept((FilterVisitor)this);
            this.out.write(", ");
            right.accept((FilterVisitor)this);
            this.out.write(") " + op + " " + distance);
        }
        catch (IOException e) {
            LOGGER.warning("Filter not generated; I/O problem of some sort" + e);
        }
    }

    public void visitLiteralGeometry(LiteralExpression expression) throws IOException {
        String wktRepresentation = wktWriter.write((Geometry)expression.getLiteral());
        int spacePos = wktRepresentation.indexOf(" ");
        String geomType = wktRepresentation.substring(0, spacePos);
        this.out.write("db2gse.ST_" + geomType + "('" + wktRepresentation + "', " + this.srid + ")");
    }

    public String db2Geom(Geometry geom) {
        String geomType = geom.getGeometryType();
        String g1 = geom.toText();
        String g2 = "db2gse.ST_" + geomType + "('" + g1 + "'," + this.srid + ")";
        return g2;
    }

    public void setSRID(int srid) {
        this.srid = srid;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities capabilities = new FilterCapabilities();
        capabilities.addType(0x2000000L);
        capabilities.addType(0x800000L);
        capabilities.addType(0x1000000L);
        capabilities.addType(65536L);
        capabilities.addType(0x200000L);
        capabilities.addType(524288L);
        capabilities.addType(131072L);
        capabilities.addType(0x100000L);
        capabilities.addType(262144L);
        capabilities.addType(2048L);
        capabilities.addType(8192L);
        capabilities.addType(4096L);
        capabilities.addType(0x400000L);
        capabilities.addType(0x40000000L);
        capabilities.addType(Integer.MIN_VALUE);
        capabilities.addType(1L);
        capabilities.addType(128L);
        capabilities.addType(32L);
        capabilities.addType(4L);
        capabilities.addType(2L);
        capabilities.addType(8L);
        capabilities.addType(256L);
        capabilities.addType(16L);
        capabilities.addType(64L);
        capabilities.addType(1024L);
        capabilities.addType(512L);
        return capabilities;
    }

    public void setSelectivityClause(String string) {
        this.selectivityClause = string;
    }

    public void visit(FidFilter filter) {
        int i;
        if (this.mapper == null) {
            throw new RuntimeException("Must set a fid mapper before trying to encode FIDFilters");
        }
        String[] fids = filter.getFids();
        LOGGER.finer("Exporting FID=" + Arrays.asList(fids));
        String[] colNames = new String[this.mapper.getColumnCount()];
        String[] colDelimiters = new String[this.mapper.getColumnCount()];
        for (i = 0; i < colNames.length; ++i) {
            colNames[i] = this.mapper.getColumnName(i);
            int dataType = this.mapper.getColumnType(i);
            colDelimiters[i] = dataType == 12 || dataType == 1 || dataType == 2005 ? "'" : "";
        }
        for (i = 0; i < fids.length; ++i) {
            try {
                Object[] attValues = this.mapper.getPKAttributes(fids[i]);
                this.out.write("(");
                for (int j = 0; j < attValues.length; ++j) {
                    int colType = this.mapper.getColumnType(j);
                    this.out.write(this.escapeName(colNames[j]));
                    this.out.write(" = ");
                    this.out.write(colDelimiters[j]);
                    this.out.write(attValues[j].toString());
                    this.out.write(colDelimiters[j]);
                    if (j >= attValues.length - 1) continue;
                    this.out.write(" AND ");
                }
                this.out.write(")");
                if (i >= fids.length - 1) continue;
                this.out.write(" OR ");
                continue;
            }
            catch (IOException e) {
                LOGGER.warning("IO Error exporting FID Filter.");
            }
        }
    }
}

