/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.oracle.OracleConnectionFactory;
import org.geotools.data.oracle.OracleDataStore;

public class OracleDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.oracle");
    private static final String JDBC_DRIVER = "oracle.jdbc.driver.OracleDriver";
    static final DataStoreFactorySpi.Param DBTYPE = new DataStoreFactorySpi.Param("dbtype", String.class, "This must be 'oracle'.", true, (Object)"oracle");
    static final DataStoreFactorySpi.Param HOST = new DataStoreFactorySpi.Param("host", String.class, "The host name of the server.", true);
    static final DataStoreFactorySpi.Param PORT = new DataStoreFactorySpi.Param("port", String.class, "The port oracle is running on. (Default is 1521)", true, (Object)"1521");
    static final DataStoreFactorySpi.Param USER = new DataStoreFactorySpi.Param("user", String.class, "The user name to log in with.", true);
    static final DataStoreFactorySpi.Param PASSWD = new DataStoreFactorySpi.Param("passwd", String.class, "The password.", true);
    static final DataStoreFactorySpi.Param INSTANCE = new DataStoreFactorySpi.Param("instance", String.class, "The name of the Oracle instance to connect to.", true);
    static final DataStoreFactorySpi.Param SCHEMA = new DataStoreFactorySpi.Param("schema", String.class, "The schema name to narrow down the exposed tables (must be upper case).", false){

        public Object lookUp(Map map) throws IOException {
            if (!map.containsKey(this.key)) {
                if (this.required) {
                    throw new IOException("Parameter " + this.key + " is required:" + this.description);
                }
                return null;
            }
            Object value = map.get(this.key);
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                String text = (String)value;
                if (text == null) {
                    return null;
                }
                if (text.equals(text.toUpperCase())) {
                    return text;
                }
                throw new IOException("Schema must be supplied in uppercase");
            }
            throw new IOException("String required for parameter " + this.key + ": not " + value.getClass().getName());
        }
    };
    static final DataStoreFactorySpi.Param NAMESPACE = new DataStoreFactorySpi.Param("namespace", String.class, "The namespace to give the DataStore", false);

    public boolean canProcess(Map params) {
        if (params != null) {
            if (params.get("dbtype") == null || !params.get("dbtype").toString().equalsIgnoreCase("oracle")) {
                return false;
            }
            DataStoreFactorySpi.Param[] arrayParameters = this.getParametersInfo();
            for (int i = 0; i < arrayParameters.length; ++i) {
                Object value;
                DataStoreFactorySpi.Param param = arrayParameters[i];
                if (!params.containsKey(param.key)) {
                    if (!param.required) continue;
                    return false;
                }
                try {
                    value = param.lookUp(params);
                }
                catch (IOException e) {
                    LOGGER.warning(param.key + ":" + e);
                    return false;
                }
                if (!(value == null ? param.required : !param.type.isInstance(value))) continue;
                return false;
            }
        } else {
            return false;
        }
        return ((String)params.get("dbtype")).equalsIgnoreCase("oracle");
    }

    public DataStore createDataStore(Map params) throws IOException {
        String host = (String)HOST.lookUp(params);
        String port = (String)PORT.lookUp(params);
        String instance = (String)INSTANCE.lookUp(params);
        String user = (String)USER.lookUp(params);
        String passwd = (String)PASSWD.lookUp(params);
        String schema = (String)SCHEMA.lookUp(params);
        String namespace = (String)NAMESPACE.lookUp(params);
        String dbtype = (String)DBTYPE.lookUp(params);
        if (!"oracle".equals(dbtype)) {
            throw new IOException("Parameter 'dbtype' must be oracle");
        }
        if (!this.canProcess(params)) {
            throw new IOException("Cannot connect using provided parameters");
        }
        try {
            OracleConnectionFactory ocFactory = new OracleConnectionFactory(host, port, instance);
            ocFactory.setLogin(user, passwd);
            ConnectionPool pool = ocFactory.getConnectionPool();
            OracleDataStore dataStore = new OracleDataStore(pool, namespace, schema, new HashMap());
            return dataStore;
        }
        catch (SQLException ex) {
            throw new DataSourceException("Error creating oracle DataSource", (Throwable)ex);
        }
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("Oracle cannot create a new Database");
    }

    public String getDisplayName() {
        return "Oracle";
    }

    public String getDescription() {
        return "Oracle Spatial Database";
    }

    public boolean isAvailable() {
        try {
            Class.forName(JDBC_DRIVER);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return new DataStoreFactorySpi.Param[]{DBTYPE, HOST, PORT, USER, PASSWD, INSTANCE, SCHEMA, NAMESPACE};
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

