/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.sql.STRUCT;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.jdbc.JDBCTextFeatureWriter;
import org.geotools.data.jdbc.MutableFIDFeature;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.oracle.sdo.GeometryConverter;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.type.GeometricAttributeType;

public class OracleFeatureWriter
extends JDBCTextFeatureWriter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.oracle");
    GeometryConverter converter;

    public OracleFeatureWriter(FeatureReader fReader, QueryData queryData) throws IOException {
        super(fReader, queryData);
        this.converter = new GeometryConverter((OracleConnection)queryData.getConnection());
    }

    protected String getGeometryInsertText(Geometry geom, int srid) throws IOException {
        return "?";
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doUpdate(Feature live, Feature current) throws IOException, SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("updating postgis feature " + current);
        }
        Statement statement = null;
        Connection conn = null;
        conn = this.queryData.getConnection();
        String sql = this.makeUpdateSql(live, current);
        statement = conn.prepareStatement(sql);
        FeatureType schema = current.getFeatureType();
        int position = 1;
        for (int i = 0; i < current.getNumberOfAttributes(); ++i) {
            AttributeType type = schema.getAttributeType(i);
            if (!(type instanceof GeometricAttributeType) || DataUtilities.attributesEqual((Object)current.getAttribute(i), (Object)live.getAttribute(i))) continue;
            Geometry geometry = (Geometry)current.getAttribute(i);
            LOGGER.fine("ORACLE SPATIAL: geometry to be written:" + geometry);
            int srid = this.queryData.getFeatureTypeInfo().getSRID(type.getName());
            geometry.setSRID(srid);
            STRUCT struct = this.converter.toSDO(geometry);
            statement.setObject(position, struct);
            LOGGER.fine("ORACLE SPATIAL: set geometry parameter at position:" + position);
            ++position;
            break;
        }
        LOGGER.fine(sql);
        statement.execute();
        Object var14_15 = null;
        if (statement == null) return;
        try {
            statement.close();
            return;
        }
        catch (SQLException e) {
            String msg = "Error closing JDBC Statement";
            LOGGER.log(Level.WARNING, msg, e);
        }
        return;
        {
            catch (SQLException sqle) {
                String msg = "SQL Exception writing geometry column" + sqle.getLocalizedMessage();
                LOGGER.log(Level.SEVERE, msg, sqle);
                this.queryData.close(sqle);
                throw new DataSourceException(msg, (Throwable)sqle);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException e) {
                String msg = "Error closing JDBC Statement";
                LOGGER.log(Level.WARNING, msg, e);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doInsert(MutableFIDFeature current) throws IOException, SQLException {
        Statement statement;
        block8: {
            LOGGER.fine("inserting into postgis feature " + current);
            statement = null;
            Connection conn = null;
            conn = this.queryData.getConnection();
            String sql = this.makeInsertSql((Feature)current);
            statement = conn.prepareStatement(sql);
            int position = 1;
            FeatureType schema = current.getFeatureType();
            for (int i = 0; i < current.getNumberOfAttributes(); ++i) {
                AttributeType type = schema.getAttributeType(i);
                if (!(type instanceof GeometricAttributeType)) continue;
                Geometry geometry = (Geometry)current.getAttribute(i);
                int srid = this.queryData.getFeatureTypeInfo().getSRID(type.getName());
                geometry.setSRID(srid);
                STRUCT struct = this.converter.toSDO(geometry);
                statement.setObject(position, struct);
                ++position;
            }
            LOGGER.fine(sql);
            statement.execute();
            if (this.mapper.getColumnCount() <= 0 || !this.mapper.hasAutoIncrementColumns()) break block8;
            current.setID(this.mapper.createID(conn, (Feature)current, statement));
        }
        Object var13_14 = null;
        if (statement == null) return;
        try {
            statement.close();
            return;
        }
        catch (SQLException e) {
            String msg = "Error closing JDBC Statement";
            LOGGER.log(Level.WARNING, msg, e);
        }
        return;
        {
            catch (SQLException sqle) {
                String msg = "SQL Exception writing geometry column" + sqle.getLocalizedMessage();
                LOGGER.log(Level.SEVERE, msg, sqle);
                this.queryData.close(sqle);
                throw new DataSourceException(msg, (Throwable)sqle);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException e) {
                String msg = "Error closing JDBC Statement";
                LOGGER.log(Level.WARNING, msg, e);
            }
            throw throwable;
        }
    }
}

