/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle.attributeio;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.sql.STRUCT;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.data.oracle.sdo.GeometryConverter;
import org.geotools.feature.AttributeType;

public class SDOAttributeIO
implements AttributeIO {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.oracle");
    GeometryConverter converter;
    private QueryData queryData;
    private Class targetClazz;
    private GeometryFactory geometryFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDOAttributeIO(AttributeType attributeType, QueryData queryData) throws DataSourceException {
        this.queryData = queryData;
        this.geometryFactory = null;
        String tableName = queryData.getFeatureTypeInfo().getFeatureTypeName();
        String columnName = attributeType.getName();
        this.targetClazz = attributeType.getType();
        LOGGER.fine("About to create Geometry convertor for " + tableName + "." + columnName);
        OracleConnection oracleConnection = (OracleConnection)queryData.getConnection();
        int srid = queryData.getFeatureTypeInfo().getSRID(columnName);
        if (srid != -1) {
            PrecisionModel pm = new PrecisionModel();
            this.geometryFactory = new GeometryFactory(pm, srid);
        } else {
            this.geometryFactory = new GeometryFactory();
        }
        this.converter = new GeometryConverter(oracleConnection, this.geometryFactory);
    }

    public Object read(ResultSet rs, int position) throws IOException {
        try {
            Geometry geom = null;
            Object struct = rs.getObject(position);
            geom = this.converter.asGeometry((STRUCT)struct);
            if (this.targetClazz.equals(MultiPolygon.class) && geom instanceof Polygon) {
                return this.geometryFactory.createMultiPolygon(new Polygon[]{(Polygon)geom});
            }
            if (this.targetClazz.equals(MultiPoint.class) && geom instanceof Point) {
                return this.geometryFactory.createMultiPoint(new Point[]{(Point)geom});
            }
            if (this.targetClazz.equals(MultiLineString.class) && geom instanceof LineString) {
                return this.geometryFactory.createMultiLineString(new LineString[]{(LineString)geom});
            }
            if (this.targetClazz.equals(GeometryCollection.class)) {
                return this.geometryFactory.createGeometryCollection(new Geometry[]{geom});
            }
            return geom;
        }
        catch (SQLException e) {
            String msg = "SQL Exception reading geometry column";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataSourceException(msg, (Throwable)e);
        }
    }

    public void write(ResultSet rs, int position, Object value) throws IOException {
        try {
            Geometry geom = (Geometry)value;
            STRUCT struct = this.converter.toSDO(geom);
            rs.updateObject(position, (Object)struct);
        }
        catch (SQLException sqlException) {
            String msg = "SQL Exception writing geometry column";
            LOGGER.log(Level.SEVERE, msg, sqlException);
            throw new DataSourceException(msg, (Throwable)sqlException);
        }
    }

    public void write(PreparedStatement ps, int position, Object value) throws IOException {
        try {
            Geometry geom = (Geometry)value;
            STRUCT struct = this.converter.toSDO(geom);
            ps.setObject(position, struct);
        }
        catch (SQLException sqlException) {
            String msg = "SQL Exception writing geometry column";
            LOGGER.log(Level.SEVERE, msg, sqlException);
            throw new DataSourceException(msg, (Throwable)sqlException);
        }
    }
}

