/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.axis;

import java.awt.RenderingHints;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Locale;
import javax.units.ConversionException;
import javax.units.Unit;
import org.geotools.axis.Graduation;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;

public abstract class AbstractGraduation
implements Graduation,
Serializable {
    private static final long serialVersionUID = 5215728323932315112L;
    private Unit unit;
    private String title;
    private Locale locale = Locale.getDefault();
    protected final PropertyChangeSupport listenerList = new PropertyChangeSupport(this);

    public AbstractGraduation(Unit unit) {
        this.unit = unit;
    }

    public abstract boolean setMinimum(double var1) throws IllegalArgumentException;

    public abstract boolean setMaximum(double var1) throws IllegalArgumentException;

    public synchronized String getTitle(boolean includeSymbol) {
        String symbol;
        if (includeSymbol && (symbol = this.getSymbol()) != null && symbol.length() != 0) {
            return this.title != null ? this.title + " (" + symbol + ')' : symbol;
        }
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String title) {
        String old;
        AbstractGraduation abstractGraduation = this;
        synchronized (abstractGraduation) {
            old = this.title;
            this.title = title;
        }
        this.listenerList.firePropertyChange("title", old, title);
    }

    String getSymbol() {
        Unit unit = this.getUnit();
        return unit != null ? unit.toString() : null;
    }

    public Unit getUnit() {
        return this.unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnit(Unit unit) throws ConversionException {
        Unit oldUnit;
        AbstractGraduation abstractGraduation = this;
        synchronized (abstractGraduation) {
            oldUnit = this.unit;
            this.unit = unit;
        }
        this.listenerList.firePropertyChange("unit", oldUnit, unit);
    }

    public Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLocale(Locale locale) {
        Locale old;
        AbstractGraduation abstractGraduation = this;
        synchronized (abstractGraduation) {
            old = this.locale;
            this.locale = locale;
        }
        this.listenerList.firePropertyChange("locale", old, locale);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listenerList.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listenerList.removePropertyChangeListener(listener);
    }

    static float getVisualAxisLength(RenderingHints hints) {
        return AbstractGraduation.getValue(hints, VISUAL_AXIS_LENGTH, 600.0f);
    }

    static float getVisualTickSpacing(RenderingHints hints) {
        return AbstractGraduation.getValue(hints, VISUAL_TICK_SPACING, 48.0f);
    }

    private static float getValue(RenderingHints hints, RenderingHints.Key key, float defaultValue) {
        float value;
        Object object;
        if (hints != null && (object = hints.get(key)) instanceof Number && (value = ((Number)object).floatValue()) != 0.0f && !Float.isInfinite(value)) {
            return value;
        }
        return defaultValue;
    }

    static void ensureNonNull(String name, double n) throws IllegalArgumentException {
        if (Double.isNaN(n) || Double.isInfinite(n) || n == 0.0) {
            throw new IllegalArgumentException(Errors.format((int)42, (Object)name, (Object)new Double(n)));
        }
    }

    static void ensureFinite(String name, double n) throws IllegalArgumentException {
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            throw new IllegalArgumentException(Errors.format((int)42, (Object)name, (Object)new Double(n)));
        }
    }

    static void ensureFinite(String name, float n) throws IllegalArgumentException {
        if (Float.isNaN(n) || Float.isInfinite(n)) {
            throw new IllegalArgumentException(Errors.format((int)42, (Object)name, (Object)new Float(n)));
        }
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            AbstractGraduation that = (AbstractGraduation)object;
            return Utilities.equals((Object)this.unit, (Object)that.unit) && Utilities.equals((Object)this.title, (Object)that.title) && Utilities.equals((Object)this.locale, (Object)that.locale);
        }
        return false;
    }

    public int hashCode() {
        int code = -923935256;
        if (this.title != null) {
            code ^= this.title.hashCode();
        }
        if (this.unit != null) {
            code ^= this.unit.hashCode();
        }
        return code;
    }
}

