/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.axis;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Locale;
import org.geotools.axis.AbstractGraduation;
import org.geotools.axis.Graduation;
import org.geotools.axis.NumberGraduation;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.Utilities;
import org.geotools.resources.XMath;
import org.geotools.resources.geometry.XDimension2D;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.util.Cloneable;

public class Axis2D
extends Line2D
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8396436909942389360L;
    private float x1 = 8.0f;
    private float y1 = 8.0f;
    private float x2 = 648.0f;
    private float y2 = 8.0f;
    private float tickStart = 0.0f;
    private float tickEnd = 9.0f;
    private float subTickStart = 0.0f;
    private float subTickEnd = 5.0f;
    private byte relativeCCW = 1;
    private final Graduation graduation;
    private transient DefaultCoordinateSystemAxis information;
    private transient int modCount;
    private transient boolean isPainting;
    private transient TickPathIterator iterator;
    private transient Rectangle2D axisBounds;
    private transient Rectangle2D labelBounds;
    private transient Rectangle2D legendBounds;
    private transient FontRenderContext lastContext;
    private transient Dimension2D maximumSize;
    private transient Font defaultFont;
    private RenderingHints hints;

    public Axis2D() {
        this(new NumberGraduation(null));
    }

    public Axis2D(Graduation graduation) {
        this.graduation = graduation;
        graduation.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent event) {
                Axis2D axis2D = Axis2D.this;
                synchronized (axis2D) {
                    Axis2D.this.modCount++;
                    Axis2D.this.clearCache();
                }
            }
        });
    }

    public Graduation getGraduation() {
        return this.graduation;
    }

    public double getX1() {
        return this.x1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY1() {
        return this.y1;
    }

    public double getY2() {
        return this.y2;
    }

    public synchronized Point2D getP1() {
        return new Point2D.Float(this.x1, this.y1);
    }

    public synchronized Point2D getP2() {
        return new Point2D.Float(this.x2, this.y2);
    }

    public synchronized double getLength() {
        return XMath.hypot((double)(this.getX1() - this.getX2()), (double)(this.getY1() - this.getY2()));
    }

    public synchronized Rectangle2D getBounds2D() {
        if (this.axisBounds == null) {
            this.paint(null);
        }
        Rectangle2D bounds = (Rectangle2D)this.axisBounds.clone();
        if (this.labelBounds != null) {
            bounds.add(this.labelBounds);
        }
        if (this.legendBounds != null) {
            bounds.add(this.legendBounds);
        }
        return bounds;
    }

    public synchronized void setLine(double x1, double y1, double x2, double y2) throws IllegalArgumentException {
        float fx1 = (float)x1;
        AbstractGraduation.ensureFinite("x1", fx1);
        float fy1 = (float)y1;
        AbstractGraduation.ensureFinite("y1", fy1);
        float fx2 = (float)x2;
        AbstractGraduation.ensureFinite("x2", fx2);
        float fy2 = (float)y2;
        AbstractGraduation.ensureFinite("y2", fy2);
        ++this.modCount;
        this.x1 = fx1;
        this.y1 = fy1;
        this.x2 = fx2;
        this.y2 = fy2;
        this.clearCache();
    }

    public boolean isLabelClockwise() {
        return this.relativeCCW < 0;
    }

    public synchronized void setLabelClockwise(boolean c) {
        ++this.modCount;
        this.relativeCCW = (byte)(c ? -1 : 1);
    }

    private synchronized Font getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = new Font("SansSerif", 0, 9);
        }
        return this.defaultFont;
    }

    public java.awt.geom.PathIterator getPathIterator(AffineTransform transform) {
        return this.getPathIterator(transform, Double.NaN);
    }

    public synchronized java.awt.geom.PathIterator getPathIterator(AffineTransform transform, double flatness) {
        if (this.isPainting) {
            if (this.iterator != null) {
                this.iterator.rewind(transform);
            } else {
                this.iterator = new TickPathIterator(transform);
            }
            return this.iterator;
        }
        return new PathIterator(transform, flatness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void paint(Graphics2D graphics) {
        String title;
        boolean sameContext;
        Shape clip;
        if (!(this.getLength() > 0.0)) {
            return;
        }
        if (this.iterator != null) {
            this.iterator.init(null);
        } else {
            this.iterator = new TickPathIterator(null);
        }
        TickPathIterator iterator = this.iterator;
        if (graphics != null) {
            clip = graphics.getClip();
            iterator.setFontRenderContext(graphics.getFontRenderContext());
            iterator.setRenderingHint(graphics, Graduation.AXIS_TITLE_FONT);
            iterator.setRenderingHint(graphics, Graduation.TICK_LABEL_FONT);
            FontRenderContext context = iterator.getFontRenderContext();
            sameContext = clip != null && context.equals(this.lastContext);
        } else {
            clip = null;
            sameContext = false;
            iterator.setFontRenderContext(null);
        }
        if (this.axisBounds == null) {
            this.axisBounds = new Rectangle2D.Float(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.abs(this.x2 - this.x1), Math.abs(this.y2 - this.y1));
            while (!iterator.isDone()) {
                this.axisBounds.add(iterator.point);
                iterator.next();
            }
        }
        if (graphics != null && (clip == null || clip.intersects(this.axisBounds))) {
            try {
                this.isPainting = true;
                graphics.draw(this);
            }
            finally {
                this.isPainting = false;
            }
        }
        if (!sameContext || this.labelBounds == null || clip.intersects(this.labelBounds) || this.maximumSize == null) {
            this.labelBounds = null;
            RectangularShape lastLabelBounds = null;
            double maxWidth = 0.0;
            double maxHeight = 0.0;
            iterator.rewind();
            while (iterator.hasNext()) {
                if (iterator.isMajorTick()) {
                    GlyphVector glyphs = iterator.currentLabelGlyphs();
                    Rectangle2D bounds = iterator.currentLabelBounds();
                    if (glyphs != null && bounds != null) {
                        if (lastLabelBounds == null || !lastLabelBounds.intersects(bounds)) {
                            if (graphics != null && (clip == null || clip.intersects(bounds))) {
                                graphics.drawGlyphVector(glyphs, (float)bounds.getMinX(), (float)bounds.getMaxY());
                            }
                            lastLabelBounds = bounds;
                            double width = bounds.getWidth();
                            double height = bounds.getHeight();
                            if (width > maxWidth) {
                                maxWidth = width;
                            }
                            if (height > maxHeight) {
                                maxHeight = height;
                            }
                        }
                        if (this.labelBounds == null) {
                            this.labelBounds = new Rectangle2D.Float();
                            this.labelBounds.setRect(bounds);
                        } else {
                            this.labelBounds.add(bounds);
                        }
                    }
                }
                iterator.nextMajor();
            }
            this.maximumSize = new XDimension2D.Float((float)maxWidth, (float)maxHeight);
        }
        if ((!sameContext || this.legendBounds == null || clip.intersects(this.legendBounds)) && (title = this.graduation.getTitle(true)) != null) {
            Font font = iterator.getTitleFont();
            GlyphVector glyphs = font.createGlyphVector(iterator.getFontRenderContext(), title);
            AffineTransform rotatedTr = new AffineTransform();
            Rectangle2D bounds = iterator.centerAxisLabel(glyphs.getVisualBounds(), rotatedTr, this.maximumSize);
            if (graphics != null) {
                AffineTransform currentTr = graphics.getTransform();
                try {
                    graphics.transform(rotatedTr);
                    graphics.drawGlyphVector(glyphs, (float)bounds.getMinX(), (float)bounds.getMaxY());
                }
                finally {
                    graphics.setTransform(currentTr);
                }
            }
            this.legendBounds = XAffineTransform.transform((AffineTransform)rotatedTr, (Rectangle2D)bounds, (Rectangle2D)bounds);
        }
        this.lastContext = iterator.getFontRenderContext();
    }

    public synchronized Object getRenderingHint(RenderingHints.Key key) {
        return this.hints != null ? this.hints.get(key) : null;
    }

    public synchronized void setRenderingHint(RenderingHints.Key key, Object value) {
        ++this.modCount;
        if (value != null) {
            if (this.hints == null) {
                this.hints = new RenderingHints(key, value);
                this.clearCache();
            } else if (!value.equals(this.hints.put(key, value))) {
                this.clearCache();
            }
        } else if (this.hints != null) {
            if (this.hints.remove(key) != null) {
                this.clearCache();
            }
            if (this.hints.isEmpty()) {
                this.hints = null;
            }
        }
    }

    private void clearCache() {
        this.axisBounds = null;
        this.labelBounds = null;
        this.legendBounds = null;
        this.maximumSize = null;
        this.information = null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName((Object)this));
        buffer.append("[\"");
        buffer.append(this.graduation.getTitle(true));
        buffer.append("\"]");
        return buffer.toString();
    }

    public synchronized DefaultCoordinateSystemAxis toCoordinateSystemAxis() {
        if (this.information == null) {
            String abbreviation = "z";
            AxisDirection direction = AxisDirection.OTHER;
            if (this.x1 == this.x2) {
                if (this.y1 < this.y2) {
                    direction = AxisDirection.DISPLAY_UP;
                } else if (this.y1 > this.y2) {
                    direction = AxisDirection.DISPLAY_DOWN;
                }
                abbreviation = "y";
            } else if (this.y1 == this.y2) {
                if (this.x1 < this.x2) {
                    direction = AxisDirection.DISPLAY_RIGHT;
                } else if (this.x1 > this.x2) {
                    direction = AxisDirection.DISPLAY_LEFT;
                }
                abbreviation = "x";
            }
            this.information = new DefaultCoordinateSystemAxis(Collections.singletonMap("name", this.graduation.getTitle(false)), abbreviation, direction, this.graduation.getUnit());
        }
        return this.information;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AffineTransform createAffineTransform(Axis2D xAxis, Axis2D yAxis) {
        Axis2D axis2D = xAxis;
        synchronized (axis2D) {
            Axis2D axis2D2 = yAxis;
            synchronized (axis2D2) {
                Graduation mx = xAxis.getGraduation();
                Graduation my = yAxis.getGraduation();
                double ox = mx.getRange();
                double oy = my.getRange();
                double exi = (xAxis.getX2() - xAxis.getX1()) / ox;
                double exj = (xAxis.getY2() - xAxis.getY1()) / ox;
                double eyi = (yAxis.getX2() - yAxis.getX1()) / oy;
                double eyj = (yAxis.getY2() - yAxis.getY1()) / oy;
                ox = mx.getMinimum();
                oy = my.getMinimum();
                return new AffineTransform(exi, exj, eyi, eyj, (double)xAxis.x1 - (ox * exi + oy * eyi), (double)yAxis.y1 - (ox * exj + oy * eyj));
            }
        }
    }

    private final class PathIterator
    extends TickPathIterator {
        private final double flatness;
        private java.awt.geom.PathIterator path;
        private Shape label;
        private Rectangle2D labelBounds;
        private double maxWidth;
        private double maxHeight;
        private boolean isDone;

        public PathIterator(AffineTransform transform, double flatness) {
            super(transform);
            this.maxWidth = 0.0;
            this.maxHeight = 0.0;
            this.flatness = flatness;
        }

        private java.awt.geom.PathIterator getPathIterator(Shape shape) {
            return Double.isNaN(this.flatness) ? shape.getPathIterator(this.transform) : shape.getPathIterator(this.transform, this.flatness);
        }

        public void rewind(AffineTransform transform) {
            throw new UnsupportedOperationException();
        }

        public boolean isDone() {
            return this.path != null ? this.path.isDone() : super.isDone();
        }

        public int currentSegment(float[] coords) {
            return this.path != null ? this.path.currentSegment(coords) : super.currentSegment(coords);
        }

        public int currentSegment(double[] coords) {
            return this.path != null ? this.path.currentSegment(coords) : super.currentSegment(coords);
        }

        public void next() {
            if (this.path != null) {
                this.path.next();
                if (!this.path.isDone()) {
                    return;
                }
                this.path = null;
            }
            if (this.label != null) {
                this.path = this.getPathIterator(this.label);
                this.label = null;
                if (this.path != null) {
                    if (!this.path.isDone()) {
                        return;
                    }
                    this.path = null;
                }
            }
            if (!this.isDone) {
                super.next();
                if (this.isDone()) {
                    this.isDone = true;
                    String title = Axis2D.this.graduation.getTitle(true);
                    if (title != null) {
                        GlyphVector glyphs = this.getTitleFont().createGlyphVector(this.getFontRenderContext(), title);
                        this.transform = this.transform != null ? new AffineTransform(this.transform) : new AffineTransform();
                        Rectangle2D bounds = this.centerAxisLabel(glyphs.getVisualBounds(), this.transform, (Dimension2D)new XDimension2D.Double(this.maxWidth, this.maxHeight));
                        this.path = this.getPathIterator(glyphs.getOutline((float)bounds.getMinX(), (float)bounds.getMaxY()));
                    }
                }
            }
        }

        protected void prepareLabel() {
            if (this.isMajorTick()) {
                GlyphVector glyphs = this.currentLabelGlyphs();
                Rectangle2D bounds = this.currentLabelBounds();
                if (!(glyphs == null || bounds == null || this.labelBounds != null && this.labelBounds.intersects(bounds))) {
                    this.label = glyphs.getOutline((float)bounds.getMinX(), (float)bounds.getMaxY());
                    double width = bounds.getWidth();
                    double height = bounds.getHeight();
                    if (width > this.maxWidth) {
                        this.maxWidth = width;
                    }
                    if (height > this.maxHeight) {
                        this.maxHeight = height;
                    }
                    this.labelBounds = bounds;
                }
            }
        }
    }

    private class TickPathIterator
    extends TickIterator
    implements java.awt.geom.PathIterator {
        protected AffineTransform transform;
        private final Line2D.Double line;
        private final Point2D.Double point;
        private int type;
        private int nextType;
        private static final int AXIS_MOVETO = 0;
        private static final int AXIS_LINETO = 1;
        private static final int TICK_MOVETO = 2;
        private static final int TICK_LINETO = 3;

        public TickPathIterator(AffineTransform transform) {
            super(null);
            this.line = new Line2D.Double();
            this.point = new Point2D.Double();
            this.type = 0;
            this.nextType = 0;
            this.transform = transform;
            this.next();
        }

        final void init(AffineTransform transform) {
            this.refresh();
            this.setFontRenderContext(null);
            this.type = 0;
            this.nextType = 0;
            this.transform = transform;
            this.next();
        }

        public void rewind(AffineTransform transform) {
            super.rewind();
            this.type = 0;
            this.nextType = 0;
            this.transform = transform;
            this.next();
        }

        public final void rewind() {
            this.rewind(this.transform);
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this.nextType == 3 && !this.hasNext();
        }

        public int currentSegment(float[] coords) {
            coords[0] = (float)this.point.x;
            coords[1] = (float)this.point.y;
            return this.type;
        }

        public int currentSegment(double[] coords) {
            coords[0] = this.point.x;
            coords[1] = this.point.y;
            return this.type;
        }

        public void next() {
            switch (this.nextType) {
                default: {
                    throw new IllegalPathStateException(Integer.toString(this.nextType));
                }
                case 0: {
                    this.point.x = Axis2D.this.getX1();
                    this.point.y = Axis2D.this.getY1();
                    this.type = 0;
                    this.nextType = 1;
                    break;
                }
                case 1: {
                    this.point.x = Axis2D.this.getX2();
                    this.point.y = Axis2D.this.getY2();
                    this.type = 1;
                    this.nextType = 2;
                    break;
                }
                case 2: {
                    this.currentTick(this.line);
                    this.point.x = this.line.x1;
                    this.point.y = this.line.y1;
                    this.type = 0;
                    this.nextType = 3;
                    break;
                }
                case 3: {
                    this.point.x = this.line.x2;
                    this.point.y = this.line.y2;
                    this.type = 1;
                    this.nextType = 2;
                    this.prepareLabel();
                    super.next();
                }
            }
            if (this.transform != null) {
                this.transform.transform(this.point, this.point);
            }
            this.ensureValid();
        }

        protected void prepareLabel() {
        }
    }

    public class TickIterator
    implements org.geotools.axis.TickIterator {
        private org.geotools.axis.TickIterator iterator;
        private final RenderingHints hints;
        private double scaleX;
        private double scaleY;
        private double tickX;
        private double tickY;
        private double minimum;
        private transient String label;
        private transient GlyphVector glyphs;
        private transient Font font;
        private transient FontRenderContext fontContext;
        private transient int modCount;

        public TickIterator(FontRenderContext fontContext) {
            this.hints = new RenderingHints(Axis2D.this.hints);
            this.fontContext = fontContext;
            this.refresh();
        }

        final void setRenderingHint(Graphics2D graphics, RenderingHints.Key key) {
            Object value;
            if (this.hints.get(key) == null && (value = graphics.getRenderingHint(key)) != null) {
                this.hints.put(key, value);
            }
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public boolean isMajorTick() {
            return this.iterator.isMajorTick();
        }

        public double currentPosition() {
            return this.iterator.currentPosition();
        }

        public double currentValue() {
            return this.iterator.currentValue();
        }

        public Point2D currentPosition(Point2D dest) {
            double position = this.currentPosition() - this.minimum;
            double x = position * this.scaleX + Axis2D.this.getX1();
            double y = position * this.scaleY + Axis2D.this.getY1();
            this.ensureValid();
            if (dest != null) {
                dest.setLocation(x, y);
                return dest;
            }
            return new Point2D.Float((float)x, (float)y);
        }

        public Line2D currentTick(Line2D dest) {
            boolean isMajorTick = this.isMajorTick();
            double position = this.currentPosition() - this.minimum;
            double x = position * this.scaleX + Axis2D.this.getX1();
            double y = position * this.scaleY + Axis2D.this.getY1();
            double s1 = isMajorTick ? (double)Axis2D.this.tickStart : (double)Axis2D.this.subTickStart;
            double s2 = isMajorTick ? (double)Axis2D.this.tickEnd : (double)Axis2D.this.subTickEnd;
            double x1 = x + this.tickX * s1;
            double y1 = y + this.tickY * s1;
            double x2 = x + this.tickX * s2;
            double y2 = y + this.tickY * s2;
            this.ensureValid();
            if (dest != null) {
                dest.setLine(x1, y1, x2, y2);
                return dest;
            }
            return new Line2D.Float((float)x1, (float)y1, (float)x2, (float)y2);
        }

        public String currentLabel() {
            if (this.label == null) {
                this.label = this.iterator.currentLabel();
            }
            return this.label;
        }

        public GlyphVector currentLabelGlyphs() {
            String label;
            if (this.glyphs == null && (label = this.currentLabel()) != null) {
                this.glyphs = this.getTickFont().createGlyphVector(this.getFontRenderContext(), label);
            }
            return this.glyphs;
        }

        public Rectangle2D currentLabelBounds() {
            GlyphVector glyphs = this.currentLabelGlyphs();
            if (glyphs == null) {
                return null;
            }
            Rectangle2D bounds = glyphs.getVisualBounds();
            double height = bounds.getHeight();
            double width = bounds.getWidth();
            double tickStart = 0.5 * height - (double)Math.min(Axis2D.this.tickStart, 0.0f);
            double position = this.currentPosition() - this.minimum;
            double x = position * this.scaleX + Axis2D.this.getX1();
            double y = position * this.scaleY + Axis2D.this.getY1();
            bounds.setRect(x - (1.0 + this.tickX) * (0.5 * width) - this.tickX * tickStart, y + (1.0 - this.tickY) * (0.5 * height) - this.tickY * tickStart - height, width, height);
            this.ensureValid();
            return bounds;
        }

        private Font getTickFont() {
            if (this.font == null) {
                Object candidate = this.hints.get(Graduation.TICK_LABEL_FONT);
                this.font = candidate instanceof Font ? (Font)candidate : Axis2D.this.getDefaultFont();
            }
            return this.font;
        }

        final Font getTitleFont() {
            Object candidate = this.hints.get(Graduation.AXIS_TITLE_FONT);
            if (candidate instanceof Font) {
                return (Font)candidate;
            }
            Font font = this.getTickFont();
            return font.deriveFont(1, font.getSize2D() * 1.3333334f);
        }

        final Rectangle2D centerAxisLabel(Rectangle2D bounds, AffineTransform toRotate, Dimension2D maximumSize) {
            double height = bounds.getHeight();
            double width = bounds.getWidth();
            double tx = 0.0;
            double ty = height + Math.abs(maximumSize.getWidth() * this.tickX) + Math.abs(maximumSize.getHeight() * this.tickY);
            double x1 = Axis2D.this.getX1();
            double y1 = Axis2D.this.getY1();
            double x2 = Axis2D.this.getX2();
            double y2 = Axis2D.this.getY2();
            double ux = x2 - x1;
            double uy = y2 - y1;
            double ul = Math.sqrt(ux * ux + uy * uy);
            double x = 0.5 * (x1 + x2);
            double y = 0.5 * (y1 + y2);
            x += (ux /= ul) * 0.0;
            y += (uy /= ul) * 0.0;
            double anchorX = x += (uy *= (double)Axis2D.this.relativeCCW) * ty;
            double anchorY = y -= (ux *= (double)Axis2D.this.relativeCCW) * ty;
            if (toRotate == null) {
                y += 0.5 * height * (1.0 - ux);
                x -= 0.5 * width * (1.0 - uy);
            } else {
                if (ux < 0.0) {
                    ux = -ux;
                    uy = -uy;
                    y += height;
                }
                x -= 0.5 * width;
                toRotate.rotate(Math.atan2(uy, ux), anchorX, anchorY);
            }
            bounds.setRect(x, y - height, width, height);
            this.ensureValid();
            return bounds;
        }

        public void next() {
            this.label = null;
            this.glyphs = null;
            this.iterator.next();
        }

        public void nextMajor() {
            this.label = null;
            this.glyphs = null;
            this.iterator.nextMajor();
        }

        public void rewind() {
            this.label = null;
            this.glyphs = null;
            this.iterator.rewind();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh() {
            Axis2D axis2D = Axis2D.this;
            synchronized (axis2D) {
                this.label = null;
                this.glyphs = null;
                Graduation graduation = Axis2D.this.getGraduation();
                double dx = Axis2D.this.getX2() - Axis2D.this.getX1();
                double dy = Axis2D.this.getY2() - Axis2D.this.getY1();
                double range = graduation.getRange();
                double length = Math.sqrt(dx * dx + dy * dy);
                this.hints.put(Graduation.VISUAL_AXIS_LENGTH, new Double(length));
                this.scaleX = dx / range;
                this.scaleY = dy / range;
                this.tickX = -dy / length * (double)Axis2D.this.relativeCCW;
                this.tickY = dx / length * (double)Axis2D.this.relativeCCW;
                this.minimum = graduation.getMinimum();
                this.iterator = graduation.getTickIterator(this.hints, this.iterator);
                this.modCount = Axis2D.this.modCount;
            }
        }

        public Locale getLocale() {
            return this.iterator.getLocale();
        }

        final FontRenderContext getFontRenderContext() {
            if (this.fontContext == null) {
                this.fontContext = new FontRenderContext(null, false, false);
            }
            return this.fontContext;
        }

        final void setFontRenderContext(FontRenderContext context) {
            this.fontContext = context;
        }

        final void ensureValid() {
            if (this.modCount != Axis2D.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

