/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.axis;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.geotools.axis.AbstractGraduation;
import org.geotools.axis.TickIterator;

final class DateIterator
implements TickIterator {
    private static final long SEC = 1000L;
    private static final long MIN = 60000L;
    private static final long HRE = 3600000L;
    private static final long DAY = 86400000L;
    private static final long YEAR = 31556952000L;
    private static final long MNT = 2629746000L;
    private static final long[] INTERVAL;
    private static final byte[] ROLL;
    private static final int ROLL_WIDTH = 4;
    private static final int[] FIELD;
    private static final String[] FIELD_NAME;
    private long minimum;
    private long maximum;
    private long increment;
    private float visualLength;
    private float visualTickSpacing;
    private int tickAdd;
    private int tickField;
    private int subTickAdd;
    private int subTickField;
    private long value;
    private long nextTick;
    private long nextSubTick;
    private boolean isMajorTick;
    private long value0;
    private long nextTick0;
    private long nextSubTick0;
    private boolean isMajorTick0;
    private Calendar calendar;
    private final Date date = new Date();
    private transient DateFormat format;
    private transient int dateFormat = -1;
    private transient int timeFormat = -1;
    private transient boolean formatValid;
    private Locale locale;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected DateIterator(TimeZone timezone, Locale locale) {
        if (!$assertionsDisabled && INTERVAL.length * 4 != ROLL.length) {
            throw new AssertionError();
        }
        this.calendar = Calendar.getInstance(timezone, locale);
        this.locale = locale;
    }

    protected void init(long minimum, long maximum, float visualLength, float visualTickSpacing) {
        if (minimum == this.minimum && maximum == this.maximum && visualLength == this.visualLength && visualTickSpacing == this.visualTickSpacing) {
            this.rewind();
            return;
        }
        AbstractGraduation.ensureNonNull("visualLength", visualLength);
        AbstractGraduation.ensureNonNull("visualTickSpacing", visualTickSpacing);
        this.visualLength = visualLength;
        this.visualTickSpacing = visualTickSpacing;
        this.formatValid = false;
        this.minimum = minimum;
        this.maximum = maximum;
        this.increment = Math.round((double)(maximum - minimum) * ((double)visualTickSpacing / (double)visualLength));
        int index = Arrays.binarySearch(INTERVAL, this.increment);
        if (index < 0) {
            if ((index ^= 0xFFFFFFFF) == 0) {
                this.round(14);
                this.findFirstTick();
                return;
            }
            if (index >= INTERVAL.length) {
                this.increment /= 31556952000L;
                this.round(1);
                this.increment *= 31556952000L;
                this.findFirstTick();
                return;
            }
            if (this.increment - INTERVAL[index - 1] < INTERVAL[index] - this.increment) {
                --index;
            }
        }
        this.increment = INTERVAL[index];
        this.tickAdd = ROLL[(index *= 4) + 0];
        this.tickField = ROLL[index + 1];
        this.subTickAdd = ROLL[index + 2];
        this.subTickField = ROLL[index + 3];
        if (this.subTickField == 14) {
            this.subTickAdd *= 10;
        }
        this.findFirstTick();
    }

    private void round(int field) {
        int factor = 1;
        while ((long)factor <= this.increment) {
            factor *= 10;
        }
        if (factor >= 10) {
            factor /= 10;
        }
        this.increment /= (long)factor;
        if (this.increment <= 0L) {
            this.increment = 1L;
        } else if (this.increment >= 3L && this.increment <= 4L) {
            this.increment = 5L;
        } else if (this.increment >= 6L) {
            this.increment = 10L;
        }
        this.increment = Math.max(this.increment * (long)factor, 5L);
        this.tickAdd = (int)this.increment;
        this.subTickAdd = (int)(this.increment / (long)(this.increment == 2L ? 4 : 5));
        this.tickField = field;
        this.subTickField = field;
    }

    private void findFirstTick() {
        this.calendar.clear();
        this.value = this.minimum;
        this.date.setTime(this.value);
        this.calendar.setTime(this.date);
        int offset = this.calendar.getActualMinimum(this.tickField);
        int toRound = this.calendar.get(this.tickField) - offset;
        toRound = toRound / this.tickAdd * this.tickAdd;
        this.calendar.set(this.tickField, toRound + offset);
        DateIterator.truncate(this.calendar, this.tickField);
        this.nextSubTick = this.nextTick = this.calendar.getTime().getTime();
        while (this.nextTick < this.minimum) {
            this.calendar.add(this.tickField, this.tickAdd);
            this.nextTick = this.calendar.getTime().getTime();
        }
        this.date.setTime(this.nextSubTick);
        this.calendar.setTime(this.date);
        while (this.nextSubTick < this.minimum) {
            this.calendar.add(this.subTickField, this.subTickAdd);
            this.nextSubTick = this.calendar.getTime().getTime();
        }
        this.next();
        this.value0 = this.value;
        this.nextTick0 = this.nextTick;
        this.nextSubTick0 = this.nextSubTick;
        this.isMajorTick0 = this.isMajorTick;
        if (!$assertionsDisabled && this.calendar.getTime().getTime() != this.nextSubTick) {
            throw new AssertionError();
        }
    }

    private static void truncate(Calendar calendar, int field) {
        for (int i = 0; i < FIELD.length; ++i) {
            if (FIELD[i] != field) continue;
            calendar.get(field);
            while (++i < FIELD.length) {
                field = FIELD[i];
                calendar.set(field, calendar.getActualMinimum(field));
            }
            break;
        }
    }

    public boolean hasNext() {
        return this.value <= this.maximum;
    }

    public boolean isMajorTick() {
        return this.isMajorTick;
    }

    public double currentPosition() {
        return this.value;
    }

    public double currentValue() {
        return this.value;
    }

    public String currentLabel() {
        if (!this.formatValid) {
            int dateFormat;
            this.date.setTime(this.minimum);
            this.calendar.setTime(this.date);
            int firstDay = this.calendar.get(6);
            int firstYear = this.calendar.get(1);
            this.date.setTime(this.maximum);
            this.calendar.setTime(this.date);
            int lastDay = this.calendar.get(6);
            int lastYear = this.calendar.get(1);
            int n = dateFormat = firstYear == lastYear && firstDay == lastDay ? -1 : 2;
            int timeFormat = this.increment >= 86400000L ? -1 : (this.increment >= 60000L ? 3 : (this.increment >= 1000L ? 2 : 1));
            if (dateFormat != this.dateFormat || timeFormat != this.timeFormat || this.format == null) {
                this.dateFormat = dateFormat;
                this.timeFormat = timeFormat;
                this.format = dateFormat == -1 ? (timeFormat == -1 ? DateFormat.getDateInstance(2, this.locale) : DateFormat.getTimeInstance(timeFormat, this.locale)) : (timeFormat == -1 ? DateFormat.getDateInstance(dateFormat, this.locale) : DateFormat.getDateTimeInstance(dateFormat, timeFormat, this.locale));
                this.format.setCalendar(this.calendar);
            }
            this.formatValid = true;
        }
        this.date.setTime(this.value);
        String label = this.format.format(this.date);
        this.date.setTime(this.nextSubTick);
        this.calendar.setTime(this.date);
        return label;
    }

    public void next() {
        if (!$assertionsDisabled && this.calendar.getTime().getTime() != this.nextSubTick) {
            throw new AssertionError();
        }
        if (this.nextSubTick < this.nextTick) {
            this.isMajorTick = false;
            this.value = this.nextSubTick;
            this.calendar.add(this.subTickField, this.subTickAdd);
            this.nextSubTick = this.calendar.getTime().getTime();
        } else {
            this.nextMajor();
        }
    }

    public void nextMajor() {
        this.isMajorTick = true;
        this.value = this.nextTick;
        this.date.setTime(this.value);
        this.calendar.setTime(this.date);
        this.calendar.add(this.tickField, this.tickAdd);
        DateIterator.truncate(this.calendar, this.tickField);
        this.nextTick = this.calendar.getTime().getTime();
        this.calendar.setTime(this.date);
        this.calendar.add(this.subTickField, this.subTickAdd);
        this.nextSubTick = this.calendar.getTime().getTime();
    }

    public void rewind() {
        this.value = this.value0;
        this.nextTick = this.nextTick0;
        this.nextSubTick = this.nextSubTick0;
        this.isMajorTick = this.isMajorTick0;
        this.date.setTime(this.nextSubTick);
        this.calendar.setTime(this.date);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (!locale.equals(this.locale)) {
            this.calendar = Calendar.getInstance(this.getTimeZone(), locale);
            this.format = null;
            this.formatValid = false;
            this.date.setTime(this.nextSubTick);
            this.calendar.setTime(this.date);
        }
        if (!$assertionsDisabled && this.calendar.getTime().getTime() != this.nextSubTick) {
            throw new AssertionError();
        }
    }

    public TimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    public void setTimeZone(TimeZone timezone) {
        if (!timezone.equals(this.getTimeZone())) {
            this.calendar.setTimeZone(timezone);
            this.format = null;
            this.formatValid = false;
            this.date.setTime(this.nextSubTick);
            this.calendar.setTime(this.date);
        }
        if (!$assertionsDisabled && this.calendar.getTime().getTime() != this.nextSubTick) {
            throw new AssertionError();
        }
    }

    private static String getFieldName(int field) {
        for (int i = 0; i < FIELD.length; ++i) {
            if (FIELD[i] != field) continue;
            return FIELD_NAME[i];
        }
        return String.valueOf(field);
    }

    public String toString() {
        StringWriter buf = new StringWriter();
        PrintWriter out = new PrintWriter(buf);
        DateFormat format = DateFormat.getDateTimeInstance();
        format.setTimeZone(this.calendar.getTimeZone());
        out.print("Minimum      = ");
        out.println(format.format(new Date(this.minimum)));
        out.print("Maximum      = ");
        out.println(format.format(new Date(this.maximum)));
        out.print("Increment    = ");
        out.print((float)this.increment / 8.64E7f);
        out.println(" days");
        out.print("Tick inc.    = ");
        out.print(this.tickAdd);
        out.print(' ');
        out.println(DateIterator.getFieldName(this.tickField));
        out.print("SubTick inc. = ");
        out.print(this.subTickAdd);
        out.print(' ');
        out.println(DateIterator.getFieldName(this.subTickField));
        out.print("Next tick    = ");
        out.println(format.format(new Date(this.nextTick)));
        out.print("Next subtick = ");
        out.println(format.format(new Date(this.nextSubTick)));
        out.flush();
        return buf.toString();
    }

    static {
        $assertionsDisabled = !DateIterator.class.desiredAssertionStatus();
        INTERVAL = new long[]{1000L, 2000L, 5000L, 10000L, 15000L, 20000L, 30000L, 60000L, 120000L, 300000L, 600000L, 900000L, 1200000L, 1800000L, 3600000L, 0x6DDD00L, 10800000L, 14400000L, 21600000L, 28800000L, 43200000L, 86400000L, 172800000L, 259200000L, 604800000L, 1209600000L, 1814400000L, 2629746000L, 5259492000L, 7889238000L, 10518984000L, 15778476000L, 31556952000L, 63113904000L, 94670856000L, 126227808000L, 157784760000L};
        ROLL = new byte[]{1, 13, 25, 14, 2, 13, 50, 14, 5, 13, 1, 13, 10, 13, 2, 13, 15, 13, 5, 13, 20, 13, 5, 13, 30, 13, 5, 13, 1, 12, 10, 13, 2, 12, 30, 13, 5, 12, 1, 12, 10, 12, 2, 12, 15, 12, 5, 12, 20, 12, 5, 12, 30, 12, 5, 12, 1, 11, 15, 12, 2, 11, 30, 12, 3, 11, 30, 12, 4, 11, 1, 11, 6, 11, 1, 11, 8, 11, 2, 11, 12, 11, 2, 11, 1, 5, 4, 11, 2, 5, 6, 11, 3, 5, 12, 11, 7, 5, 1, 5, 14, 5, 2, 5, 21, 5, 7, 5, 1, 2, 7, 5, 2, 2, 14, 5, 3, 2, 14, 5, 4, 2, 1, 2, 6, 2, 1, 2, 1, 1, 2, 2, 2, 1, 4, 2, 3, 1, 6, 2, 4, 1, 1, 1, 5, 1, 1, 1};
        FIELD = new int[]{1, 2, 5, 11, 12, 13, 14};
        FIELD_NAME = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "MILLISECOND"};
    }
}

