/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.axis;

import java.util.Locale;
import org.geotools.axis.NumberIterator;
import org.geotools.resources.XMath;

final class LogarithmicNumberIterator
extends NumberIterator {
    private double scale;
    private double offset;

    protected LogarithmicNumberIterator(Locale locale) {
        super(locale);
    }

    protected void init(double minimum, double maximum, float visualLength, float visualTickSpacing) {
        double logMin = XMath.log10((double)minimum);
        double logMax = XMath.log10((double)maximum);
        super.init(logMin, logMax, visualLength, visualTickSpacing);
        this.scale = (maximum - minimum) / (logMax - logMin);
        this.offset = minimum - this.scale * logMin;
    }

    public double currentPosition() {
        return super.currentPosition() * this.scale + this.offset;
    }

    public double currentValue() {
        return XMath.pow10((double)super.currentValue());
    }
}

