/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.axis;

import java.awt.RenderingHints;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import javax.units.ConversionException;
import javax.units.Converter;
import javax.units.Unit;
import org.geotools.axis.AbstractGraduation;
import org.geotools.axis.NumberIterator;
import org.geotools.axis.TickIterator;

public class NumberGraduation
extends AbstractGraduation {
    private static final long serialVersionUID = -3074504745332240845L;
    private double minimum = 0.0;
    private double maximum = 10.0;

    public NumberGraduation(Unit unit) {
        super(unit);
    }

    public synchronized boolean setMinimum(double value) throws IllegalArgumentException {
        NumberGraduation.ensureFinite("minimum", value);
        double old = this.minimum;
        this.minimum = value;
        Double valueObject = new Double(value);
        this.listenerList.firePropertyChange("minimum", new Double(old), valueObject);
        if (this.maximum < value) {
            old = this.maximum;
            this.maximum = value;
            this.listenerList.firePropertyChange("maximum", new Double(old), valueObject);
            return true;
        }
        return Double.doubleToLongBits(value) != Double.doubleToLongBits(old);
    }

    public synchronized boolean setMaximum(double value) throws IllegalArgumentException {
        NumberGraduation.ensureFinite("maximum", value);
        double old = this.maximum;
        this.maximum = value;
        Double valueObject = new Double(value);
        this.listenerList.firePropertyChange("maximum", new Double(old), valueObject);
        if (this.minimum > value) {
            old = this.minimum;
            this.minimum = value;
            this.listenerList.firePropertyChange("minimum", new Double(old), valueObject);
            return true;
        }
        return Double.doubleToLongBits(value) != Double.doubleToLongBits(old);
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public synchronized double getRange() {
        return this.maximum - this.minimum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRange(double min, double max, Unit unit) {
        Double oldMax;
        Double oldMin;
        NumberGraduation numberGraduation = this;
        synchronized (numberGraduation) {
            oldMin = new Double(this.minimum);
            oldMax = new Double(this.maximum);
            this.minimum = Math.min(min, max);
            this.maximum = Math.max(min, max);
            this.setUnit(unit);
        }
        this.listenerList.firePropertyChange("minimum", oldMin, new Double(min));
        this.listenerList.firePropertyChange("maximum", oldMax, new Double(max));
    }

    public synchronized void setUnit(Unit newUnit) throws ConversionException {
        double min = this.minimum;
        double max = this.maximum;
        Unit unit = this.getUnit();
        if (unit != null && newUnit != null) {
            Converter converter = unit.getConverterTo(newUnit);
            min = converter.convert(min);
            max = converter.convert(max);
        }
        this.setRange(min, max, newUnit);
    }

    public Format getFormat() {
        return NumberFormat.getNumberInstance(this.getLocale());
    }

    public synchronized TickIterator getTickIterator(RenderingHints hints, TickIterator reuse) {
        float visualAxisLength = NumberGraduation.getVisualAxisLength(hints);
        float visualTickSpacing = NumberGraduation.getVisualTickSpacing(hints);
        double minimum = this.minimum;
        double maximum = this.maximum;
        if (!(minimum < maximum)) {
            minimum = (minimum + maximum) * 0.5 - 0.5;
            maximum = minimum + 1.0;
        }
        NumberIterator it = this.getTickIterator(reuse, this.getLocale());
        it.init(minimum, maximum, visualAxisLength, visualTickSpacing);
        return it;
    }

    NumberIterator getTickIterator(TickIterator reuse, Locale locale) {
        if (reuse != null && reuse.getClass().equals(NumberIterator.class)) {
            NumberIterator it = (NumberIterator)reuse;
            it.setLocale(locale);
            return it;
        }
        return new NumberIterator(locale);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            NumberGraduation that = (NumberGraduation)object;
            return Double.doubleToLongBits(this.minimum) == Double.doubleToLongBits(that.minimum) && Double.doubleToLongBits(this.maximum) == Double.doubleToLongBits(that.maximum);
        }
        return false;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.minimum) + 37L * Double.doubleToLongBits(this.maximum);
        return (int)code ^ (int)(code >>> 32) ^ super.hashCode();
    }
}

