/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.headless;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.ProgressListener;

public class ProgressMailer
implements ProgressListener {
    private String description;
    private final Locale locale;
    private final Session session;
    private final Address[] address;
    private long timeInterval = 10800000L;
    private long nextTime;
    private volatile boolean canceled;

    public ProgressMailer(String host, String address) throws AddressException {
        this(Session.getDefaultInstance((Properties)ProgressMailer.properties(host)), (Address[])new InternetAddress[]{new InternetAddress(address)});
    }

    public ProgressMailer(Session session, Address[] address) {
        this.session = session;
        this.address = address;
        this.locale = Locale.getDefault();
        this.nextTime = System.currentTimeMillis();
    }

    private static final Properties properties(String host) {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", host);
        return props;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public synchronized void setTimeInterval(long interval) {
        this.timeInterval = interval;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized void setDescription(String description) {
        this.description = description;
    }

    private void send(String method, int subjectKey, String messageText) {
        try {
            MimeMessage message = new MimeMessage(this.session);
            message.setFrom();
            message.setRecipients(Message.RecipientType.TO, this.address);
            message.setSubject(Vocabulary.getResources((Locale)this.locale).getString(subjectKey));
            message.setSentDate(new Date());
            message.setText(messageText);
            Transport.send((Message)message);
        }
        catch (MessagingException exception) {
            LogRecord warning = new LogRecord(Level.WARNING, "CATCH " + Utilities.getShortClassName((Object)((Object)exception)));
            warning.setSourceClassName(this.getClass().getName());
            warning.setSourceMethodName(method);
            warning.setThrown(exception);
            Logger.getLogger("org.geotools.gui.progress").log(warning);
        }
    }

    private void send(String method, float percent) {
        Runtime system = Runtime.getRuntime();
        float MEMORY_UNIT = 1048576.0f;
        float freeMemory = (float)system.freeMemory() / 1048576.0f;
        float totalMemory = (float)system.totalMemory() / 1048576.0f;
        Vocabulary resources = Vocabulary.getResources((Locale)this.locale);
        NumberFormat format = NumberFormat.getPercentInstance(this.locale);
        StringBuffer buffer = new StringBuffer(this.description != null ? this.description : resources.getString(134));
        buffer.append(": ");
        format.format(percent / 100.0f, buffer, new FieldPosition(0));
        buffer.append('\n');
        buffer.append(resources.getString(102, (Object)new Float(totalMemory)));
        buffer.append('\n');
        buffer.append(resources.getString(103, (Object)new Float(1.0f - freeMemory / totalMemory)));
        buffer.append('\n');
        this.send(method, 134, buffer.toString());
    }

    public synchronized void started() {
        this.send("started", 0.0f);
    }

    public synchronized void progress(float percent) {
        long time = System.currentTimeMillis();
        if (time > this.nextTime) {
            this.nextTime = time + this.timeInterval;
            if (percent < 1.0f) {
                percent = 1.0f;
            }
            if (percent > 99.0f) {
                percent = 99.0f;
            }
            this.send("progress", percent);
        }
    }

    public synchronized void complete() {
        this.send("complete", 100.0f);
    }

    public void dispose() {
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public synchronized void warningOccurred(String source, String margin, String warning) {
        StringBuffer buffer = new StringBuffer();
        if (source != null) {
            buffer.append(source);
            if (margin != null) {
                buffer.append(" (");
                buffer.append(margin);
                buffer.append(')');
            }
            buffer.append(": ");
        } else if (margin != null) {
            buffer.append(margin);
            buffer.append(": ");
        }
        buffer.append(warning);
        this.send("warningOccurred", 186, buffer.toString());
    }

    public synchronized void exceptionOccurred(Throwable exception) {
        CharArrayWriter buffer = new CharArrayWriter();
        exception.printStackTrace(new PrintWriter(buffer));
        this.send("exceptionOccurred", 44, buffer.toString());
    }
}

