/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.headless;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.BreakIterator;
import java.text.NumberFormat;
import org.geotools.resources.Arguments;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.ProgressListener;

public class ProgressPrinter
implements ProgressListener {
    private String description;
    private final PrintWriter out;
    private final boolean CR_supported;
    private final int maxLength;
    private int lastLength;
    private int percentPosition = -1;
    private float lastPercent = -1.0f;
    private NumberFormat format;
    private BreakIterator breaker;
    private boolean hasPrintedWarning;
    private String lastSource;
    private volatile boolean canceled;

    public ProgressPrinter() {
        this(new PrintWriter(Arguments.getWriter((OutputStream)System.out)));
    }

    public ProgressPrinter(PrintWriter out) {
        this(out, 80);
    }

    public ProgressPrinter(PrintWriter out, int maxLength) {
        this.out = out;
        this.maxLength = maxLength;
        String lineSeparator = System.getProperty("line.separator", "\n");
        this.CR_supported = lineSeparator.equals("\r\n") || lineSeparator.equals("\n");
    }

    private void carriageReturn(int length) {
        if (this.CR_supported && length < this.maxLength) {
            for (int i = length; i < this.lastLength; ++i) {
                this.out.print(' ');
            }
            this.out.print('\r');
            this.out.flush();
        } else {
            this.out.println();
        }
        this.lastLength = length;
    }

    private void completeBar(float percent) {
        int end = (int)(percent / 100.0f * (float)(this.maxLength - 2 - this.percentPosition));
        while (this.lastLength < end) {
            this.out.print('.');
            ++this.lastLength;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized void setDescription(String description) {
        this.description = description;
    }

    public synchronized void started() {
        int length = 0;
        if (this.description != null) {
            this.out.print(this.description);
            length = this.description.length();
        }
        if (this.CR_supported) {
            this.carriageReturn(length);
        }
        this.out.flush();
        this.percentPosition = length;
        this.lastPercent = -1.0f;
        this.lastSource = null;
        this.hasPrintedWarning = false;
    }

    public synchronized void progress(float percent) {
        if (percent < 0.0f) {
            percent = 0.0f;
        }
        if (percent > 100.0f) {
            percent = 100.0f;
        }
        if (this.CR_supported) {
            if (percent != this.lastPercent) {
                if (this.format == null) {
                    this.format = NumberFormat.getPercentInstance();
                }
                String text = this.format.format((double)percent / 100.0);
                int length = text.length();
                this.percentPosition = 0;
                if (this.description != null) {
                    this.out.print(this.description);
                    this.out.print(' ');
                    this.percentPosition = this.description.length();
                    length += this.percentPosition + 1;
                }
                this.out.print('(');
                this.out.print(text);
                this.out.print(')');
                this.carriageReturn(length += 2);
                this.lastPercent = percent;
            }
        } else {
            this.completeBar(percent);
            this.lastPercent = percent;
            this.out.flush();
        }
    }

    public synchronized void complete() {
        if (!this.CR_supported) {
            this.completeBar(100.0f);
        }
        this.carriageReturn(0);
        this.out.flush();
    }

    public void dispose() {
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public synchronized void warningOccurred(String source, String margin, String warning) {
        int nextEnd;
        int start;
        String prefix;
        this.carriageReturn(0);
        if (!this.hasPrintedWarning) {
            this.printInBox(Vocabulary.format((int)186));
            this.hasPrintedWarning = true;
        }
        if (!Utilities.equals((Object)source, (Object)this.lastSource)) {
            this.out.println();
            this.out.println(source != null ? source : Vocabulary.format((int)178));
            this.lastSource = source;
        }
        String second = prefix = "    ";
        if (margin != null && (margin = ProgressPrinter.trim(margin)).length() != 0) {
            StringBuffer buffer = new StringBuffer(prefix);
            buffer.append('(');
            buffer.append(margin);
            buffer.append(") ");
            prefix = buffer.toString();
            buffer.setLength(0);
            second = Utilities.spaces((int)prefix.length());
        }
        int width = this.maxLength - prefix.length() - 1;
        if (this.breaker == null) {
            this.breaker = BreakIterator.getLineInstance();
        }
        this.breaker.setText(warning);
        int end = start = this.breaker.first();
        while ((nextEnd = this.breaker.next()) != -1) {
            while (nextEnd - start > width) {
                if (end <= start) {
                    end = Math.min(nextEnd, start + width);
                }
                this.out.print(prefix);
                this.out.println(warning.substring(start, end));
                prefix = second;
                start = end;
            }
            end = Math.min(nextEnd, start + width);
        }
        if (end > start) {
            this.out.print(prefix);
            this.out.println(warning.substring(start, end));
        }
        if (!this.CR_supported && this.description != null) {
            this.out.print(this.description);
            this.completeBar(this.lastPercent);
        }
        this.out.flush();
    }

    public synchronized void exceptionOccurred(Throwable exception) {
        this.carriageReturn(0);
        this.printInBox(Vocabulary.format((int)44));
        exception.printStackTrace(this.out);
        this.hasPrintedWarning = false;
        this.out.flush();
    }

    private static String trim(String margin) {
        int lower;
        margin = margin.trim();
        int upper = margin.length();
        for (lower = 0; lower < upper && margin.charAt(lower + 0) == '('; ++lower) {
        }
        while (lower < upper && margin.charAt(upper - 1) == ')') {
            --upper;
        }
        return margin.substring(lower, upper);
    }

    private void printInBox(String text) {
        int length = text.length();
        block5: for (int pass = -2; pass <= 2; ++pass) {
            switch (Math.abs(pass)) {
                case 2: {
                    int j;
                    for (j = -10; j < length; ++j) {
                        this.out.print('*');
                    }
                    this.out.println();
                    continue block5;
                }
                case 1: {
                    int j;
                    this.out.print("**");
                    for (j = -6; j < length; ++j) {
                        this.out.print(' ');
                    }
                    this.out.println("**");
                    continue block5;
                }
                case 0: {
                    this.out.print("**   ");
                    this.out.print(text);
                    this.out.println("   **");
                }
            }
        }
    }
}

