/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.media.jai.JAI;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ListDataListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.geotools.gui.swing.RegisteredOperationBrowser;
import org.geotools.resources.Arguments;
import org.geotools.resources.SwingUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Vocabulary;

public class About
extends JPanel {
    private static final float HEAP_SIZE_UNIT = 1048576.0f;
    private static final String TIMESTAMP = "Implementation-Date";
    private final ThreadList updater;
    private final Vocabulary resources;
    static /* synthetic */ Class class$javax$imageio$spi$ImageWriterSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageReaderSpi;

    public About() {
        this((Object)"org/geotools/resources/logo/Geotools.png", About.class, null);
    }

    public About(Object logo, Class application, ThreadGroup tasks) {
        this(logo, About.getAttributes(application), application.getClassLoader(), tasks);
    }

    public About(Object logo, Attributes attributes, ThreadGroup tasks) {
        this(logo, attributes, null, tasks);
    }

    private About(Object logo, Attributes attributes, ClassLoader loader, ThreadGroup tasks) {
        super(new GridBagLayout());
        Locale locale = About.getDefaultLocale();
        this.resources = Vocabulary.getResources((Locale)locale);
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        Runtime system = Runtime.getRuntime();
        system.gc();
        float freeMemory = (float)system.freeMemory() / 1048576.0f;
        float totalMemory = (float)system.totalMemory() / 1048576.0f;
        String application = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        String version = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        String vendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        try {
            String dateString = attributes.getValue(TIMESTAMP);
            if (dateString != null) {
                Date date = About.getDateFormat().parse(dateString);
                DateFormat format = DateFormat.getDateInstance(1);
                if (version != null && version.trim().length() != 0) {
                    StringBuffer buffer = new StringBuffer(version);
                    buffer.append(" (");
                    buffer = format.format(date, buffer, new FieldPosition(0));
                    buffer.append(')');
                    version = buffer.toString();
                } else {
                    version = format.format(date);
                }
            }
        }
        catch (ParseException exception) {
            Utilities.unexpectedException((String)"org.geotools.gui.swing", (String)"About", (String)"<init>", (Throwable)exception);
        }
        GridBagConstraints gc = new GridBagConstraints();
        if (logo != null) {
            JComponent title;
            if (logo instanceof JComponent) {
                title = (JComponent)logo;
            } else if (logo instanceof Icon) {
                title = new JLabel((Icon)logo);
            } else {
                String text = String.valueOf(logo);
                URL url = loader.getResource(text);
                if (url == null) {
                    JLabel label = new JLabel(text);
                    label.setHorizontalAlignment(0);
                    label.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
                    title = label;
                } else {
                    title = new JLabel(new ImageIcon(url));
                }
            }
            title.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0), BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), title.getBorder())));
            gc.gridx = 0;
            gc.gridy = 0;
            gc.weightx = 1.0;
            gc.insets.top = 9;
            this.add((Component)title, gc);
        }
        JTabbedPane tabs = new JTabbedPane();
        JLabel totalMemoryLabel = new JLabel(this.resources.getString(102, (Object)new Float(totalMemory)));
        JLabel percentUsedLabel = new JLabel(this.resources.getString(103, (Object)new Float(1.0f - freeMemory / totalMemory)));
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add((Component)tabs, gc);
        JPanel pane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridy = 0;
        c.insets.top = 12;
        pane.add((Component)new JLabel(application), c);
        ++c.gridy;
        c.insets.top = 0;
        pane.add((Component)new JLabel(this.resources.getString(183, (Object)version)), c);
        ++c.gridy;
        pane.add((Component)new JLabel(vendor), c);
        ++c.gridy;
        c.insets.top = 6;
        pane.add((Component)new JLabel(this.resources.getString(82, (Object)System.getProperty("java.version"))), c);
        ++c.gridy;
        c.insets.top = 0;
        pane.add((Component)new JLabel(this.resources.getString(81, (Object)System.getProperty("java.vendor"))), c);
        ++c.gridy;
        c.insets.top = 6;
        pane.add((Component)new JLabel(this.resources.getString(121, (Object)System.getProperty("os.name"))), c);
        ++c.gridy;
        c.insets.top = 0;
        pane.add((Component)new JLabel(this.resources.getString(122, (Object)System.getProperty("os.version"), (Object)System.getProperty("os.arch"))), c);
        ++c.gridy;
        c.insets.top = 12;
        pane.add((Component)new JLabel(this.resources.getString(164, (Object)new Float((float)JAI.getDefaultInstance().getTileCache().getMemoryCapacity() / 1048576.0f))), c);
        ++c.gridy;
        c.insets.top = 0;
        pane.add((Component)totalMemoryLabel, c);
        ++c.gridy;
        c.insets.bottom = 12;
        pane.add((Component)percentUsedLabel, c);
        tabs.addTab(this.resources.getString(160), pane);
        if (tasks != null) {
            this.updater = new ThreadList(tasks, totalMemoryLabel, percentUsedLabel, this.resources);
            pane = new JPanel(new BorderLayout());
            JList list = new JList(this.updater);
            pane.add((Component)new JLabel(this.resources.getString(144)), "North");
            pane.add((Component)new JScrollPane(list), "Center");
            pane.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
            tabs.addTab(this.resources.getString(161), pane);
        } else {
            this.updater = null;
        }
        StringBuffer buffer = new StringBuffer();
        TreeMap<String, DefaultMutableTreeNode> mimes = new TreeMap<String, DefaultMutableTreeNode>();
        boolean writer = false;
        do {
            Class category;
            int titleKey;
            if (writer) {
                titleKey = 38;
                category = class$javax$imageio$spi$ImageWriterSpi == null ? About.class$("javax.imageio.spi.ImageWriterSpi") : class$javax$imageio$spi$ImageWriterSpi;
            } else {
                titleKey = 29;
                category = class$javax$imageio$spi$ImageReaderSpi == null ? About.class$("javax.imageio.spi.ImageReaderSpi") : class$javax$imageio$spi$ImageReaderSpi;
            }
            String title = this.resources.getString(titleKey);
            Iterator it = IIORegistry.getDefaultInstance().getServiceProviders(category, true);
            while (it.hasNext()) {
                ImageReaderWriterSpi spi = (ImageReaderWriterSpi)it.next();
                String name = spi.getDescription(locale);
                String[] mimeTypes = spi.getMIMETypes();
                About.patchMimes(mimeTypes);
                for (int i = 0; i < mimeTypes.length; ++i) {
                    String mimeType = mimeTypes[i];
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)mimes.get(mimeType);
                    if (child == null) {
                        child = new DefaultMutableTreeNode(mimeType);
                        mimes.put(mimeType, child);
                    }
                    child.add(new DefaultMutableTreeNode(name, false));
                }
                if (title == null || mimeTypes.length == 0) continue;
                if (buffer.length() != 0) {
                    buffer.append(" / ");
                }
                buffer.append(title);
                title = null;
            }
        } while (writer = !writer);
        String title = buffer.toString();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(title);
        Iterator it = mimes.values().iterator();
        while (it.hasNext()) {
            root.add((DefaultMutableTreeNode)it.next());
        }
        JComponent tree = new JTree(root);
        tree.setBorder(BorderFactory.createEmptyBorder(6, 6, 0, 0));
        tree = new JScrollPane(tree);
        tabs.addTab(this.resources.getString(71), About.setup(tree));
        RegisteredOperationBrowser tree2 = new RegisteredOperationBrowser();
        tabs.addTab(this.resources.getString(117), About.setup(tree2));
    }

    private static JComponent setup(JComponent component) {
        component.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), component.getBorder()));
        component.setPreferredSize(new Dimension(200, 200));
        return component;
    }

    private static void patchMimes(String[] mimes) {
        for (int i = 0; i < mimes.length; ++i) {
            String name = mimes[i].trim();
            if (name.length() == 0) {
                name = "(raw)";
            }
            mimes[i] = name;
        }
    }

    private static Attributes getAttributes(Class classe) {
        InputStream stream = classe.getClassLoader().getResourceAsStream("META-INF/Manifest.mf");
        if (stream != null) {
            try {
                int index;
                Manifest manifest = new Manifest(stream);
                stream.close();
                String name = classe.getName().replace('.', '/');
                while ((index = name.lastIndexOf(47)) >= 0) {
                    Attributes attributes = manifest.getAttributes(name.substring(0, index + 1));
                    if (attributes != null) {
                        return attributes;
                    }
                    name = name.substring(0, index);
                }
                return manifest.getMainAttributes();
            }
            catch (IOException exception) {
                Utilities.unexpectedException((String)"org.geotools.gui.swing", (String)"About", (String)"getAttributes", (Throwable)exception);
            }
        }
        return new Attributes();
    }

    private static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CANADA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showDialog(Component owner) {
        try {
            this.start();
            SwingUtilities.showMessageDialog((Component)owner, (Object)this, (String)this.resources.getMenuLabel(0), (int)-1);
        }
        finally {
            this.stop();
        }
    }

    protected void start() {
        ThreadList updater = this.updater;
        if (updater != null) {
            updater.start();
        }
    }

    protected void stop() {
        ThreadList updater = this.updater;
        if (updater != null) {
            updater.worker = null;
        }
    }

    public static void touch(Attributes attributes) {
        attributes.putValue(TIMESTAMP, About.getDateFormat().format(new Date()));
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        Locale.setDefault(arguments.locale);
        new About().showDialog(null);
        System.exit(0);
    }

    private static final class ThreadList
    extends AbstractListModel
    implements Runnable {
        public transient Thread worker;
        private final ThreadGroup tasks;
        private String[] names = new String[0];
        private final JLabel totalMemory;
        private final JLabel percentUsed;
        private final Vocabulary resources;

        public ThreadList(ThreadGroup tasks, JLabel totalMemory, JLabel percentUsed, Vocabulary resources) {
            this.tasks = tasks;
            this.totalMemory = totalMemory;
            this.percentUsed = percentUsed;
            this.resources = resources;
        }

        public int getSize() {
            return this.names.length;
        }

        public Object getElementAt(int index) {
            return this.names[index];
        }

        public synchronized void addListDataListener(ListDataListener listener) {
            super.addListDataListener(listener);
        }

        public synchronized void start() {
            if (this.worker == null) {
                this.worker = new Thread((Runnable)this, this.resources.getString(0));
                this.worker.setPriority(1);
                this.worker.setDaemon(true);
                this.worker.start();
            }
        }

        public synchronized void run() {
            String oldTotalMemory = null;
            String oldPercentUsed = null;
            while (this.worker == Thread.currentThread() && this.listenerList.getListenerCount() != 0) {
                Runtime system = Runtime.getRuntime();
                float freeMemoryN = (float)system.freeMemory() / 1048576.0f;
                float totalMemoryN = (float)system.totalMemory() / 1048576.0f;
                String totalMemoryText = this.resources.getString(102, (Object)new Float(totalMemoryN));
                String percentUsedText = this.resources.getString(103, (Object)new Float(1.0f - freeMemoryN / totalMemoryN));
                Thread[] threadArray = new Thread[this.tasks.activeCount()];
                Object[] threadNames = new String[this.tasks.enumerate(threadArray)];
                int c = 0;
                for (int i = 0; i < threadNames.length; ++i) {
                    if (threadArray[i] == this.worker) continue;
                    threadNames[c++] = threadArray[i].getName();
                }
                if (Arrays.equals(this.names, threadNames = (String[])XArray.resize((Object[])threadNames, (int)c))) {
                    threadNames = null;
                }
                if (totalMemoryText.equals(oldTotalMemory)) {
                    totalMemoryText = null;
                } else {
                    oldTotalMemory = totalMemoryText;
                }
                if (percentUsedText.equals(oldPercentUsed)) {
                    percentUsedText = null;
                } else {
                    oldPercentUsed = percentUsedText;
                }
                if (threadNames != null || totalMemoryText != null || percentUsedText != null) {
                    Object[] names = threadNames;
                    String totalMemory = totalMemoryText;
                    String percentUsed = percentUsedText;
                    EventQueue.invokeLater(new Runnable(this, (String[])names, totalMemory, percentUsed){
                        private final /* synthetic */ String[] val$names;
                        private final /* synthetic */ String val$totalMemory;
                        private final /* synthetic */ String val$percentUsed;
                        private final /* synthetic */ ThreadList this$0;
                        {
                            this.this$0 = this$0;
                            this.val$names = val$names;
                            this.val$totalMemory = val$totalMemory;
                            this.val$percentUsed = val$percentUsed;
                        }

                        public void run() {
                            ThreadList.access$000(this.this$0, this.val$names, this.val$totalMemory, this.val$percentUsed);
                        }
                    });
                }
                try {
                    this.wait(4000L);
                }
                catch (InterruptedException exception) {}
            }
            this.worker = null;
        }

        private synchronized void update(String[] newNames, String totalMemory, String percentUsed) {
            if (newNames != null) {
                int count = Math.max(this.names.length, newNames.length);
                this.names = newNames;
                this.fireContentsChanged(this, 0, count - 1);
            }
            if (totalMemory != null) {
                this.totalMemory.setText(totalMemory);
            }
            if (percentUsed != null) {
                this.percentUsed.setText(percentUsed);
            }
        }

        static /* synthetic */ void access$000(ThreadList x0, String[] x1, String x2, String x3) {
            x0.update(x1, x2, x3);
        }
    }
}

