/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import java.io.Serializable;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class AutoScroll
implements ChangeListener,
Serializable {
    private static final long serialVersionUID = 8932928616386789102L;
    private final BoundedRangeModel model;
    private int value;
    private int extent;
    private int maximum;

    public AutoScroll(BoundedRangeModel model) {
        this.model = model;
        model.addChangeListener(this);
        this.sync();
    }

    public void dispose() {
        this.model.removeChangeListener(this);
    }

    private void sync() {
        this.value = this.model.getValue();
        this.extent = this.model.getExtent();
        this.maximum = this.model.getMaximum();
    }

    public void stateChanged(ChangeEvent event) {
        int oldValue = this.value;
        int oldExtent = this.extent;
        int oldMaximum = this.maximum;
        this.sync();
        if (oldValue + oldExtent >= oldMaximum && this.value == oldValue && this.extent >= oldExtent && this.maximum > oldMaximum) {
            this.model.setValue(oldValue + (this.maximum - oldMaximum));
        }
    }
}

