/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.geotools.gui.swing.IconFactory;
import org.geotools.gui.swing.ListElement;
import org.geotools.resources.SwingUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;

public class DisjointLists
extends JPanel {
    private final JList left;
    private final JList right;
    private boolean autoSort = true;
    static /* synthetic */ Class class$org$geotools$gui$swing$DisjointLists;

    public DisjointLists() {
        super(new GridBagLayout());
        ArrayList choices = new ArrayList();
        this.left = new JList(new Model(choices));
        this.right = new JList(new Model(choices));
        JScrollPane leftPane = new JScrollPane(this.left);
        JScrollPane rightPane = new JScrollPane(this.right);
        Dimension size = new Dimension(160, 200);
        leftPane.setPreferredSize(size);
        rightPane.setPreferredSize(size);
        JButton add = DisjointLists.getButton("StepForward", ">", "Add selected elements");
        JButton remove = DisjointLists.getButton("StepBack", "<", "Remove selected elements");
        JButton addAll = DisjointLists.getButton("FastForward", ">>", "Add all");
        JButton removeAll = DisjointLists.getButton("Rewind", "<<", "Remove all");
        add.addActionListener(new Action(this.left, this.right, false));
        remove.addActionListener(new Action(this.right, this.left, false));
        addAll.addActionListener(new Action(this.left, this.right, true));
        removeAll.addActionListener(new Action(this.right, this.left, true));
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 4;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        c.gridx = 0;
        this.add((Component)leftPane, c);
        c.gridx = 2;
        this.add((Component)rightPane, c);
        c.insets.right = 9;
        c.insets.left = 9;
        c.gridx = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.fill = 2;
        c.gridy = 0;
        c.anchor = 15;
        this.add((Component)add, c);
        c.gridy = 3;
        c.anchor = 11;
        this.add((Component)removeAll, c);
        c.gridy = 2;
        c.weighty = 0.0;
        this.add((Component)addAll, c);
        c.gridy = 1;
        c.insets.bottom = 9;
        this.add((Component)remove, c);
    }

    private static JButton getButton(String image, String fallback, String description) {
        image = "toolbarButtonGraphics/media/" + image + "16.gif";
        return IconFactory.DEFAULT.getButton(image, description, fallback);
    }

    public boolean isAutoSortEnabled() {
        return this.autoSort;
    }

    public void setAutoSortEnabled(boolean autoSort) {
        if (autoSort != this.autoSort) {
            this.autoSort = autoSort;
            if (autoSort) {
                ArrayList elements = new ArrayList(((Model)this.left.getModel()).choices);
                this.clear();
                this.addElements(elements);
            }
            this.firePropertyChange("autoSort", !autoSort, autoSort);
        }
    }

    public void clear() {
        ((Model)this.left.getModel()).clear();
        ((Model)this.right.getModel()).clear();
    }

    public void addElements(Collection items) {
        this.addElements(items.toArray());
    }

    public void addElements(Object[] items) {
        Locale locale;
        try {
            locale = this.getLocale();
        }
        catch (IllegalComponentStateException e) {
            locale = DisjointLists.getDefaultLocale();
        }
        ArrayList<Object> list = new ArrayList<Object>(items.length);
        for (int i = 0; i < items.length; ++i) {
            Object candidate = items[i];
            if (!(candidate instanceof String)) {
                candidate = new ListElement(candidate, locale);
            }
            list.add(candidate);
        }
        Model left = (Model)this.left.getModel();
        Model right = (Model)this.right.getModel();
        if (this.autoSort) {
            list.addAll(left.choices);
            Collections.sort(list);
            left.clear();
            right.clear();
        }
        left.addAll(list);
    }

    public Collection getElements(boolean selected) {
        return ((Model)(selected ? this.right : this.left).getModel()).getElements();
    }

    public Collection getSelectedElements() {
        return this.getElements(true);
    }

    public void selectElements(Collection selected) {
        Model source = (Model)this.left.getModel();
        Model target = (Model)this.right.getModel();
        int[] indices = new int[Math.min(selected.size(), source.choices.size())];
        int indice = 0;
        int count = 0;
        Iterator it = source.choices.iterator();
        while (it.hasNext()) {
            if (selected.contains(ListElement.unwrap(it.next()))) {
                indices[count++] = indice;
            }
            ++indice;
        }
        indices = XArray.resize((int[])indices, (int)count);
        target.move(source, indices);
    }

    public void setFont(Font font) {
        if (this.left != null) {
            this.left.setFont(font);
        }
        if (this.right != null) {
            this.right.setFont(font);
        }
        super.setFont(font);
    }

    public boolean showDialog(Component owner, String title) {
        return SwingUtilities.showOptionDialog((Component)owner, (Object)this, (String)title);
    }

    public static void main(String[] args) {
        DisjointLists list = new DisjointLists();
        list.addElements(Locale.getAvailableLocales());
        list.showDialog(null, Utilities.getShortClassName((Object)list));
        System.out.println(list.getSelectedElements());
    }

    private static final class Action
    implements ActionListener {
        private final JList source;
        private final JList target;
        private final boolean all;

        public Action(JList source, JList target, boolean all) {
            this.source = source;
            this.target = target;
            this.all = all;
        }

        public void actionPerformed(ActionEvent event) {
            Model source = (Model)this.source.getModel();
            Model target = (Model)this.target.getModel();
            if (this.all) {
                target.move(source, 0, source.getSize());
                return;
            }
            int[] indices = this.source.getSelectedIndices();
            target.move(source, indices);
        }
    }

    private static final class Model
    extends AbstractListModel {
        final List choices;
        private int[] visibles = new int[12];
        private int size;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Model(List choices) {
            this.choices = choices;
        }

        private boolean isSorted() {
            for (int i = 1; i < this.size; ++i) {
                if (this.visibles[i] > this.visibles[i - 1]) continue;
                return false;
            }
            return true;
        }

        private static int search(int[] array, int lower, int upper, int value) {
            while (lower < upper && value > array[lower]) {
                ++lower;
            }
            return lower;
        }

        public int getSize() {
            if (!($assertionsDisabled || this.size >= 0 && this.size <= this.choices.size())) {
                throw new AssertionError(this.size);
            }
            return this.size;
        }

        public Collection getElements() {
            Object[] list = new Object[this.getSize()];
            for (int i = 0; i < list.length; ++i) {
                list[i] = ListElement.unwrap(this.getElementAt(i));
            }
            return Arrays.asList(list);
        }

        public Object getElementAt(int index) {
            if (!($assertionsDisabled || index >= 0 && index < this.size)) {
                throw new AssertionError(index);
            }
            return this.choices.get(this.visibles[index]);
        }

        private void ensureCapacity(int capacity) {
            if (this.visibles.length < capacity) {
                this.visibles = XArray.resize((int[])this.visibles, (int)Math.max(this.size * 2, capacity));
            }
        }

        private void hide(int lower, int upper) {
            if (lower != upper) {
                System.arraycopy(this.visibles, upper, this.visibles, lower, this.size - upper);
                this.size -= upper - lower;
                this.fireIntervalRemoved(this, lower, upper - 1);
            }
            if (!$assertionsDisabled && !this.isSorted()) {
                throw new AssertionError();
            }
        }

        public void move(Model source, int lower, int upper) {
            if (!($assertionsDisabled || lower >= 0 && upper <= source.size)) {
                throw new AssertionError();
            }
            this.ensureCapacity(this.size + (upper - lower));
            int insertAt = 0;
            int subUpper = lower;
            while (subUpper < upper) {
                int subLower = subUpper;
                if (!$assertionsDisabled && !this.isSorted()) {
                    throw new AssertionError();
                }
                subUpper = (insertAt = Model.search(this.visibles, insertAt, this.size, source.visibles[subLower])) == this.size ? upper : Model.search(source.visibles, subLower, upper, this.visibles[insertAt]);
                int length = subUpper - subLower;
                System.arraycopy(this.visibles, insertAt, this.visibles, insertAt + length, this.size - insertAt);
                System.arraycopy(source.visibles, subLower, this.visibles, insertAt, length);
                this.size += length;
                if (!$assertionsDisabled && !this.isSorted()) {
                    throw new AssertionError();
                }
                this.fireIntervalAdded(this, insertAt, insertAt + length - 1);
            }
            source.hide(lower, upper);
        }

        public void move(Model source, int[] indices) {
            Arrays.sort(indices);
            int i = 0;
            while (i < indices.length) {
                int upper;
                int lower = indices[i];
                for (upper = lower + 1; ++i < indices.length && indices[i] == upper; ++upper) {
                }
                this.move(source, lower, upper);
                int length = upper - lower;
                int j = i;
                while (j < indices.length) {
                    int n = j++;
                    indices[n] = indices[n] - length;
                }
            }
        }

        public void addAll(Collection items) {
            if (!items.isEmpty()) {
                this.choices.addAll(items);
                int length = items.size();
                this.ensureCapacity(this.size + length);
                int max = this.choices.size();
                int i = max - length;
                while (i < max) {
                    this.visibles[this.size++] = i++;
                }
                if (!$assertionsDisabled && !this.isSorted()) {
                    throw new AssertionError();
                }
                this.fireIntervalAdded(this, this.size - length, this.size - 1);
            }
        }

        public void clear() {
            this.choices.clear();
            if (this.size != 0) {
                int oldSize = this.size;
                this.size = 0;
                this.fireIntervalRemoved(this, 0, oldSize - 1);
            }
        }

        static {
            $assertionsDisabled = !(class$org$geotools$gui$swing$DisjointLists == null ? (class$org$geotools$gui$swing$DisjointLists = DisjointLists.class$("org.geotools.gui.swing.DisjointLists")) : class$org$geotools$gui$swing$DisjointLists).desiredAssertionStatus();
        }
    }
}

