/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.geotools.resources.GraphicsUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Vocabulary;

public final class ExceptionMonitor {
    private ExceptionMonitor() {
    }

    public static void show(Component owner, Throwable exception) {
        ExceptionMonitor.show(owner, exception, null);
    }

    public static void show(final Component owner, final Throwable exception, final String message) {
        if (EventQueue.isDispatchThread()) {
            Pane.show(owner, exception, message);
        } else {
            Runnable monitor = new Runnable(){

                public void run() {
                    Pane.show(owner, exception, message);
                }
            };
            try {
                EventQueue.invokeAndWait(monitor);
            }
            catch (InterruptedException error) {
            }
            catch (InvocationTargetException error) {
                Throwable e = error.getTargetException();
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                Utilities.unexpectedException((String)"org.geotools.gui", (String)"ExceptionMonitor", (String)"show", (Throwable)e);
            }
        }
    }

    public static void paintStackTrace(Graphics2D graphics, Rectangle widgetBounds, Throwable exception) {
        GraphicsUtilities.paintStackTrace((Graphics2D)graphics, (Rectangle)widgetBounds, (Throwable)exception);
    }

    public static void main(String[] args) {
        ExceptionMonitor.show(null, new Exception());
    }

    private static final class Pane
    extends JOptionPane
    implements ActionListener {
        private static final int WIDTH = 40;
        private static final int HEIGHT = 300;
        private final Component dialog;
        private final Throwable exception;
        private final Container message;
        private Component trace;
        private boolean traceVisible;
        private final AbstractButton traceButton;
        private final Dimension initialSize;
        private final Vocabulary resources;

        private Pane(Component owner, Throwable exception, Container message, AbstractButton[] buttons, Vocabulary resources) {
            super(message, 0, 2, null, buttons);
            this.exception = exception;
            this.message = message;
            this.resources = resources;
            this.traceButton = buttons[0];
            buttons[0].addActionListener(this);
            buttons[1].addActionListener(this);
            String classname = Utilities.getShortClassName((Object)exception);
            String title = resources.getString(41, (Object)classname);
            JDesktopPane desktop = Pane.getDesktopPaneForComponent(owner);
            if (desktop != null) {
                JInternalFrame dialog = this.createInternalFrame(desktop, title);
                desktop.setLayer(dialog, JDesktopPane.MODAL_LAYER);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                dialog.pack();
                this.dialog = dialog;
            } else {
                JDialog dialog = this.createDialog(owner, title);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                dialog.pack();
                this.dialog = dialog;
            }
            this.initialSize = this.dialog.getSize();
        }

        public static void show(Component owner, Throwable exception, String message) {
            Vocabulary resources = Vocabulary.getResources((Locale)(owner != null ? owner.getLocale() : null));
            if (message == null && (message = exception.getLocalizedMessage()) == null) {
                String classname = Utilities.getShortClassName((Object)exception);
                message = resources.getString(114, (Object)classname);
            }
            JTextArea textArea = new JTextArea(message, 1, 40);
            textArea.setEditable(false);
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setBackground(null);
            textArea.setBorder(null);
            JPanel messageBox = new JPanel(new BorderLayout());
            messageBox.add((Component)textArea, "North");
            Pane pane = new Pane(owner, exception, messageBox, new AbstractButton[]{new JButton(resources.getString(28)), new JButton(resources.getString(14))}, resources);
            pane.dialog.setVisible(true);
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() != this.traceButton) {
                this.dispose();
                return;
            }
            if (this.trace == null) {
                JComponent traceComponent = null;
                for (Throwable cause = this.exception; cause != null; cause = cause.getCause()) {
                    JTextArea text = new JTextArea(1, 40);
                    text.setTabSize(4);
                    text.setText(GraphicsUtilities.printStackTrace((Throwable)cause));
                    text.setEditable(false);
                    JScrollPane scroll = new JScrollPane(text);
                    if (traceComponent != null) {
                        String classname;
                        if (!(traceComponent instanceof JTabbedPane)) {
                            classname = Utilities.getShortClassName((Object)this.exception);
                            JTabbedPane tabs = new JTabbedPane(1, 1);
                            tabs.addTab(classname, traceComponent);
                            traceComponent = tabs;
                        }
                        classname = Utilities.getShortClassName((Object)cause);
                        ((JTabbedPane)traceComponent).addTab(classname, scroll);
                        continue;
                    }
                    traceComponent = scroll;
                }
                if (traceComponent == null) {
                    return;
                }
                traceComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0), traceComponent.getBorder()));
                this.trace = traceComponent;
            }
            this.traceButton.setText(Vocabulary.format((int)(this.traceVisible ? 28 : 67)));
            boolean bl = this.traceVisible = !this.traceVisible;
            if (this.dialog instanceof Dialog) {
                ((Dialog)this.dialog).setResizable(this.traceVisible);
            } else {
                ((JInternalFrame)this.dialog).setResizable(this.traceVisible);
            }
            if (this.traceVisible) {
                this.message.add(this.trace, "Center");
                this.dialog.setSize(this.initialSize.width, 300);
            } else {
                this.message.remove(this.trace);
                this.dialog.setSize(this.initialSize);
            }
            this.dialog.validate();
        }

        private void dispose() {
            if (this.dialog instanceof Window) {
                ((Window)this.dialog).dispose();
            } else {
                ((JInternalFrame)this.dialog).dispose();
            }
        }
    }
}

