/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.measure.Angle;
import org.geotools.measure.AngleFormat;
import org.geotools.measure.CoordinateFormat;
import org.geotools.resources.Arguments;
import org.geotools.resources.SwingUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Vocabulary;

public class FormatChooser
extends JPanel {
    private static final int HISTORY_SIZE = 50;
    private static final Color ERROR_COLOR = Color.RED;
    private static final Map PATTERNS = new HashMap();
    private static final String[] ANGLE_PATTERNS = new String[]{"D.d\u00b0", "D.dd\u00b0", "D.ddd\u00b0", "D\u00b0MM'", "D\u00b0MM.m'", "D\u00b0MM.mm'", "D\u00b0MM.mmm'", "D\u00b0MM'SS\"", "D\u00b0MM'SS.s\""};
    protected Format format;
    private Object value;
    private final JComboBox choices = new JComboBox();
    private final JLabel preview = new JLabel();

    public FormatChooser(Format format) throws IllegalArgumentException {
        super(new GridBagLayout());
        String[] patterns = FormatChooser.getPatterns(format);
        if (patterns != null) {
            MutableComboBoxModel model = (MutableComboBoxModel)this.choices.getModel();
            for (int i = 0; i < patterns.length; ++i) {
                model.addElement(patterns[i]);
            }
        }
        this.choices.setEditable(true);
        this.value = FormatChooser.suggestSampleValue(format);
        this.setFormat(format);
        Vocabulary resources = Vocabulary.getResources((Locale)FormatChooser.getDefaultLocale());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.insets.right = 6;
        c.gridy = 0;
        this.add((Component)new JLabel(resources.getLabel(49)), c);
        ++c.gridy;
        c.insets.top = 3;
        this.add((Component)new JLabel(resources.getLabel(133)), c);
        c.insets.right = 0;
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = 0;
        c.insets.top = 0;
        this.add((Component)this.choices, c);
        ++c.gridy;
        c.insets.top = 3;
        this.add((Component)this.preview, c);
        this.choices.getEditor().getEditorComponent().requestFocus();
        this.choices.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FormatChooser.this.applyPattern(false);
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
    }

    private static synchronized String[] getPatterns(Format format) {
        Locale locale = Locale.getDefault();
        String[][] patterns = (String[][])PATTERNS.get(locale);
        if (patterns == null) {
            patterns = new String[3][];
        }
        if (format instanceof NumberFormat) {
            if (patterns[0] == null) {
                patterns[0] = FormatChooser.getNumberPatterns(locale);
            }
            return patterns[0];
        }
        if (format instanceof DateFormat) {
            if (patterns[1] == null) {
                patterns[1] = FormatChooser.getDatePatterns(locale);
            }
            return patterns[1];
        }
        if (format instanceof AngleFormat || format instanceof CoordinateFormat) {
            if (patterns[2] == null) {
                patterns[2] = ANGLE_PATTERNS;
            }
            return patterns[2];
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static String[] getNumberPatterns(Locale locale) {
        patterns = new LinkedHashSet<String>();
        type = 0;
        block6: while (true) {
            switch (type++) {
                case 0: {
                    format = NumberFormat.getInstance(locale);
                    digits = -1;
                    break;
                }
                case 1: {
                    format = NumberFormat.getNumberInstance(locale);
                    digits = 4;
                    break;
                }
                case 2: {
                    format = NumberFormat.getPercentInstance(locale);
                    digits = 2;
                    break;
                }
                case 3: {
                    format = NumberFormat.getCurrencyInstance(locale);
                    digits = -1;
                    break;
                }
                default: {
                    break block6;
                }
            }
            if (!(var4_4 instanceof DecimalFormat)) continue;
            decimal = (DecimalFormat)var4_4;
            patterns.add(decimal.toLocalizedPattern());
            i = 0;
            while (true) {
                if (i <= var3_3) ** break;
                continue block6;
                var4_4.setMinimumFractionDigits(i);
                var4_4.setMaximumFractionDigits(i);
                patterns.add(decimal.toLocalizedPattern());
                ++i;
            }
            break;
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    private static String[] getDatePatterns(Locale locale) {
        int[] codes = new int[]{3, 2, 1, 0};
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        for (int i = 0; i < codes.length; ++i) {
            for (int j = -1; j < codes.length; ++j) {
                DateFormat format = j < 0 ? DateFormat.getDateInstance(codes[i], locale) : DateFormat.getDateTimeInstance(codes[i], codes[j], locale);
                if (!(format instanceof SimpleDateFormat)) continue;
                patterns.add(((SimpleDateFormat)format).toLocalizedPattern());
            }
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    private static Object suggestSampleValue(Format format) {
        if (format instanceof NumberFormat) {
            return new Double(39.3);
        }
        if (format instanceof DateFormat) {
            return new Date();
        }
        if (format instanceof AngleFormat) {
            return new Angle(39.3);
        }
        if (format instanceof CoordinateFormat) {
            int dimension = ((CoordinateFormat)format).getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
            GeneralDirectPosition point = new GeneralDirectPosition(dimension);
            for (int i = 0; i < dimension; ++i) {
                point.setOrdinate(i, (i & 1) == 0 ? 39.3 : 27.9);
            }
            return point;
        }
        return null;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) throws IllegalArgumentException {
        Format old = this.format;
        this.format = format;
        try {
            this.update();
        }
        catch (IllegalStateException exception) {
            this.format = old;
            IllegalArgumentException e = new IllegalArgumentException(exception.getLocalizedMessage());
            e.initCause(exception);
            throw e;
        }
        this.firePropertyChange("format", old, format);
    }

    public Object getSampleValue() {
        return this.value;
    }

    public void setSampleValue(Object value) throws IllegalArgumentException {
        this.preview.setText(value != null ? this.format.format(value) : null);
        this.preview.setForeground(this.getForeground());
        Object old = this.value;
        this.value = value;
        this.firePropertyChange("sampleValue", old, value);
    }

    public String getPattern() throws IllegalStateException {
        if (this.format instanceof DecimalFormat) {
            return ((DecimalFormat)this.format).toLocalizedPattern();
        }
        if (this.format instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)this.format).toLocalizedPattern();
        }
        if (this.format instanceof AngleFormat) {
            return ((AngleFormat)this.format).toPattern();
        }
        if (this.format instanceof CoordinateFormat) {
            CoordinateFormat format = (CoordinateFormat)this.format;
            int i = format.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
            while (--i >= 0) {
                Format sub = format.getFormat(i);
                if (!(sub instanceof AngleFormat)) continue;
                return ((AngleFormat)sub).toPattern();
            }
        }
        throw new IllegalStateException(Utilities.getShortClassName((Object)this.format));
    }

    public void setPattern(String pattern) throws IllegalStateException, IllegalArgumentException {
        if (this.format instanceof DecimalFormat) {
            ((DecimalFormat)this.format).applyLocalizedPattern(pattern);
        } else if (this.format instanceof SimpleDateFormat) {
            ((SimpleDateFormat)this.format).applyLocalizedPattern(pattern);
        } else if (this.format instanceof AngleFormat) {
            ((AngleFormat)this.format).applyPattern(pattern);
        } else if (this.format instanceof CoordinateFormat) {
            ((CoordinateFormat)this.format).setAnglePattern(pattern);
        } else {
            throw new IllegalStateException(Utilities.getShortClassName((Object)this.format));
        }
        this.update();
    }

    final void update() {
        this.choices.setSelectedItem(this.getPattern());
        try {
            this.preview.setText(this.value != null ? this.format.format(this.value) : null);
            this.preview.setForeground(this.getForeground());
        }
        catch (IllegalArgumentException exception) {
            this.preview.setText(exception.getLocalizedMessage());
            this.preview.setForeground(ERROR_COLOR);
        }
    }

    private boolean applyPattern(boolean add) {
        String pattern = this.choices.getSelectedItem().toString();
        if (pattern.trim().length() == 0) {
            this.update();
            return false;
        }
        try {
            this.setPattern(pattern);
        }
        catch (RuntimeException exception) {
            this.preview.setText(exception.getLocalizedMessage());
            this.preview.setForeground(ERROR_COLOR);
            return false;
        }
        if (add) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.choices.getModel();
            int index = model.getIndexOf(pattern = this.choices.getSelectedItem().toString());
            if (index > 0) {
                model.removeElementAt(index);
            }
            if (index != 0) {
                model.insertElementAt(pattern, 0);
            }
            int size = model.getSize();
            while (size > 50) {
                model.removeElementAt(size - 1);
            }
            if (size != 0) {
                this.choices.setSelectedIndex(0);
            }
        }
        return true;
    }

    public boolean showDialog(Component owner, String title) {
        String old = this.getPattern();
        while (SwingUtilities.showOptionDialog((Component)owner, (Object)this, (String)title)) {
            if (!this.applyPattern(true)) continue;
            return true;
        }
        this.setPattern(old);
        return false;
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        Locale.setDefault(arguments.locale);
        new FormatChooser((Format)new AngleFormat()).showDialog(null, Utilities.getShortName((Class)FormatChooser.class));
        System.exit(0);
    }
}

