/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public final class IconFactory {
    public static final IconFactory DEFAULT = new IconFactory();
    private final ClassLoader loader;
    private final Map icons = new HashMap();

    private IconFactory() {
        this.loader = this.getClass().getClassLoader();
    }

    public synchronized Icon getIcon(String path) {
        URL url;
        Icon icon = (Icon)this.icons.get(path);
        if (icon == null && (url = this.loader.getResource(path)) != null) {
            icon = new ImageIcon(url);
            this.icons.put(path, icon);
        }
        return icon;
    }

    public Icon getIcon(String path, String description) {
        Icon icon = this.getIcon(path);
        if (description != null && icon instanceof ImageIcon) {
            icon = new ImageIcon(((ImageIcon)icon).getImage(), description);
        }
        return icon;
    }

    public JButton getButton(String path, String description, String fallback) {
        Icon icon = this.getIcon(path, description);
        JButton button = icon != null ? new JButton(icon) : new JButton(fallback);
        button.setToolTipText(description);
        return button;
    }
}

