/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.geotools.gui.swing.AutoScroll;
import org.geotools.gui.swing.LoggingTableModel;
import org.geotools.resources.SwingUtilities;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Vocabulary;

public class LoggingPanel
extends JPanel {
    public static final Column LOGGER;
    public static final Column CLASS;
    public static final Column METHOD;
    public static final Column TIME_OF_DAY;
    public static final Column LEVEL;
    public static final Column MESSAGE;
    private static final Color INFO_BACKGROUND;
    private final LoggingTableModel model = new LoggingTableModel();
    private final JTable table = new JTable(this.model);
    private int[] levelValues = new int[0];
    private final List levelColors = new ArrayList();
    private Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LoggingPanel() {
        super(new BorderLayout());
        this.table.setShowGrid(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setGridColor(Color.LIGHT_GRAY);
        this.table.setAutoResizeMode(0);
        this.table.setDefaultRenderer(Object.class, new CellRenderer());
        int width = 300;
        TableColumnModel columns = this.table.getColumnModel();
        int i = this.model.getColumnCount();
        while (--i >= 0) {
            columns.getColumn(i).setPreferredWidth(width);
            width = 80;
        }
        JScrollPane scroll = new JScrollPane(this.table);
        new AutoScroll(scroll.getVerticalScrollBar().getModel());
        this.add((Component)scroll, "Center");
        this.setLevelColor(Level.ALL, Color.GRAY, null);
        this.setLevelColor(Level.CONFIG, null, null);
        this.setLevelColor(Level.WARNING, Color.RED, null);
        this.setLevelColor(Level.SEVERE, Color.WHITE, Color.RED);
    }

    public LoggingPanel(Logger logger) {
        this();
        if (logger == null) {
            logger = Logger.getLogger("");
        }
        logger.addHandler(this.getHandler());
        this.logger = logger;
    }

    public LoggingPanel(String logger) {
        this(Logger.getLogger(logger != null ? logger : ""));
    }

    public Handler getHandler() {
        return this.model;
    }

    public boolean isColumnVisible(Column column) {
        return this.model.isColumnVisible(column.index);
    }

    public void setColumnVisible(Column column, boolean visible) {
        this.model.setColumnVisible(column.index, visible);
    }

    public int getCapacity() {
        return this.model.getCapacity();
    }

    public void setCapacity(int capacity) {
        this.model.setCapacity(capacity);
    }

    public Color getForeground(LogRecord record) {
        return this.getColor(record, 0);
    }

    public Color getBackground(LogRecord record) {
        return this.getColor(record, 1);
    }

    private Color getColor(LogRecord record, int offset) {
        int i = Arrays.binarySearch(this.levelValues, record.getLevel().intValue());
        if (i < 0 && (i = ~i - 1) < 0) {
            return null;
        }
        return (Color)this.levelColors.get(i * 2 + offset);
    }

    public void setLevelColor(Level level, Color foreground, Color background) {
        int value = level.intValue();
        int i = Arrays.binarySearch(this.levelValues, value);
        if (i >= 0) {
            this.levelColors.set((i *= 2) + 0, foreground);
            this.levelColors.set(i + 1, background);
        } else {
            this.levelValues = XArray.insert((int[])this.levelValues, (int)(i ^= 0xFFFFFFFF), (int)1);
            this.levelValues[i] = value;
            this.levelColors.add((i *= 2) + 0, foreground);
            this.levelColors.add(i + 1, background);
        }
        if (!$assertionsDisabled && !XArray.isSorted((int[])this.levelValues)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.levelValues.length * 2 != this.levelColors.size()) {
            throw new AssertionError();
        }
    }

    public void doLayout() {
        TableColumnModel model = this.table.getColumnModel();
        int messageColumn = model.getColumnCount() - 1;
        Container parent = this.table.getParent();
        int delta = parent.getWidth();
        if ((parent = parent.getParent()) instanceof JScrollPane) {
            delta -= ((JScrollPane)parent).getVerticalScrollBar().getPreferredSize().width;
        }
        for (int i = 0; i < messageColumn; ++i) {
            delta -= model.getColumn(i).getWidth();
        }
        TableColumn column = model.getColumn(messageColumn);
        if (delta > Math.max(column.getWidth(), column.getPreferredWidth())) {
            column.setPreferredWidth(delta);
        }
        super.doLayout();
    }

    public Component show(Component owner) {
        Component frame = SwingUtilities.toFrame((Component)owner, (JComponent)this, (String)Vocabulary.format((int)43), (WindowListener)new WindowAdapter(){

            public void windowClosed(WindowEvent event) {
                LoggingPanel.this.dispose();
            }
        });
        frame.setSize(750, 300);
        frame.setVisible(true);
        this.doLayout();
        return frame;
    }

    public void dispose() {
        Handler handler = this.getHandler();
        while (this.logger != null) {
            this.logger.removeHandler(handler);
            this.logger = this.logger.getParent();
        }
        handler.close();
    }

    static {
        $assertionsDisabled = !LoggingPanel.class.desiredAssertionStatus();
        LOGGER = new Column(0);
        CLASS = new Column(1);
        METHOD = new Column(2);
        TIME_OF_DAY = new Column(3);
        LEVEL = new Column(4);
        MESSAGE = new Column(5);
        INFO_BACKGROUND = new Color(240, 240, 240);
    }

    private final class CellRenderer
    extends DefaultTableCellRenderer
    implements TableColumnModelListener {
        private Color foreground = super.getForeground();
        private Color background = super.getBackground();
        private int messageColumn;
        private int lastRow;

        public CellRenderer() {
            LoggingPanel.this.table.getColumnModel().addColumnModelListener(this);
        }

        public void setForeground(Color foreground) {
            this.foreground = foreground;
            super.setForeground(this.foreground);
        }

        public void setBackground(Color background) {
            this.background = background;
            super.setBackground(this.background);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            TableModel candidate;
            boolean isMessage;
            Color foreground = this.foreground;
            Color background = this.background;
            boolean bl = isMessage = columnIndex == this.messageColumn;
            if (!isMessage) {
                background = INFO_BACKGROUND;
            }
            if (rowIndex >= 0 && (candidate = table.getModel()) instanceof LoggingTableModel) {
                LoggingTableModel model = (LoggingTableModel)candidate;
                LogRecord record = model.getLogRecord(rowIndex);
                Color color = LoggingPanel.this.getForeground(record);
                if (color != null) {
                    foreground = color;
                }
                if ((color = LoggingPanel.this.getBackground(record)) != null) {
                    background = color;
                }
            }
            super.setBackground(background);
            super.setForeground(foreground);
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, columnIndex);
            if (isMessage && rowIndex > this.lastRow) {
                int width = component.getPreferredSize().width + 15;
                TableColumn column = table.getColumnModel().getColumn(columnIndex);
                if (width > column.getPreferredWidth()) {
                    column.setPreferredWidth(width);
                }
                if (rowIndex == this.lastRow + 1) {
                    this.lastRow = rowIndex;
                }
            }
            return component;
        }

        private final void update() {
            this.messageColumn = LoggingPanel.this.table.convertColumnIndexToView(LoggingPanel.this.model.getColumnCount() - 1);
        }

        public void columnAdded(TableColumnModelEvent e) {
            this.update();
        }

        public void columnMarginChanged(ChangeEvent e) {
            this.update();
        }

        public void columnMoved(TableColumnModelEvent e) {
            this.update();
        }

        public void columnRemoved(TableColumnModelEvent e) {
            this.update();
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
            this.update();
        }
    }

    public static final class Column {
        final int index;

        Column(int index) {
            this.index = index;
        }
    }
}

