/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import java.awt.EventQueue;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Vocabulary;

final class LoggingTableModel
extends Handler
implements TableModel {
    private static final int[] COLUMN_NAMES;
    private int[] columnNames = COLUMN_NAMES;
    private LogRecord[] records = new LogRecord[16];
    private int capacity = 500;
    private int recordCount;
    private final Map cache = new LinkedHashMap(){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() >= Math.min(LoggingTableModel.this.capacity, 80);
        }
    };
    private final EventListenerList listenerList = new EventListenerList();
    private final DateFormat dateFormat = DateFormat.getTimeInstance(2);
    static final /* synthetic */ boolean $assertionsDisabled;

    public LoggingTableModel() {
        this.setLevel(Level.CONFIG);
        this.setFormatter(new SimpleFormatter());
    }

    public int getCapacity() {
        return this.capacity;
    }

    public synchronized void setCapacity(int capacity) {
        if (this.recordCount != 0) {
            throw new IllegalStateException("Not yet implemented.");
        }
        this.capacity = capacity;
    }

    final boolean isColumnVisible(int index) {
        int key = COLUMN_NAMES[index];
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (this.columnNames[i] != key) continue;
            return true;
        }
        return false;
    }

    final void setColumnVisible(int index, boolean visible) {
        int key = COLUMN_NAMES[index];
        int[] names = new int[COLUMN_NAMES.length];
        int count = 0;
        block0: for (int i = 0; i < COLUMN_NAMES.length; ++i) {
            int toTest = COLUMN_NAMES[i];
            if (toTest == key) {
                if (!visible) continue;
                names[count++] = toTest;
                continue;
            }
            for (int j = 0; j < this.columnNames.length; ++j) {
                if (this.columnNames[j] != toTest) continue;
                names[count++] = toTest;
                continue block0;
            }
        }
        names = XArray.resize((int[])names, (int)count);
        this.columnNames = names;
        this.cache.clear();
        this.fireTableChanged(new TableModelEvent(this, -1));
        if (!$assertionsDisabled && this.isColumnVisible(index) != visible) {
            throw new AssertionError(visible);
        }
    }

    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        int nextSlot = this.recordCount % this.capacity;
        if (nextSlot >= this.records.length) {
            this.records = (LogRecord[])XArray.resize((Object[])this.records, (int)Math.min(this.records.length * 2, this.capacity));
        }
        this.records[nextSlot] = record;
        final TableModelEvent event = ++this.recordCount <= this.capacity ? new TableModelEvent(this, nextSlot, nextSlot, -1, 1) : new TableModelEvent(this, 0, this.capacity - 1, -1, 0);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                LoggingTableModel.this.fireTableChanged(event);
            }
        });
    }

    public synchronized LogRecord getLogRecord(int row) {
        if (!$assertionsDisabled && row >= this.getRowCount()) {
            throw new AssertionError();
        }
        if (this.recordCount > this.capacity) {
            row += this.recordCount % this.capacity;
            row %= this.capacity;
        }
        return this.records[row];
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public synchronized int getRowCount() {
        return Math.min(this.recordCount, this.capacity);
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public String getColumnName(int columnIndex) {
        return Vocabulary.format((int)this.columnNames[columnIndex]);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        LogRecord record = this.getLogRecord(rowIndex);
        String[] row = (String[])this.cache.get(record);
        if (row == null) {
            row = new String[this.getColumnCount()];
            for (int i = 0; i < row.length; ++i) {
                void var6_6;
                switch (this.columnNames[i]) {
                    case 97: {
                        String value = record.getLoggerName();
                        break;
                    }
                    case 12: {
                        String value = LoggingTableModel.getShortClassName(record.getSourceClassName());
                        break;
                    }
                    case 105: {
                        String value = record.getSourceMethodName();
                        break;
                    }
                    case 167: {
                        String value = this.dateFormat.format(new Date(record.getMillis()));
                        break;
                    }
                    case 87: {
                        String value = record.getLevel().getLocalizedName();
                        break;
                    }
                    case 104: {
                        String value = this.getFormatter().formatMessage(record);
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
                row[i] = var6_6;
            }
            this.cache.put(record, row);
            if (!$assertionsDisabled && this.cache.size() > this.capacity) {
                throw new AssertionError();
            }
        }
        return row[columnIndex];
    }

    private static String getShortClassName(String name) {
        if (name != null) {
            int dot = name.lastIndexOf(46);
            if (dot >= 0) {
                name = name.substring(dot + 1);
            }
            name = name.replace('$', '.');
        }
        return name;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void addTableModelListener(TableModelListener listener) {
        this.listenerList.add(TableModelListener.class, listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.listenerList.remove(TableModelListener.class, listener);
    }

    private void fireTableChanged(TableModelEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TableModelListener == null ? LoggingTableModel.class$("javax.swing.event.TableModelListener") : class$javax$swing$event$TableModelListener)) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(event);
        }
    }

    public void flush() {
    }

    public void close() {
    }

    static {
        $assertionsDisabled = !LoggingTableModel.class.desiredAssertionStatus();
        COLUMN_NAMES = new int[]{97, 12, 105, 167, 87, 104};
    }
}

